/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.dao.service.validator.TenantProfileDataValidator;
import org.thingsboard.server.dao.tenant.TenantProfileDao;
import org.thingsboard.server.dao.tenant.TenantProfileService;

@SpringBootTest(classes={TenantProfileDataValidator.class})
class TenantProfileDataValidatorTest {
    @MockBean
    TenantProfileDao tenantProfileDao;
    @MockBean
    TenantProfileService tenantProfileService;
    @SpyBean
    TenantProfileDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    TenantProfileDataValidatorTest() {
    }

    @Test
    void testValidateNameInvocation() {
        TenantProfile tenantProfile = new TenantProfile();
        tenantProfile.setName("Sandbox");
        TenantProfileData tenantProfileData = new TenantProfileData();
        tenantProfileData.setConfiguration((TenantProfileConfiguration)new DefaultTenantProfileConfiguration());
        tenantProfile.setProfileData(tenantProfileData);
        this.validator.validateDataImpl(this.tenantId, tenantProfile);
        ((TenantProfileDataValidator)Mockito.verify((Object)this.validator)).validateString("Tenant profile name", tenantProfile.getName());
    }
}

