/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.customer.CustomerDao;
import org.thingsboard.server.dao.entityview.EntityViewDao;
import org.thingsboard.server.dao.service.validator.EntityViewDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={EntityViewDataValidator.class})
class EntityViewDataValidatorTest {
    @MockBean
    EntityViewDao entityViewDao;
    @MockBean
    TenantService tenantService;
    @MockBean
    CustomerDao customerDao;
    @SpyBean
    EntityViewDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    EntityViewDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        EntityView entityView = new EntityView();
        entityView.setName("view");
        entityView.setType("default");
        entityView.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, entityView);
        ((EntityViewDataValidator)Mockito.verify((Object)this.validator)).validateString("Entity view name", entityView.getName());
        ((EntityViewDataValidator)Mockito.verify((Object)this.validator)).validateString("Entity view type", entityView.getType());
    }
}

