/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.customer.CustomerDao;
import org.thingsboard.server.dao.edge.EdgeDao;
import org.thingsboard.server.dao.service.validator.EdgeDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={EdgeDataValidator.class})
class EdgeDataValidatorTest {
    @MockBean
    EdgeDao edgeDao;
    @MockBean
    TenantService tenantService;
    @MockBean
    CustomerDao customerDao;
    @SpyBean
    EdgeDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    EdgeDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        Edge edge = new Edge();
        edge.setName("Edge 007");
        edge.setType("Silos");
        edge.setSecret("secret");
        edge.setRoutingKey("53c56104-d302-4d6e-97f5-a7a99c7effdc");
        edge.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, edge);
        ((EdgeDataValidator)Mockito.verify((Object)this.validator)).validateString("Edge name", edge.getName());
        ((EdgeDataValidator)Mockito.verify((Object)this.validator)).validateString("Edge type", edge.getType());
    }
}

