/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.service.validator.DashboardDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={DashboardDataValidator.class})
class DashboardDataValidatorTest {
    @MockBean
    TenantService tenantService;
    @SpyBean
    DashboardDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    DashboardDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("flight control");
        dashboard.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, dashboard);
        ((DashboardDataValidator)Mockito.verify((Object)this.validator)).validateString("Dashboard title", dashboard.getTitle());
    }
}

