/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.customer.CustomerDao;
import org.thingsboard.server.dao.service.validator.CustomerDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={CustomerDataValidator.class})
class CustomerDataValidatorTest {
    @MockBean
    CustomerDao customerDao;
    @MockBean
    TenantService tenantService;
    @SpyBean
    CustomerDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    CustomerDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        Customer customer = new Customer();
        customer.setTitle("Customer A");
        customer.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, customer);
        ((CustomerDataValidator)Mockito.verify((Object)this.validator)).validateString("Customer title", customer.getTitle());
    }
}

