/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.CalculatedFieldLinkId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.cf.CalculatedFieldLinkDao;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.validator.CalculatedFieldLinkDataValidator;

@SpringBootTest(classes={CalculatedFieldLinkDataValidator.class})
public class CalculatedFieldLinkDataValidatorTest {
    private final TenantId TENANT_ID = TenantId.fromUUID((UUID)UUID.fromString("2ba09d99-6143-43dc-b645-381fc0c43ebe"));
    private final CalculatedFieldLinkId CALCULATED_FIELD_LINK_ID = new CalculatedFieldLinkId(UUID.fromString("a5609ef4-cb42-43ce-9b23-e090a4878d1c"));
    @MockBean
    private CalculatedFieldLinkDao calculatedFieldLinkDao;
    @SpyBean
    private CalculatedFieldLinkDataValidator validator;

    @Test
    public void testUpdateNonExistingCalculatedField() {
        CalculatedFieldLink calculatedFieldLink = new CalculatedFieldLink(this.CALCULATED_FIELD_LINK_ID);
        calculatedFieldLink.setCalculatedFieldId(new CalculatedFieldId(UUID.fromString("136477af-fd07-4498-b9c9-54fe50e82992")));
        BDDMockito.given((Object)((CalculatedFieldLink)this.calculatedFieldLinkDao.findById(this.TENANT_ID, this.CALCULATED_FIELD_LINK_ID.getId()))).willReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.validator.validateUpdate(this.TENANT_ID, calculatedFieldLink)).isInstanceOf(DataValidationException.class)).hasMessage("Can't update non existing calculated field link!");
    }
}

