/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.cf.CalculatedFieldDao;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.validator.CalculatedFieldDataValidator;
import org.thingsboard.server.dao.usagerecord.DefaultApiLimitService;

@SpringBootTest(classes={CalculatedFieldDataValidator.class})
public class CalculatedFieldDataValidatorTest {
    private final TenantId TENANT_ID = TenantId.fromUUID((UUID)UUID.fromString("7b5229e9-166e-41a9-a257-3b1dafad1b04"));
    private final CalculatedFieldId CALCULATED_FIELD_ID = new CalculatedFieldId(UUID.fromString("060fbe45-fbb2-4549-abf3-f72a6be3cb9f"));
    @MockBean
    private CalculatedFieldDao calculatedFieldDao;
    @MockBean
    private DefaultApiLimitService apiLimitService;
    @SpyBean
    private CalculatedFieldDataValidator validator;

    @Test
    public void testUpdateNonExistingCalculatedField() {
        CalculatedField calculatedField = new CalculatedField(this.CALCULATED_FIELD_ID);
        calculatedField.setType(CalculatedFieldType.SIMPLE);
        calculatedField.setName("Test");
        BDDMockito.given((Object)((CalculatedField)this.calculatedFieldDao.findById(this.TENANT_ID, this.CALCULATED_FIELD_ID.getId()))).willReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.validator.validateUpdate(this.TENANT_ID, calculatedField)).isInstanceOf(DataValidationException.class)).hasMessage("Can't update non existing calculated field!");
    }
}

