/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.dao.device.DeviceProfileDao;
import org.thingsboard.server.dao.service.validator.BaseOtaPackageDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

class BaseOtaPackageDataValidatorTest {
    DeviceProfileDao deviceProfileDao = (DeviceProfileDao)Mockito.mock(DeviceProfileDao.class);
    TenantService tenantService = (TenantService)Mockito.mock(TenantService.class);
    BaseOtaPackageDataValidator<?> validator = (BaseOtaPackageDataValidator)Mockito.spy(BaseOtaPackageDataValidator.class);
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    BaseOtaPackageDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
        ((BaseOtaPackageDataValidator)BDDMockito.willReturn((Object)this.tenantService).given(this.validator)).getTenantService();
        ((BaseOtaPackageDataValidator)BDDMockito.willReturn((Object)this.deviceProfileDao).given(this.validator)).getDeviceProfileDao();
    }

    @Test
    void testValidateNameInvocation() {
        OtaPackageInfo otaPackageInfo = new OtaPackageInfo();
        otaPackageInfo.setTitle("fw");
        otaPackageInfo.setVersion("1.0");
        otaPackageInfo.setType(OtaPackageType.FIRMWARE);
        otaPackageInfo.setTenantId(this.tenantId);
        this.validator.validateImpl(otaPackageInfo);
        ((BaseOtaPackageDataValidator)Mockito.verify(this.validator)).validateString("OtaPackage title", otaPackageInfo.getTitle());
    }
}

