/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.asset.AssetProfileDao;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.service.validator.AssetProfileDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={AssetProfileDataValidator.class})
class AssetProfileDataValidatorTest {
    @MockBean
    AssetProfileDao assetProfileDao;
    @MockBean
    AssetProfileService assetProfileService;
    @MockBean
    TenantService tenantService;
    @MockBean
    QueueService queueService;
    @MockBean
    RuleChainService ruleChainService;
    @MockBean
    DashboardService dashboardService;
    @SpyBean
    AssetProfileDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    AssetProfileDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        AssetProfile assetProfile = new AssetProfile();
        assetProfile.setName("prod");
        assetProfile.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, assetProfile);
        ((AssetProfileDataValidator)Mockito.verify((Object)this.validator)).validateString("Asset profile name", assetProfile.getName());
    }
}

