/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import lombok.Generated;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.BDDMockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.asset.AssetDao;
import org.thingsboard.server.dao.customer.CustomerDao;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.validator.AssetDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={AssetDataValidator.class})
class AssetDataValidatorTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDataValidatorTest.class);
    @MockBean
    AssetDao assetDao;
    @MockBean
    TenantService tenantService;
    @MockBean
    CustomerDao customerDao;
    @Autowired
    AssetDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    AssetDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @ParameterizedTest
    @ValueSource(strings={"coffee", "1", "big box", "\u4e16\u754c", "!", "--", "~!@#$%^&*()_+=-/|\\[]{};:'`\"?<>,.", "\ud83d\udc0c", "!", "Gdy Pomorze nie pomo\u017ce, to pomo\u017ce mo\u017ce morze, a gdy morze nie pomo\u017ce, to pomo\u017ce mo\u017ce Gda\u0144sk"})
    void testAssetName_thenOK(String name) {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName(name);
        this.validator.validateDataImpl(this.tenantId, asset);
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "  ", "\n", "\r\n", "\t", "\u0000", "\u0000\u0000", "\u0001", "\u0002", " ", "\u0000", "\u0000\u0000", "F0929906\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000F0929906", "\u0000F0929906", "F092\u00009906", "F0929906\u0000"})
    void testAssetName_thenDataValidationException(String name) {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName(name);
        DataValidationException exception = (DataValidationException)org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.validator.validateDataImpl(this.tenantId, asset));
        log.warn("Exception message: {}", (Object)exception.getMessage());
        ((AbstractStringAssert)Assertions.assertThat((String)exception.getMessage()).as("message Asset name", new Object[0])).containsPattern((CharSequence)"Asset name .*");
    }
}

