/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.service.validator.AlarmDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;

@SpringBootTest(classes={AlarmDataValidator.class})
class AlarmDataValidatorTest {
    @MockBean
    TenantService tenantService;
    @SpyBean
    AlarmDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    AlarmDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        Alarm alarm = new Alarm();
        alarm.setType("overheating");
        alarm.setOriginator((EntityId)this.tenantId);
        alarm.setSeverity(AlarmSeverity.CRITICAL);
        alarm.setCleared(false);
        alarm.setAcknowledged(false);
        alarm.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, alarm);
        ((AlarmDataValidator)Mockito.verify((Object)this.validator)).validateString("Alarm type", alarm.getType());
    }
}

