/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.service.validator.AdminSettingsDataValidator;
import org.thingsboard.server.dao.settings.AdminSettingsService;

@SpringBootTest(classes={AdminSettingsDataValidator.class})
class AdminSettingsDataValidatorTest {
    @MockBean
    AdminSettingsService adminSettingsService;
    @SpyBean
    AdminSettingsDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    AdminSettingsDataValidatorTest() {
    }

    @Test
    void testValidateNameInvocation() {
        AdminSettings adminSettings = new AdminSettings();
        adminSettings.setKey("jwt");
        adminSettings.setJsonValue(JacksonUtil.toJsonNode((String)"{}"));
        this.validator.validateDataImpl(this.tenantId, adminSettings);
        ((AdminSettingsDataValidator)Mockito.verify((Object)this.validator)).validateString("Key", adminSettings.getKey());
    }
}

