/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.timeseries.sql;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Test;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.service.timeseries.BaseTimeseriesServiceTest;

@DaoSqlTest
public class TimeseriesServiceSqlTest
extends BaseTimeseriesServiceTest {
    @Test
    public void testRemoveLatestAndNoValuePresentInDB() throws ExecutionException, InterruptedException, TimeoutException {
        TsKvEntry tsKvEntry = TimeseriesServiceSqlTest.toTsEntry(42L, this.stringKvEntry);
        this.tsService.save(this.tenantId, (EntityId)this.deviceId, tsKvEntry).get(30L, TimeUnit.SECONDS);
        Optional tsKvEntryOpt = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, "stringKey").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Optional)tsKvEntryOpt).isPresent();
        TimeseriesServiceSqlTest.equalsIgnoreVersion(tsKvEntry, (TsKvEntry)tsKvEntryOpt.get());
        Assertions.assertThat((Long)((TsKvEntry)tsKvEntryOpt.get()).getVersion()).isNotNull();
        this.tsService.removeLatest(this.tenantId, (EntityId)this.deviceId, List.of("stringKey"));
        Awaitility.await().alias("Wait until ts last is removed from the cache").atMost(30L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Optional tsKvEntryAfterRemoval = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, "stringKey").get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((Optional)tsKvEntryAfterRemoval).isNotPresent();
        });
    }
}

