/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.timeseries.sql;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.timeseries.TimeseriesLatestDao;

@DaoSqlTest
public class LatestTimeseriesPerformanceTest
extends AbstractServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LatestTimeseriesPerformanceTest.class);
    private static final String STRING_KEY = "stringKey";
    private static final String LONG_KEY = "longKey";
    private static final String DOUBLE_KEY = "doubleKey";
    private static final String BOOLEAN_KEY = "booleanKey";
    private static final int AMOUNT_OF_UNIQ_KEY = 10000;
    private static final int TIMEOUT = 100;
    private final Random random = new Random();
    @Autowired
    private TimeseriesLatestDao timeseriesLatestDao;
    private ListeningExecutorService testExecutor;
    private EntityId entityId;
    private AtomicLong saveCounter;

    @Before
    public void before() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Assert.assertNotNull((Object)savedTenant);
        this.tenantId = savedTenant.getId();
        this.entityId = new DeviceId(UUID.randomUUID());
        this.saveCounter = new AtomicLong(0L);
        this.testExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(200, (ThreadFactory)ThingsBoardThreadFactory.forName((String)(this.getClass().getSimpleName() + "-test-scope"))));
    }

    @After
    public void after() {
        this.tenantService.deleteTenant(this.tenantId);
        if (this.testExecutor != null) {
            this.testExecutor.shutdownNow();
        }
    }

    @Test
    public void test_save_latest_timeseries() throws Exception {
        this.warmup();
        this.saveCounter.set(0L);
        long startTime = System.currentTimeMillis();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 25000; ++i) {
            futures.add(this.save(this.generateStrEntry(this.getRandomKey())));
            futures.add(this.save(this.generateLngEntry(this.getRandomKey())));
            futures.add(this.save(this.generateDblEntry(this.getRandomKey())));
            futures.add(this.save(this.generateBoolEntry(this.getRandomKey())));
        }
        Futures.allAsList(futures).get(100L, TimeUnit.SECONDS);
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        log.info("Total time: {}", (Object)totalTime);
        log.info("Saved count: {}", (Object)this.saveCounter.get());
        log.warn("Saved per 1 sec: {}", (Object)(this.saveCounter.get() * 1000L / totalTime));
    }

    private void warmup() throws Exception {
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            futures.add(this.save(this.generateStrEntry(i)));
            futures.add(this.save(this.generateLngEntry(i)));
            futures.add(this.save(this.generateDblEntry(i)));
            futures.add(this.save(this.generateBoolEntry(i)));
        }
        Futures.allAsList(futures).get(100L, TimeUnit.SECONDS);
    }

    private ListenableFuture<?> save(TsKvEntry tsKvEntry) {
        return Futures.transformAsync((ListenableFuture)this.testExecutor.submit(() -> this.timeseriesLatestDao.saveLatest(this.tenantId, this.entityId, tsKvEntry)), result -> {
            this.saveCounter.incrementAndGet();
            return result;
        }, (Executor)this.testExecutor);
    }

    private TsKvEntry generateStrEntry(int keyIndex) {
        return new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new StringDataEntry(STRING_KEY + keyIndex, RandomStringUtils.random((int)10)));
    }

    private TsKvEntry generateLngEntry(int keyIndex) {
        return new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new LongDataEntry(LONG_KEY + keyIndex, Long.valueOf(this.random.nextLong())));
    }

    private TsKvEntry generateDblEntry(int keyIndex) {
        return new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new DoubleDataEntry(DOUBLE_KEY + keyIndex, Double.valueOf(this.random.nextDouble())));
    }

    private TsKvEntry generateBoolEntry(int keyIndex) {
        return new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new BooleanDataEntry(BOOLEAN_KEY + keyIndex, Boolean.valueOf(this.random.nextBoolean())));
    }

    private int getRandomKey() {
        return this.random.nextInt(10000);
    }
}

