/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.timeseries.nosql;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.service.DaoNoSqlTest;
import org.thingsboard.server.dao.service.timeseries.BaseTimeseriesServiceTest;

@DaoNoSqlTest
public class TimeseriesServiceNoSqlTest
extends BaseTimeseriesServiceTest {
    @Test
    public void shouldSaveEntryOfEachTypeWithTtl() throws ExecutionException, InterruptedException, TimeoutException {
        long ttlInSec = TimeUnit.SECONDS.toSeconds(3L);
        List<BasicTsKvEntry> timeseries = List.of(new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(1L), (KvEntry)new BooleanDataEntry("test", Boolean.valueOf(true))), new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(2L), (KvEntry)new StringDataEntry("test", "text")), new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(3L), (KvEntry)new LongDataEntry("test", Long.valueOf(15L))), new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(4L), (KvEntry)new DoubleDataEntry("test", Double.valueOf(10.5))), new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(5L), (KvEntry)new JsonDataEntry("test", "{\"test\":\"testValue\"}")));
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        this.tsService.save(this.tenantId, (EntityId)deviceId, timeseries, ttlInSec);
        List fullList = (List)this.tsService.findAll(this.tenantId, (EntityId)deviceId, Collections.singletonList(new BaseReadTsKvQuery("test", 0L, TimeUnit.MINUTES.toMillis(6L), 1000L, 10, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)5L, (long)fullList.size());
        Thread.sleep(TimeUnit.SECONDS.toMillis(ttlInSec + 1L));
        List listAfterTtl = (List)this.tsService.findAll(this.tenantId, (EntityId)deviceId, Collections.singletonList(new BaseReadTsKvQuery("test", 0L, TimeUnit.MINUTES.toMillis(6L), 1000L, 10, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)listAfterTtl.size());
    }

    @Test
    public void testNullValuesOfNoneTargetColumn() throws ExecutionException, InterruptedException, TimeoutException {
        long ts = TimeUnit.MINUTES.toMillis(1L);
        long longValue = 10L;
        BasicTsKvEntry longEntry = new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("temp", Long.valueOf(longValue)));
        double doubleValue = 20.6;
        BasicTsKvEntry doubleEntry = new BasicTsKvEntry(ts, (KvEntry)new DoubleDataEntry("temp", Double.valueOf(doubleValue)));
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)longEntry).get(30L, TimeUnit.SECONDS);
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)doubleEntry).get(30L, TimeUnit.SECONDS);
        List listWithoutAgg = (List)this.tsService.findAll(this.tenantId, (EntityId)deviceId, Collections.singletonList(new BaseReadTsKvQuery("temp", 0L, ts + 1L, 1000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)listWithoutAgg.size());
        Assert.assertTrue((boolean)((TsKvEntry)listWithoutAgg.get(0)).getLongValue().isPresent());
        Assert.assertFalse((boolean)((TsKvEntry)listWithoutAgg.get(0)).getDoubleValue().isPresent());
        Assertions.assertThat((Long)((Long)((TsKvEntry)listWithoutAgg.get(0)).getLongValue().get())).isEqualTo(longValue);
        List listWithAgg = (List)this.tsService.findAll(this.tenantId, (EntityId)deviceId, Collections.singletonList(new BaseReadTsKvQuery("temp", 0L, ts + 1L, 200000L, 3, Aggregation.AVG))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)listWithAgg.size());
        Assert.assertTrue((boolean)((TsKvEntry)listWithAgg.get(0)).getDoubleValue().isPresent());
        double expectedValue = (doubleValue + (double)longValue) / 2.0;
        Assertions.assertThat((Double)((Double)((TsKvEntry)listWithAgg.get(0)).getDoubleValue().get())).isEqualTo(expectedValue);
    }
}

