/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.timeseries.nosql;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.TestPropertySource;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.service.DaoNoSqlTest;
import org.thingsboard.server.dao.service.timeseries.nosql.TimeseriesServiceNoSqlTest;

@DaoNoSqlTest
@TestPropertySource(properties={"cassandra.query.set_null_values_enabled=true"})
public class TimeseriesServiceNoSqlSetNullEnabledTest
extends TimeseriesServiceNoSqlTest {
    @Override
    @Test
    public void testNullValuesOfNoneTargetColumn() throws ExecutionException, InterruptedException, TimeoutException {
        long ts = TimeUnit.MINUTES.toMillis(1L);
        BasicTsKvEntry longEntry = new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("temp", Long.valueOf(0L)));
        double doubleValue = 20.6;
        BasicTsKvEntry doubleEntry = new BasicTsKvEntry(ts, (KvEntry)new DoubleDataEntry("temp", Double.valueOf(doubleValue)));
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)longEntry).get(30L, TimeUnit.SECONDS);
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)doubleEntry).get(30L, TimeUnit.SECONDS);
        List listWithoutAgg = (List)this.tsService.findAll(this.tenantId, (EntityId)deviceId, Collections.singletonList(new BaseReadTsKvQuery("temp", 0L, ts + 1L, 1000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)listWithoutAgg.size());
        Assert.assertFalse((boolean)((TsKvEntry)listWithoutAgg.get(0)).getLongValue().isPresent());
        Assert.assertTrue((boolean)((TsKvEntry)listWithoutAgg.get(0)).getDoubleValue().isPresent());
        Assertions.assertThat((Double)((Double)((TsKvEntry)listWithoutAgg.get(0)).getDoubleValue().get())).isEqualTo(doubleValue);
        List listWithAgg = (List)this.tsService.findAll(this.tenantId, (EntityId)deviceId, Collections.singletonList(new BaseReadTsKvQuery("temp", 0L, ts + 1L, 1000L, 3, Aggregation.AVG))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)listWithAgg.size());
        Assert.assertTrue((boolean)((TsKvEntry)listWithAgg.get(0)).getDoubleValue().isPresent());
        Assertions.assertThat((Double)((Double)((TsKvEntry)listWithAgg.get(0)).getDoubleValue().get())).isEqualTo(doubleValue);
    }
}

