/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.timeseries;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.data.Offset;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseDeleteTsKvQuery;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQueryResult;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.objects.TelemetryEntityView;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.timeseries.TimeseriesService;

public abstract class BaseTimeseriesServiceTest
extends AbstractServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTimeseriesServiceTest.class);
    @Autowired
    protected TimeseriesService tsService;
    @Autowired
    EntityViewService entityViewService;
    @Value(value="${database.ts.type}")
    String databaseTsLatestType;
    protected static final int MAX_TIMEOUT = 30;
    protected static final String STRING_KEY = "stringKey";
    private static final String LONG_KEY = "longKey";
    private static final String DOUBLE_KEY = "doubleKey";
    private static final String BOOLEAN_KEY = "booleanKey";
    protected static final long TS = 42L;
    private static final String DESC_ORDER = "DESC";
    protected KvEntry stringKvEntry = new StringDataEntry("stringKey", "value");
    KvEntry longKvEntry = new LongDataEntry("longKey", Long.valueOf(Long.MAX_VALUE));
    KvEntry doubleKvEntry = new DoubleDataEntry("doubleKey", Double.valueOf(Double.MAX_VALUE));
    KvEntry booleanKvEntry = new BooleanDataEntry("booleanKey", Boolean.TRUE);
    protected TenantId tenantId;
    protected DeviceId deviceId = new DeviceId(Uuids.timeBased());

    @Before
    public void before() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Assert.assertNotNull((Object)savedTenant);
        this.tenantId = savedTenant.getId();
    }

    @After
    public void after() {
        this.tenantService.deleteTenant(this.tenantId);
    }

    @Test
    public void testFindAllLatest() throws Exception {
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 41L);
        this.saveEntries(this.deviceId, 42L);
        this.testLatestTsAndVerify((EntityId)this.deviceId);
    }

    private void testLatestTsAndVerify(EntityId entityId) throws ExecutionException, InterruptedException, TimeoutException {
        List tsList = (List)this.tsService.findAllLatest(this.tenantId, entityId).get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)tsList);
        Assert.assertEquals((long)4L, (long)tsList.size());
        for (TsKvEntry entry : tsList) {
            Assert.assertEquals((long)42L, (long)entry.getTs());
        }
        Collections.sort(tsList, Comparator.comparing(KvEntry::getKey));
        List<TsKvEntry> expected = Arrays.asList(BaseTimeseriesServiceTest.toTsEntry(42L, this.stringKvEntry), BaseTimeseriesServiceTest.toTsEntry(42L, this.longKvEntry), BaseTimeseriesServiceTest.toTsEntry(42L, this.doubleKvEntry), BaseTimeseriesServiceTest.toTsEntry(42L, this.booleanKvEntry));
        Collections.sort(expected, Comparator.comparing(KvEntry::getKey));
        for (int i = 0; i < expected.size(); ++i) {
            TsKvEntry expectedEntry = expected.get(i);
            TsKvEntry actualEntry = (TsKvEntry)tsList.get(i);
            BaseTimeseriesServiceTest.equalsIgnoreVersion(expectedEntry, actualEntry);
        }
    }

    private EntityView saveAndCreateEntityView(DeviceId deviceId, List<String> timeseries) {
        EntityView entityView = new EntityView();
        entityView.setName("entity_view_name");
        entityView.setType("default");
        entityView.setTenantId(this.tenantId);
        TelemetryEntityView keys = new TelemetryEntityView();
        keys.setTimeseries(timeseries);
        entityView.setKeys(keys);
        entityView.setEntityId((EntityId)deviceId);
        return this.entityViewService.saveEntityView(entityView);
    }

    @Test
    public void testFindLatest() throws Exception {
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 41L);
        this.saveEntries(this.deviceId, 42L);
        List entries = (List)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, Collections.singleton(STRING_KEY)).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)entries.size());
        BaseTimeseriesServiceTest.equalsIgnoreVersion(BaseTimeseriesServiceTest.toTsEntry(42L, this.stringKvEntry), (TsKvEntry)entries.get(0));
    }

    @Test
    public void testFindLatestOpt_givenSaveWithHistoricalNonOrderedTS() throws Exception {
        if (this.databaseTsLatestType.equals("cassandra")) {
            return;
        }
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(41L, this.stringKvEntry));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, this.stringKvEntry));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(32L, this.stringKvEntry));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(31L, this.stringKvEntry));
        Optional entryOpt = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, STRING_KEY).get(30L, TimeUnit.SECONDS);
        ((OptionalAssert)Assertions.assertThat((Optional)entryOpt).isNotNull()).isPresent();
        BaseTimeseriesServiceTest.equalsIgnoreVersion(BaseTimeseriesServiceTest.toTsEntry(42L, this.stringKvEntry), (TsKvEntry)entryOpt.get());
    }

    @Test
    public void testFindLatestOpt_givenSaveWithSameTSOverwriteValue() throws Exception {
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new StringDataEntry(STRING_KEY, "old")));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new StringDataEntry(STRING_KEY, "new")));
        Optional entryOpt = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, STRING_KEY).get(30L, TimeUnit.SECONDS);
        ((OptionalAssert)Assertions.assertThat((Optional)entryOpt).isNotNull()).isPresent();
        BaseTimeseriesServiceTest.equalsIgnoreVersion(BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new StringDataEntry(STRING_KEY, "new")), (TsKvEntry)entryOpt.get());
    }

    public void testFindLatestOpt_givenSaveWithSameTSOverwriteTypeAndValue() throws Exception {
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new JsonDataEntry("temp", "{\"hello\":\"world\"}")));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new BooleanDataEntry("temp", Boolean.valueOf(true))));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new LongDataEntry("temp", Long.valueOf(100L))));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new DoubleDataEntry("temp", Double.valueOf(Math.PI))));
        this.save(this.tenantId, this.deviceId, BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new StringDataEntry("temp", "NOOP")));
        Optional entryOpt = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, STRING_KEY).get(30L, TimeUnit.SECONDS);
        ((OptionalAssert)Assertions.assertThat((Optional)entryOpt).isNotNull()).isPresent();
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new StringDataEntry("temp", "NOOP")), entryOpt.orElse(null));
    }

    @Test
    public void testFindLatestOpt() throws Exception {
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 41L);
        this.saveEntries(this.deviceId, 42L);
        Optional entryOpt = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, STRING_KEY).get(30L, TimeUnit.SECONDS);
        ((OptionalAssert)Assertions.assertThat((Optional)entryOpt).isNotNull()).isPresent();
        BaseTimeseriesServiceTest.equalsIgnoreVersion(BaseTimeseriesServiceTest.toTsEntry(42L, this.stringKvEntry), (TsKvEntry)entryOpt.get());
    }

    @Test
    public void testFindLatest_NotFound() throws Exception {
        List entries = (List)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, Collections.singleton(STRING_KEY)).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((List)entries).hasSize(1);
        TsKvEntry tsKvEntry = (TsKvEntry)entries.get(0);
        Assertions.assertThat((Object)tsKvEntry).isNotNull();
        Assertions.assertThat((String)tsKvEntry.getKey()).isEqualTo(STRING_KEY);
        Assertions.assertThat((Comparable)tsKvEntry.getDataType()).isEqualTo((Object)DataType.STRING);
        Assertions.assertThat((Object)tsKvEntry.getValue()).isNull();
        Assertions.assertThat((long)tsKvEntry.getTs()).isCloseTo(System.currentTimeMillis(), Offset.offset((Number)TimeUnit.MINUTES.toMillis(1L)));
    }

    @Test
    public void testFindLatestOpt_NotFound() throws Exception {
        Optional entryOpt = (Optional)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, STRING_KEY).get(30L, TimeUnit.SECONDS);
        ((OptionalAssert)Assertions.assertThat((Optional)entryOpt).isNotNull()).isNotPresent();
    }

    @Test
    public void testFindLatestWithoutLatestUpdate() throws Exception {
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 41L);
        this.saveEntriesWithoutLatest(this.deviceId, 42L);
        List entries = (List)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, Collections.singleton(STRING_KEY)).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)entries.size());
        BaseTimeseriesServiceTest.equalsIgnoreVersion(BaseTimeseriesServiceTest.toTsEntry(41L, this.stringKvEntry), (TsKvEntry)entries.get(0));
    }

    @Test
    public void testFindByQueryAscOrder() throws Exception {
        this.saveEntries(this.deviceId, 39L);
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 41L);
        ArrayList<BaseReadTsKvQuery> queries = new ArrayList<BaseReadTsKvQuery>();
        queries.add(new BaseReadTsKvQuery(STRING_KEY, 39L, 42L, 0L, 1000, Aggregation.NONE, "ASC"));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(39L, this.stringKvEntry), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(40L, this.stringKvEntry), entries.get(1));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(41L, this.stringKvEntry), entries.get(2));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(STRING_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(39L, this.stringKvEntry), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(40L, this.stringKvEntry), entries.get(1));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(41L, this.stringKvEntry), entries.get(2));
    }

    @Test
    public void testFindByQuery_whenPeriodEqualsOneMilisecondPeriod() throws Exception {
        this.saveEntries(this.deviceId, 41L);
        this.saveEntries(this.deviceId, 42L);
        this.saveEntries(this.deviceId, 43L);
        List<BaseReadTsKvQuery> queries = List.of(new BaseReadTsKvQuery(LONG_KEY, 42L, 42L, 1L, 1, Aggregation.COUNT, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(1L))), entries.get(0));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(42L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(1L))), entries.get(0));
    }

    @Test
    public void testFindByQuery_whenPeriodEqualsInterval() throws Exception {
        this.saveEntries(this.deviceId, 41L);
        for (long i = 42L; i <= 142L; i += 10L) {
            this.saveEntries(this.deviceId, i);
        }
        this.saveEntries(this.deviceId, 143L);
        List<BaseReadTsKvQuery> queries = List.of(new BaseReadTsKvQuery(LONG_KEY, 42L, 142L, 100L, 1, Aggregation.COUNT, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(92L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(10L))), entries.get(0));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(92L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(10L))), entries.get(0));
    }

    @Test
    public void testFindByQuery_whenPeriodHaveTwoIntervalWithEqualsLength() throws Exception {
        this.saveEntries(this.deviceId, 41L);
        for (long i = 42L; i <= 100042L; i += 10000L) {
            this.saveEntries(this.deviceId, i);
        }
        this.saveEntries(this.deviceId, 100043L);
        List<BaseReadTsKvQuery> queries = List.of(new BaseReadTsKvQuery(LONG_KEY, 42L, 100041L, 50000L, 1, Aggregation.COUNT, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(75041L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(1));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(75041L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(1));
    }

    @Test
    public void testFindByQuery_whenPeriodHaveTwoInterval_whereSecondShorterThanFirst() throws Exception {
        this.saveEntries(this.deviceId, 41L);
        for (long i = 42L; i <= 80042L; i += 10000L) {
            this.saveEntries(this.deviceId, i);
        }
        this.saveEntries(this.deviceId, 80043L);
        List<BaseReadTsKvQuery> queries = List.of(new BaseReadTsKvQuery(LONG_KEY, 42L, 80042L, 50000L, 1, Aggregation.COUNT, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(65042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(3L))), entries.get(1));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(65042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(3L))), entries.get(1));
    }

    @Test
    public void testFindByQuery_whenPeriodHaveTwoIntervalWithEqualsLength_whereNotAllEntriesInRange() throws Exception {
        for (long i = 41L; i <= 100043L; i += 10000L) {
            this.saveEntries(this.deviceId, i);
        }
        List<BaseReadTsKvQuery> queries = List.of(new BaseReadTsKvQuery(LONG_KEY, 42L, 100041L, 50000L, 1, Aggregation.COUNT, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(75041L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(4L))), entries.get(1));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(75041L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(4L))), entries.get(1));
    }

    @Test
    public void testFindByQuery_whenPeriodHaveTwoInterval_whereSecondShorterThanFirst_andNotAllEntriesInRange() throws Exception {
        for (long i = 41L; i <= 100043L; i += 10000L) {
            this.saveEntries(this.deviceId, i);
        }
        List<BaseReadTsKvQuery> queries = List.of(new BaseReadTsKvQuery(LONG_KEY, 42L, 80042L, 50000L, 1, Aggregation.COUNT, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(65042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(3L))), entries.get(1));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(25042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(5L))), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(65042L, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(3L))), entries.get(1));
    }

    @Test
    public void testFindByQueryDescOrder() throws Exception {
        this.saveEntries(this.deviceId, 39L);
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 41L);
        ArrayList<BaseReadTsKvQuery> queries = new ArrayList<BaseReadTsKvQuery>();
        queries.add(new BaseReadTsKvQuery(STRING_KEY, 39L, 42L, 0L, 1000, Aggregation.NONE, DESC_ORDER));
        List entries = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, queries).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(41L, this.stringKvEntry), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(40L, this.stringKvEntry), entries.get(1));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(39L, this.stringKvEntry), entries.get(2));
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(STRING_KEY));
        entries = (List)this.tsService.findAll(this.tenantId, (EntityId)entityView.getId(), queries).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(41L, this.stringKvEntry), entries.get(0));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(40L, this.stringKvEntry), entries.get(1));
        Assert.assertEquals((Object)BaseTimeseriesServiceTest.toTsEntry(39L, this.stringKvEntry), entries.get(2));
    }

    @Test
    public void testFindAllByQueries_verifyQueryId() throws Exception {
        this.saveEntries(this.deviceId, 42L);
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 32L);
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(STRING_KEY, 32L, 43L, 0L, 1000, Aggregation.NONE, DESC_ORDER);
        this.findAndVerifyQueryId((EntityId)this.deviceId, (ReadTsKvQuery)query);
    }

    @Test
    public void testFindAllByQueries_verifyQueryId_forEntityView() throws Exception {
        this.saveEntries(this.deviceId, 42L);
        this.saveEntries(this.deviceId, 40L);
        this.saveEntries(this.deviceId, 30L);
        EntityView entityView = this.saveAndCreateEntityView(this.deviceId, List.of(LONG_KEY));
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(LONG_KEY, 32L, 43L, 0L, 1000, Aggregation.NONE, DESC_ORDER);
        this.findAndVerifyQueryId((EntityId)entityView.getId(), (ReadTsKvQuery)query);
    }

    private void findAndVerifyQueryId(EntityId entityId, ReadTsKvQuery query) throws InterruptedException, ExecutionException, TimeoutException {
        List results = (List)this.tsService.findAllByQueries(this.tenantId, entityId, List.of(query)).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((List)results).isNotEmpty();
        Assertions.assertThat((List)results).extracting(ReadTsKvQueryResult::getQueryId).containsOnly((Object[])new Integer[]{query.getId()});
    }

    @Test
    public void testDeleteDeviceTsDataWithOverwritingLatest() throws Exception {
        this.saveEntries(this.deviceId, 10000L);
        this.saveEntries(this.deviceId, 20000L);
        this.saveEntries(this.deviceId, 30000L);
        this.saveEntries(this.deviceId, 40000L);
        this.tsService.remove(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseDeleteTsKvQuery(STRING_KEY, 25000L, 45000L, true))).get(30L, TimeUnit.SECONDS);
        List list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(STRING_KEY, 5000L, 45000L, 10000L, 10, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        List latest = (List)this.tsService.findLatest(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(STRING_KEY)).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)20000L, (long)((TsKvEntry)latest.get(0)).getTs());
    }

    @Test
    public void testFindDeviceTsData() throws Exception {
        ArrayList<TsKvEntry> entries = new ArrayList<TsKvEntry>();
        entries.add(this.save(this.deviceId, 5000L, 100L));
        entries.add(this.save(this.deviceId, 15000L, 200L));
        entries.add(this.save(this.deviceId, 25000L, 300L));
        entries.add(this.save(this.deviceId, 35000L, 400L));
        entries.add(this.save(this.deviceId, 45000L, 500L));
        entries.add(this.save(this.deviceId, 55000L, 600L));
        List list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)55000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(600L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)45000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(500L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)35000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(400L), (Object)((TsKvEntry)list.get(2)).getLongValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.AVG))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(150.0), (Object)((TsKvEntry)list.get(0)).getDoubleValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(350.0), (Object)((TsKvEntry)list.get(1)).getDoubleValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(550.0), (Object)((TsKvEntry)list.get(2)).getDoubleValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.SUM))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(300L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(700L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(1100L), (Object)((TsKvEntry)list.get(2)).getLongValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.MIN))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(100L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(300L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(500L), (Object)((TsKvEntry)list.get(2)).getLongValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.MAX))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(200L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(400L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(600L), (Object)((TsKvEntry)list.get(2)).getLongValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.COUNT))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(2)).getLongValue());
        entries.add(this.save(this.deviceId, 65000L, "A1"));
        entries.add(this.save(this.deviceId, 75000L, "A2"));
        entries.add(this.save(this.deviceId, 85000L, "B1"));
        entries.add(this.save(this.deviceId, 95000L, "B2"));
        entries.add(this.save(this.deviceId, 105000L, "C1"));
        entries.add(this.save(this.deviceId, 115000L, "C2"));
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 60000L, 120000L, 20000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)115000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of("C2"), (Object)((TsKvEntry)list.get(0)).getStrValue());
        Assert.assertEquals((long)105000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of("C1"), (Object)((TsKvEntry)list.get(1)).getStrValue());
        Assert.assertEquals((long)95000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of("B2"), (Object)((TsKvEntry)list.get(2)).getStrValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 60000L, 120000L, 20000L, 3, Aggregation.MIN))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)70000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of("A1"), (Object)((TsKvEntry)list.get(0)).getStrValue());
        Assert.assertEquals((long)90000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of("B1"), (Object)((TsKvEntry)list.get(1)).getStrValue());
        Assert.assertEquals((long)110000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of("C1"), (Object)((TsKvEntry)list.get(2)).getStrValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 60000L, 120000L, 20000L, 3, Aggregation.MAX))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)70000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of("A2"), (Object)((TsKvEntry)list.get(0)).getStrValue());
        Assert.assertEquals((long)90000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of("B2"), (Object)((TsKvEntry)list.get(1)).getStrValue());
        Assert.assertEquals((long)110000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of("C2"), (Object)((TsKvEntry)list.get(2)).getStrValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 60000L, 120000L, 20000L, 3, Aggregation.COUNT))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)70000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)90000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)110000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(2)).getLongValue());
    }

    @Test
    public void testFindDeviceLongAndDoubleTsData() throws Exception {
        ArrayList<TsKvEntry> entries = new ArrayList<TsKvEntry>();
        entries.add(this.save(this.deviceId, 5000L, 100L));
        entries.add(this.save(this.deviceId, 15000L, 200.0));
        entries.add(this.save(this.deviceId, 25000L, 300L));
        entries.add(this.save(this.deviceId, 35000L, 400.0));
        entries.add(this.save(this.deviceId, 45000L, 500L));
        entries.add(this.save(this.deviceId, 55000L, 600.0));
        List list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)55000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(600.0), (Object)((TsKvEntry)list.get(0)).getDoubleValue());
        Assert.assertEquals((long)45000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(500L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)35000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(400.0), (Object)((TsKvEntry)list.get(2)).getDoubleValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.AVG))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(150.0), (Object)((TsKvEntry)list.get(0)).getDoubleValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(350.0), (Object)((TsKvEntry)list.get(1)).getDoubleValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(550.0), (Object)((TsKvEntry)list.get(2)).getDoubleValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.SUM))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(300.0), (Object)((TsKvEntry)list.get(0)).getDoubleValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(700.0), (Object)((TsKvEntry)list.get(1)).getDoubleValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(1100.0), (Object)((TsKvEntry)list.get(2)).getDoubleValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.MIN))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(100.0), (Object)((TsKvEntry)list.get(0)).getDoubleValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(300.0), (Object)((TsKvEntry)list.get(1)).getDoubleValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(500.0), (Object)((TsKvEntry)list.get(2)).getDoubleValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.MAX))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(200.0), (Object)((TsKvEntry)list.get(0)).getDoubleValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(400.0), (Object)((TsKvEntry)list.get(1)).getDoubleValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(600.0), (Object)((TsKvEntry)list.get(2)).getDoubleValue());
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 60000L, 20000L, 3, Aggregation.COUNT))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)10000L, (long)((TsKvEntry)list.get(0)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(0)).getLongValue());
        Assert.assertEquals((long)30000L, (long)((TsKvEntry)list.get(1)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(1)).getLongValue());
        Assert.assertEquals((long)50000L, (long)((TsKvEntry)list.get(2)).getTs());
        Assert.assertEquals(Optional.of(2L), (Object)((TsKvEntry)list.get(2)).getLongValue());
    }

    @Test
    public void testSaveTs_RemoveTs_AndSaveTsAgain() throws Exception {
        this.save(this.deviceId, 2000000L, 95L);
        this.save(this.deviceId, 4000000L, 100L);
        this.save(this.deviceId, 6000000L, 105L);
        List list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 8000000L, 200000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        this.tsService.remove(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseDeleteTsKvQuery(LONG_KEY, 0L, 8000000L, false))).get(30L, TimeUnit.SECONDS);
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 8000000L, 200000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)list.size());
        this.save(this.deviceId, 2000000L, 99L);
        this.save(this.deviceId, 4000000L, 104L);
        this.save(this.deviceId, 6000000L, 109L);
        list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery(LONG_KEY, 0L, 8000000L, 200000L, 3, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void shouldSaveEntryOfEachType() throws Exception {
        BasicTsKvEntry booleanEntry = new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(1L), (KvEntry)new BooleanDataEntry("test", Boolean.valueOf(true)));
        BasicTsKvEntry stringEntry = new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(2L), (KvEntry)new StringDataEntry("test", "text"));
        BasicTsKvEntry longEntry = new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(3L), (KvEntry)new LongDataEntry("test", Long.valueOf(15L)));
        BasicTsKvEntry doubleEntry = new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(4L), (KvEntry)new DoubleDataEntry("test", Double.valueOf(10.5)));
        BasicTsKvEntry jsonEntry = new BasicTsKvEntry(TimeUnit.MINUTES.toMillis(5L), (KvEntry)new JsonDataEntry("test", "{\"test\":\"testValue\"}"));
        List<BasicTsKvEntry> timeseries = List.of(booleanEntry, stringEntry, longEntry, doubleEntry, jsonEntry);
        for (TsKvEntry tsKvEntry : timeseries) {
            this.save(this.tenantId, this.deviceId, tsKvEntry);
        }
        List listUntil3Minutes = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery("test", 0L, TimeUnit.MINUTES.toMillis(3L), 1000L, 10, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)listUntil3Minutes.size());
        Assertions.assertThat((List)listUntil3Minutes).containsOnlyOnceElementsOf(List.of(booleanEntry, stringEntry));
        List list = (List)this.tsService.findAll(this.tenantId, (EntityId)this.deviceId, Collections.singletonList(new BaseReadTsKvQuery("test", 0L, TimeUnit.MINUTES.toMillis(6L), 1000L, 10, Aggregation.NONE))).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)5L, (long)list.size());
        Assertions.assertThat((List)list).containsOnlyOnceElementsOf(timeseries);
    }

    @Test
    public void testFindAllByQueriesWithAggregationAndZeroInterval() throws Exception {
        this.testFindAllByQueriesWithAggregationAndInvalidInterval(0L);
    }

    @Test
    public void testFindAllByQueriesWithAggregationAndNegativeInterval() throws Exception {
        this.testFindAllByQueriesWithAggregationAndInvalidInterval(-1L);
    }

    private void testFindAllByQueriesWithAggregationAndInvalidInterval(long interval) {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(STRING_KEY, 42L, 42L, interval, 1000, Aggregation.SUM, DESC_ORDER);
        Assert.assertThrows(IncorrectParameterException.class, () -> this.findAndVerifyQueryId((EntityId)this.deviceId, (ReadTsKvQuery)query));
    }

    private TsKvEntry save(DeviceId deviceId, long ts, long value) throws Exception {
        BasicTsKvEntry entry = new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(LONG_KEY, Long.valueOf(value)));
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)entry).get(30L, TimeUnit.SECONDS);
        return entry;
    }

    private TsKvEntry save(DeviceId deviceId, long ts, double value) throws Exception {
        BasicTsKvEntry entry = new BasicTsKvEntry(ts, (KvEntry)new DoubleDataEntry(LONG_KEY, Double.valueOf(value)));
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)entry).get(30L, TimeUnit.SECONDS);
        return entry;
    }

    private TsKvEntry save(DeviceId deviceId, long ts, String value) throws Exception {
        BasicTsKvEntry entry = new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(LONG_KEY, value));
        this.tsService.save(this.tenantId, (EntityId)deviceId, (TsKvEntry)entry).get(30L, TimeUnit.SECONDS);
        return entry;
    }

    private void save(TenantId tenantId, DeviceId deviceId, TsKvEntry tsKvEntry) throws Exception {
        this.tsService.save(tenantId, (EntityId)deviceId, tsKvEntry).get(30L, TimeUnit.SECONDS);
    }

    private void saveEntries(DeviceId deviceId, long ts) throws ExecutionException, InterruptedException, TimeoutException {
        this.tsService.save(this.tenantId, (EntityId)deviceId, BaseTimeseriesServiceTest.toTsEntry(ts, this.stringKvEntry)).get(30L, TimeUnit.SECONDS);
        this.tsService.save(this.tenantId, (EntityId)deviceId, BaseTimeseriesServiceTest.toTsEntry(ts, this.longKvEntry)).get(30L, TimeUnit.SECONDS);
        this.tsService.save(this.tenantId, (EntityId)deviceId, BaseTimeseriesServiceTest.toTsEntry(ts, this.doubleKvEntry)).get(30L, TimeUnit.SECONDS);
        this.tsService.save(this.tenantId, (EntityId)deviceId, BaseTimeseriesServiceTest.toTsEntry(ts, this.booleanKvEntry)).get(30L, TimeUnit.SECONDS);
    }

    private void saveEntriesWithoutLatest(DeviceId deviceId, long ts) throws ExecutionException, InterruptedException, TimeoutException {
        List<TsKvEntry> tsKvEntry = List.of(BaseTimeseriesServiceTest.toTsEntry(ts, this.stringKvEntry), BaseTimeseriesServiceTest.toTsEntry(ts, this.longKvEntry), BaseTimeseriesServiceTest.toTsEntry(ts, this.doubleKvEntry), BaseTimeseriesServiceTest.toTsEntry(ts, this.booleanKvEntry));
        this.tsService.saveWithoutLatest(this.tenantId, (EntityId)deviceId, tsKvEntry, 0L).get(30L, TimeUnit.SECONDS);
    }

    protected static TsKvEntry toTsEntry(long ts, KvEntry entry) {
        return new BasicTsKvEntry(ts, entry);
    }

    protected static void equalsIgnoreVersion(TsKvEntry expected, TsKvEntry actual) {
        Assert.assertEquals((Object)expected.getKey(), (Object)actual.getKey());
        Assert.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
        Assert.assertEquals((long)expected.getTs(), (long)actual.getTs());
    }
}

