/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.install.sql;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class EntitiesSchemaSqlTest
extends AbstractServiceTest {
    @Value(value="${classpath:sql/schema-entities.sql}")
    private Path installEntitiesPath;
    @Value(value="${classpath:sql/schema-views.sql}")
    private Path installViewsPath;
    @Value(value="${classpath:sql/schema-functions.sql}")
    private Path installFunctionsPath;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Test
    public void testRepeatedInstall() throws IOException {
        String entitiesScript = Files.readString(this.installEntitiesPath);
        String viewsScript = Files.readString(this.installViewsPath);
        String functionsScript = Files.readString(this.installFunctionsPath);
        try {
            for (int i = 1; i <= 2; ++i) {
                this.jdbcTemplate.execute(entitiesScript);
                this.jdbcTemplate.execute(viewsScript);
                this.jdbcTemplate.execute(functionsScript);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to execute reinstall", (Throwable)e);
        }
    }

    @Test
    public void testRepeatedInstall_badScript() {
        String illegalInstallScript = "CREATE TABLE IF NOT EXISTS qwerty ();\nALTER TABLE qwerty ADD COLUMN first VARCHAR(10);";
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.jdbcTemplate.execute(illegalInstallScript));
        try {
            Assertions.assertThatThrownBy(() -> this.jdbcTemplate.execute(illegalInstallScript)).getCause().hasMessageContaining("column").hasMessageContaining("already exists");
        }
        finally {
            this.jdbcTemplate.execute("DROP TABLE qwerty;");
        }
    }
}

