/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.event;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.event.RuleNodeDebugEvent;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.service.AbstractServiceTest;

public abstract class BaseEventServiceTest
extends AbstractServiceTest {
    @Autowired
    EventService eventService;
    long timeBeforeStartTime;
    long startTime;
    long eventTime;
    long endTime;
    long timeAfterEndTime;

    @Before
    public void before() throws ParseException {
        this.timeBeforeStartTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2016-11-01T11:30:00Z").getTime();
        this.startTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2016-11-01T12:00:00Z").getTime();
        this.eventTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2016-11-01T12:30:00Z").getTime();
        this.endTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2016-11-01T13:00:00Z").getTime();
        this.timeAfterEndTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2016-11-01T13:30:30Z").getTime();
    }

    @Test
    public void saveEvent() throws Exception {
        TenantId tenantId = new TenantId(Uuids.timeBased());
        DeviceId devId = new DeviceId(Uuids.timeBased());
        RuleNodeDebugEvent event = this.generateEvent(tenantId, (EntityId)devId);
        this.eventService.saveAsync((Event)event).get();
        List loaded = this.eventService.findLatestEvents(event.getTenantId(), (EntityId)devId, event.getType(), 1);
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals((long)1L, (long)loaded.size());
        Assert.assertEquals((Object)event.getData(), (Object)((EventInfo)loaded.get(0)).getBody().get("data").asText());
    }

    @Test
    public void findEventsByTypeAndTimeAscOrder() throws Exception {
        CustomerId customerId = new CustomerId(Uuids.timeBased());
        TenantId tenantId = TenantId.fromUUID((UUID)Uuids.timeBased());
        this.saveEventWithProvidedTime(this.timeBeforeStartTime, (EntityId)customerId, tenantId);
        Event savedEvent = this.saveEventWithProvidedTime(this.eventTime, (EntityId)customerId, tenantId);
        Event savedEvent2 = this.saveEventWithProvidedTime(this.eventTime + 1L, (EntityId)customerId, tenantId);
        Event savedEvent3 = this.saveEventWithProvidedTime(this.eventTime + 2L, (EntityId)customerId, tenantId);
        this.saveEventWithProvidedTime(this.timeAfterEndTime, (EntityId)customerId, tenantId);
        TimePageLink timePageLink = new TimePageLink(2, 0, "", new SortOrder("ts"), Long.valueOf(this.startTime), Long.valueOf(this.endTime));
        PageData events = this.eventService.findEvents(tenantId, (EntityId)customerId, EventType.DEBUG_RULE_NODE, timePageLink);
        Assert.assertNotNull((Object)events.getData());
        Assert.assertEquals((long)2L, (long)events.getData().size());
        Assert.assertEquals((Object)savedEvent.getUuidId(), (Object)((EventInfo)events.getData().get(0)).getUuidId());
        Assert.assertEquals((Object)savedEvent2.getUuidId(), (Object)((EventInfo)events.getData().get(1)).getUuidId());
        Assert.assertTrue((boolean)events.hasNext());
        events = this.eventService.findEvents(tenantId, (EntityId)customerId, EventType.DEBUG_RULE_NODE, timePageLink.nextPageLink());
        Assert.assertNotNull((Object)events.getData());
        Assert.assertEquals((long)1L, (long)events.getData().size());
        Assert.assertEquals((Object)savedEvent3.getUuidId(), (Object)((EventInfo)events.getData().get(0)).getUuidId());
        Assert.assertFalse((boolean)events.hasNext());
        this.eventService.cleanupEvents(this.timeBeforeStartTime - 1L, this.timeAfterEndTime + 1L, true);
    }

    @Test
    public void findEventsByTypeAndTimeDescOrder() throws Exception {
        CustomerId customerId = new CustomerId(Uuids.timeBased());
        TenantId tenantId = TenantId.fromUUID((UUID)Uuids.timeBased());
        this.saveEventWithProvidedTime(this.timeBeforeStartTime, (EntityId)customerId, tenantId);
        Event savedEvent = this.saveEventWithProvidedTime(this.eventTime, (EntityId)customerId, tenantId);
        Event savedEvent2 = this.saveEventWithProvidedTime(this.eventTime + 1L, (EntityId)customerId, tenantId);
        Event savedEvent3 = this.saveEventWithProvidedTime(this.eventTime + 2L, (EntityId)customerId, tenantId);
        this.saveEventWithProvidedTime(this.timeAfterEndTime, (EntityId)customerId, tenantId);
        TimePageLink timePageLink = new TimePageLink(2, 0, "", new SortOrder("ts", SortOrder.Direction.DESC), Long.valueOf(this.startTime), Long.valueOf(this.endTime));
        PageData events = this.eventService.findEvents(tenantId, (EntityId)customerId, EventType.DEBUG_RULE_NODE, timePageLink);
        Assert.assertNotNull((Object)events.getData());
        Assert.assertEquals((long)2L, (long)events.getData().size());
        Assert.assertEquals((Object)savedEvent3.getUuidId(), (Object)((EventInfo)events.getData().get(0)).getUuidId());
        Assert.assertEquals((Object)savedEvent2.getUuidId(), (Object)((EventInfo)events.getData().get(1)).getUuidId());
        Assert.assertTrue((boolean)events.hasNext());
        events = this.eventService.findEvents(tenantId, (EntityId)customerId, EventType.DEBUG_RULE_NODE, timePageLink.nextPageLink());
        Assert.assertNotNull((Object)events.getData());
        Assert.assertEquals((long)1L, (long)events.getData().size());
        Assert.assertEquals((Object)savedEvent.getUuidId(), (Object)((EventInfo)events.getData().get(0)).getUuidId());
        Assert.assertFalse((boolean)events.hasNext());
        this.eventService.cleanupEvents(this.timeBeforeStartTime - 1L, this.timeAfterEndTime + 1L, true);
    }

    @Test
    public void findLatestDebugRuleNodeInEvent() throws Exception {
        CustomerId customerId = new CustomerId(Uuids.timeBased());
        TenantId tenantId = TenantId.fromUUID((UUID)Uuids.timeBased());
        Event event1 = this.saveEventWithProvidedTimeAndEventType(this.eventTime, "IN", (EntityId)customerId, tenantId);
        Event event2 = this.saveEventWithProvidedTimeAndEventType(this.eventTime + 1L, "IN", (EntityId)customerId, tenantId);
        EventInfo event = this.eventService.findLatestDebugRuleNodeInEvent(tenantId, (EntityId)customerId);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)event2.getUuidId(), (Object)event.getUuidId());
        this.eventService.cleanupEvents(this.timeBeforeStartTime - 1L, this.timeAfterEndTime + 1L, true);
    }

    private Event saveEventWithProvidedTime(long time, EntityId entityId, TenantId tenantId) throws Exception {
        return this.saveEventWithProvidedTimeAndEventType(time, null, entityId, tenantId);
    }

    private Event saveEventWithProvidedTimeAndEventType(long time, String eventType, EntityId entityId, TenantId tenantId) throws Exception {
        RuleNodeDebugEvent event = this.generateEvent(tenantId, entityId, eventType);
        event.setId((UUIDBased)new EventId(Uuids.timeBased()));
        event.setCreatedTime(time);
        this.eventService.saveAsync((Event)event).get();
        return event;
    }
}

