/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.attributes.sql;

import java.io.Serializable;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.VersionedCacheKey;
import org.thingsboard.server.cache.VersionedTbCache;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.dao.attributes.AttributeCacheKey;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class AttributeCacheServiceSqlTest
extends AbstractServiceTest {
    private static final String TEST_KEY = "key";
    private static final String TEST_VALUE = "value";
    private static final DeviceId DEVICE_ID = new DeviceId(UUID.randomUUID());
    @Autowired
    VersionedTbCache<AttributeCacheKey, AttributeKvEntry> cache;

    @Test
    public void testPutAndGet() {
        AttributeCacheKey testKey = new AttributeCacheKey(AttributeScope.CLIENT_SCOPE, (EntityId)DEVICE_ID, TEST_KEY);
        BaseAttributeKvEntry testValue = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(TEST_KEY, TEST_VALUE), 1L, Long.valueOf(1L));
        this.cache.put((VersionedCacheKey)testKey, (Serializable)testValue);
        TbCacheValueWrapper wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertEquals((Object)testValue, (Object)wrapper.get());
        BaseAttributeKvEntry testValue2 = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(TEST_KEY, TEST_VALUE), 1L, Long.valueOf(2L));
        this.cache.put((VersionedCacheKey)testKey, (Serializable)testValue2);
        wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertEquals((Object)testValue2, (Object)wrapper.get());
        BaseAttributeKvEntry testValue3 = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(TEST_KEY, TEST_VALUE), 1L, Long.valueOf(0L));
        this.cache.put((VersionedCacheKey)testKey, (Serializable)testValue3);
        wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertEquals((Object)testValue2, (Object)wrapper.get());
        this.cache.evict((VersionedCacheKey)testKey);
    }

    @Test
    public void testEvictWithVersion() {
        AttributeCacheKey testKey = new AttributeCacheKey(AttributeScope.CLIENT_SCOPE, (EntityId)DEVICE_ID, TEST_KEY);
        BaseAttributeKvEntry testValue = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(TEST_KEY, TEST_VALUE), 1L, Long.valueOf(1L));
        this.cache.put((VersionedCacheKey)testKey, (Serializable)testValue);
        TbCacheValueWrapper wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertEquals((Object)testValue, (Object)wrapper.get());
        this.cache.evict((VersionedCacheKey)testKey, Long.valueOf(2L));
        wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertNull((Object)wrapper.get());
        this.cache.evict((VersionedCacheKey)testKey);
    }

    @Test
    public void testEvict() {
        AttributeCacheKey testKey = new AttributeCacheKey(AttributeScope.CLIENT_SCOPE, (EntityId)DEVICE_ID, TEST_KEY);
        BaseAttributeKvEntry testValue = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(TEST_KEY, TEST_VALUE), 1L, Long.valueOf(1L));
        this.cache.put((VersionedCacheKey)testKey, (Serializable)testValue);
        TbCacheValueWrapper wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertEquals((Object)testValue, (Object)wrapper.get());
        this.cache.evict((VersionedCacheKey)testKey);
        wrapper = this.cache.get((VersionedCacheKey)testKey);
        Assert.assertNull((Object)wrapper);
    }
}

