/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.attributes;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.service.AbstractServiceTest;

public abstract class BaseAttributesServiceTest
extends AbstractServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAttributesServiceTest.class);
    private static final String OLD_VALUE = "OLD VALUE";
    private static final String NEW_VALUE = "NEW VALUE";
    @Autowired
    private AttributesService attributesService;

    @Before
    public void before() {
    }

    @Test
    public void saveAndFetch() throws Exception {
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        StringDataEntry attrValue = new StringDataEntry("attribute1", "value1");
        BaseAttributeKvEntry attr = new BaseAttributeKvEntry((KvEntry)attrValue, 42L);
        this.attributesService.save(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, Collections.singletonList(attr)).get();
        Optional saved = (Optional)this.attributesService.find(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, attr.getKey()).get();
        Assert.assertTrue((boolean)saved.isPresent());
        this.equalsIgnoreVersion((AttributeKvEntry)attr, (AttributeKvEntry)saved.get());
    }

    @Test
    public void saveMultipleTypeAndFetch() throws Exception {
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        StringDataEntry attrOldValue = new StringDataEntry("attribute1", "value1");
        BaseAttributeKvEntry attrOld = new BaseAttributeKvEntry((KvEntry)attrOldValue, 42L);
        this.attributesService.save(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, Collections.singletonList(attrOld)).get();
        Optional saved = (Optional)this.attributesService.find(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, attrOld.getKey()).get();
        Assert.assertTrue((boolean)saved.isPresent());
        this.equalsIgnoreVersion((AttributeKvEntry)attrOld, (AttributeKvEntry)saved.get());
        StringDataEntry attrNewValue = new StringDataEntry("attribute1", "value2");
        BaseAttributeKvEntry attrNew = new BaseAttributeKvEntry((KvEntry)attrNewValue, 73L);
        this.attributesService.save(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, Collections.singletonList(attrNew)).get();
        saved = (Optional)this.attributesService.find(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, attrOld.getKey()).get();
        Assert.assertTrue((boolean)saved.isPresent());
        this.equalsIgnoreVersion((AttributeKvEntry)attrNew, (AttributeKvEntry)saved.get());
    }

    @Test
    public void findAll() throws Exception {
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        StringDataEntry attrAOldValue = new StringDataEntry("A", "value1");
        BaseAttributeKvEntry attrAOld = new BaseAttributeKvEntry((KvEntry)attrAOldValue, 42L);
        StringDataEntry attrANewValue = new StringDataEntry("A", "value2");
        BaseAttributeKvEntry attrANew = new BaseAttributeKvEntry((KvEntry)attrANewValue, 73L);
        StringDataEntry attrBNewValue = new StringDataEntry("B", "value3");
        BaseAttributeKvEntry attrBNew = new BaseAttributeKvEntry((KvEntry)attrBNewValue, 73L);
        this.attributesService.save(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, Collections.singletonList(attrAOld)).get();
        this.attributesService.save(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, Collections.singletonList(attrANew)).get();
        this.attributesService.save(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE, Collections.singletonList(attrBNew)).get();
        List saved = (List)this.attributesService.findAll(SYSTEM_TENANT_ID, (EntityId)deviceId, AttributeScope.CLIENT_SCOPE).get();
        Assert.assertNotNull((Object)saved);
        Assert.assertEquals((long)2L, (long)saved.size());
        this.equalsIgnoreVersion((AttributeKvEntry)attrANew, (AttributeKvEntry)saved.get(0));
        this.equalsIgnoreVersion((AttributeKvEntry)attrBNew, (AttributeKvEntry)saved.get(1));
    }

    @Test
    public void testDummyRequestWithEmptyResult() throws Exception {
        ListenableFuture future = this.attributesService.find(new TenantId(UUID.randomUUID()), (EntityId)new DeviceId(UUID.randomUUID()), AttributeScope.SERVER_SCOPE, "TEST");
        Assert.assertNotNull((Object)future);
        Optional result = (Optional)future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentFetchAndUpdate() throws Exception {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        ListeningExecutorService pool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2));
        try {
            for (int i = 0; i < 100; ++i) {
                DeviceId deviceId = new DeviceId(UUID.randomUUID());
                this.testConcurrentFetchAndUpdate(tenantId, deviceId, pool);
            }
        }
        finally {
            pool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentFetchAndUpdateMulti() throws Exception {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        ListeningExecutorService pool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2));
        try {
            for (int i = 0; i < 100; ++i) {
                DeviceId deviceId = new DeviceId(UUID.randomUUID());
                this.testConcurrentFetchAndUpdateMulti(tenantId, deviceId, pool);
            }
        }
        finally {
            pool.shutdownNow();
        }
    }

    @Test
    public void testFetchAndUpdateEmpty() throws Exception {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        AttributeScope scope = AttributeScope.SERVER_SCOPE;
        String key = "TEST";
        Optional emptyValue = (Optional)this.attributesService.find(tenantId, (EntityId)deviceId, scope, key).get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)emptyValue.isEmpty());
        this.saveAttribute(tenantId, deviceId, scope, key, NEW_VALUE);
        Assert.assertEquals((Object)NEW_VALUE, (Object)this.getAttributeValue(tenantId, deviceId, scope, key));
    }

    @Test
    public void testFetchAndUpdateMulti() throws Exception {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        AttributeScope scope = AttributeScope.SERVER_SCOPE;
        String key1 = "TEST1";
        String key2 = "TEST2";
        List<String> value = this.getAttributeValues(tenantId, deviceId, scope, Arrays.asList(key1, key2));
        Assert.assertTrue((boolean)value.isEmpty());
        this.saveAttribute(tenantId, deviceId, scope, key1, OLD_VALUE);
        value = this.getAttributeValues(tenantId, deviceId, scope, Arrays.asList(key1, key2));
        Assert.assertEquals((long)1L, (long)value.size());
        Assert.assertEquals((Object)OLD_VALUE, (Object)value.get(0));
        this.saveAttribute(tenantId, deviceId, scope, key2, NEW_VALUE);
        value = this.getAttributeValues(tenantId, deviceId, scope, Arrays.asList(key1, key2));
        Assert.assertEquals((long)2L, (long)value.size());
        Assert.assertTrue((boolean)value.contains(OLD_VALUE));
        Assert.assertTrue((boolean)value.contains(NEW_VALUE));
        this.saveAttribute(tenantId, deviceId, scope, key1, NEW_VALUE);
        value = this.getAttributeValues(tenantId, deviceId, scope, Arrays.asList(key1, key2));
        Assert.assertEquals((long)2L, (long)value.size());
        Assert.assertEquals((Object)NEW_VALUE, (Object)value.get(0));
        Assert.assertEquals((Object)NEW_VALUE, (Object)value.get(1));
    }

    @Test
    public void testFindAllKeysByEntityId() {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        this.saveAttribute(tenantId, deviceId, AttributeScope.SERVER_SCOPE, "key1", "123");
        this.saveAttribute(tenantId, deviceId, AttributeScope.SERVER_SCOPE, "key2", "123");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> {
            List keys = this.attributesService.findAllKeysByEntityIds(tenantId, List.of(deviceId));
            Assertions.assertThat((List)keys).containsOnly((Object[])new String[]{"key1", "key2"});
        });
    }

    @Test
    public void testFindAllKeysByEntityIdAndAttributeType() {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        this.saveAttribute(tenantId, deviceId, AttributeScope.SERVER_SCOPE, "key1", "123");
        this.saveAttribute(tenantId, deviceId, AttributeScope.SERVER_SCOPE, "key2", "123");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> {
            List keys = this.attributesService.findAllKeysByEntityIds(tenantId, List.of(deviceId), AttributeScope.SERVER_SCOPE.name());
            Assertions.assertThat((List)keys).containsOnly((Object[])new String[]{"key1", "key2"});
        });
    }

    @Test
    public void testFindAllByEntityIdAndAttributeType() {
        TenantId tenantId = new TenantId(UUID.randomUUID());
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        this.saveAttribute(tenantId, deviceId, AttributeScope.SERVER_SCOPE, "key1", "123");
        this.saveAttribute(tenantId, deviceId, AttributeScope.SERVER_SCOPE, "key2", "123");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> {
            List attributes = (List)this.attributesService.findAll(tenantId, (EntityId)deviceId, AttributeScope.SERVER_SCOPE).get();
            Assertions.assertThat((List)attributes).extracting(KvEntry::getKey).containsOnly((Object[])new String[]{"key1", "key2"});
        });
    }

    private void testConcurrentFetchAndUpdate(TenantId tenantId, DeviceId deviceId, ListeningExecutorService pool) throws Exception {
        AttributeScope scope = AttributeScope.SERVER_SCOPE;
        String key = "TEST";
        this.saveAttribute(tenantId, deviceId, scope, key, OLD_VALUE);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(pool.submit(() -> {
            String value = this.getAttributeValue(tenantId, deviceId, scope, key);
            Assert.assertTrue((value.equals(OLD_VALUE) || value.equals(NEW_VALUE) ? 1 : 0) != 0);
        }));
        futures.add(pool.submit(() -> this.saveAttribute(tenantId, deviceId, scope, key, NEW_VALUE)));
        Futures.allAsList(futures).get(10L, TimeUnit.SECONDS);
        String attributeValue = this.getAttributeValue(tenantId, deviceId, scope, key);
        if (!NEW_VALUE.equals(attributeValue)) {
            System.out.println();
        }
        Assert.assertEquals((Object)NEW_VALUE, (Object)this.getAttributeValue(tenantId, deviceId, scope, key));
    }

    private void testConcurrentFetchAndUpdateMulti(TenantId tenantId, DeviceId deviceId, ListeningExecutorService pool) throws Exception {
        AttributeScope scope = AttributeScope.SERVER_SCOPE;
        String key1 = "TEST1";
        String key2 = "TEST2";
        this.saveAttribute(tenantId, deviceId, scope, key1, OLD_VALUE);
        this.saveAttribute(tenantId, deviceId, scope, key2, OLD_VALUE);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(pool.submit(() -> {
            List<String> value = this.getAttributeValues(tenantId, deviceId, scope, Arrays.asList(key1, key2));
            Assert.assertEquals((long)2L, (long)value.size());
            Assert.assertTrue((value.contains(OLD_VALUE) || value.contains(NEW_VALUE) ? 1 : 0) != 0);
        }));
        futures.add(pool.submit(() -> {
            this.saveAttribute(tenantId, deviceId, scope, key1, NEW_VALUE);
            this.saveAttribute(tenantId, deviceId, scope, key2, NEW_VALUE);
        }));
        Futures.allAsList(futures).get(10L, TimeUnit.SECONDS);
        List<String> newResult = this.getAttributeValues(tenantId, deviceId, scope, Arrays.asList(key1, key2));
        Assert.assertEquals((long)2L, (long)newResult.size());
        Assert.assertEquals((Object)NEW_VALUE, (Object)newResult.get(0));
        Assert.assertEquals((Object)NEW_VALUE, (Object)newResult.get(1));
    }

    private String getAttributeValue(TenantId tenantId, DeviceId deviceId, AttributeScope scope, String key) {
        try {
            Optional entry = (Optional)this.attributesService.find(tenantId, (EntityId)deviceId, scope, key).get(10L, TimeUnit.SECONDS);
            return ((AttributeKvEntry)entry.orElseThrow(RuntimeException::new)).getStrValue().orElse("Unknown");
        }
        catch (Exception e) {
            log.warn("Failed to get attribute", e.getCause());
            throw new RuntimeException(e);
        }
    }

    private List<String> getAttributeValues(TenantId tenantId, DeviceId deviceId, AttributeScope scope, List<String> keys) {
        try {
            List entry = (List)this.attributesService.find(tenantId, (EntityId)deviceId, scope, keys).get(10L, TimeUnit.SECONDS);
            return entry.stream().map(e -> e.getStrValue().orElse(null)).collect(Collectors.toList());
        }
        catch (Exception e2) {
            log.warn("Failed to get attributes", e2.getCause());
            throw new RuntimeException(e2);
        }
    }

    private void saveAttribute(TenantId tenantId, DeviceId deviceId, AttributeScope scope, String key, String s) {
        try {
            BaseAttributeKvEntry newEntry = new BaseAttributeKvEntry(System.currentTimeMillis(), (KvEntry)new StringDataEntry(key, s));
            this.attributesService.save(tenantId, (EntityId)deviceId, scope, Collections.singletonList(newEntry)).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("Failed to save attribute", e.getCause());
            Assert.assertNull((Object)e);
        }
    }

    private void equalsIgnoreVersion(AttributeKvEntry expected, AttributeKvEntry actual) {
        Assert.assertEquals((Object)expected.getKey(), (Object)actual.getKey());
        Assert.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
        Assert.assertEquals((long)expected.getLastUpdateTs(), (long)actual.getLastUpdateTs());
    }
}

