/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.common.data.widget.WidgetsBundleFilter;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.widget.WidgetsBundleService;

@DaoSqlTest
public class WidgetsBundleServiceTest
extends AbstractServiceTest {
    @Autowired
    WidgetsBundleService widgetsBundleService;
    private AbstractServiceTest.IdComparator<WidgetsBundle> idComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveWidgetsBundle() throws IOException {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        widgetsBundle.setTitle("My first widgets bundle");
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        Assert.assertNotNull((Object)savedWidgetsBundle);
        Assert.assertNotNull((Object)savedWidgetsBundle.getId());
        Assert.assertNotNull((Object)savedWidgetsBundle.getAlias());
        Assert.assertTrue((savedWidgetsBundle.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)widgetsBundle.getTenantId(), (Object)savedWidgetsBundle.getTenantId());
        Assert.assertEquals((Object)widgetsBundle.getTitle(), (Object)savedWidgetsBundle.getTitle());
        savedWidgetsBundle.setTitle("My new widgets bundle");
        this.widgetsBundleService.saveWidgetsBundle(savedWidgetsBundle);
        WidgetsBundle foundWidgetsBundle = this.widgetsBundleService.findWidgetsBundleById(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertEquals((Object)foundWidgetsBundle.getTitle(), (Object)savedWidgetsBundle.getTitle());
        this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
    }

    @Test
    public void testSaveWidgetsBundleWithEmptyTitle() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        Assertions.assertThrows(DataValidationException.class, () -> this.widgetsBundleService.saveWidgetsBundle(widgetsBundle));
    }

    @Test
    public void testSaveWidgetsBundleWithInvalidTenant() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTitle("My widgets bundle");
        widgetsBundle.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        Assertions.assertThrows(DataValidationException.class, () -> this.widgetsBundleService.saveWidgetsBundle(widgetsBundle));
    }

    @Test
    public void testUpdateWidgetsBundleTenant() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTitle("My widgets bundle");
        widgetsBundle.setTenantId(this.tenantId);
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        savedWidgetsBundle.setTenantId(TenantId.fromUUID((UUID)ModelConstants.NULL_UUID));
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.widgetsBundleService.saveWidgetsBundle(savedWidgetsBundle));
        }
        finally {
            this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
        }
    }

    @Test
    public void testUpdateWidgetsBundleAlias() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTitle("My widgets bundle");
        widgetsBundle.setTenantId(this.tenantId);
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        savedWidgetsBundle.setAlias("new_alias");
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.widgetsBundleService.saveWidgetsBundle(savedWidgetsBundle));
        }
        finally {
            this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
        }
    }

    @Test
    public void testFindWidgetsBundleById() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        widgetsBundle.setTitle("My widgets bundle");
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        WidgetsBundle foundWidgetsBundle = this.widgetsBundleService.findWidgetsBundleById(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertNotNull((Object)foundWidgetsBundle);
        Assert.assertEquals((Object)savedWidgetsBundle, (Object)foundWidgetsBundle);
        this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
    }

    @Test
    public void testFindWidgetsBundleByTenantIdAndAlias() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        widgetsBundle.setTitle("My widgets bundle");
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        WidgetsBundle foundWidgetsBundle = this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(this.tenantId, savedWidgetsBundle.getAlias());
        Assert.assertNotNull((Object)foundWidgetsBundle);
        Assert.assertEquals((Object)savedWidgetsBundle, (Object)foundWidgetsBundle);
        this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
    }

    @Test
    public void testDeleteWidgetsBundle() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        widgetsBundle.setTitle("My widgets bundle");
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        WidgetsBundle foundWidgetsBundle = this.widgetsBundleService.findWidgetsBundleById(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertNotNull((Object)foundWidgetsBundle);
        this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
        foundWidgetsBundle = this.widgetsBundleService.findWidgetsBundleById(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertNull((Object)foundWidgetsBundle);
    }

    @Test
    public void testFindSystemWidgetsBundlesByPageLink() {
        TenantId tenantId = TenantId.fromUUID((UUID)ModelConstants.NULL_UUID);
        List systemWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(tenantId);
        ArrayList<WidgetsBundle> createdWidgetsBundles = new ArrayList<WidgetsBundle>();
        for (int i = 0; i < 235; ++i) {
            WidgetsBundle widgetsBundle = new WidgetsBundle();
            widgetsBundle.setTenantId(tenantId);
            widgetsBundle.setTitle("Widgets bundle " + i);
            createdWidgetsBundles.add(this.widgetsBundleService.saveWidgetsBundle(widgetsBundle));
        }
        ArrayList widgetsBundles = new ArrayList(createdWidgetsBundles);
        widgetsBundles.addAll(systemWidgetsBundles);
        List loadedWidgetsBundles = new ArrayList();
        PageLink pageLink = new PageLink(19);
        PageData pageData = null;
        do {
            pageData = this.widgetsBundleService.findSystemWidgetsBundlesByPageLink(WidgetsBundleFilter.fromTenantId((TenantId)tenantId), pageLink);
            loadedWidgetsBundles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(widgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(widgetsBundles, loadedWidgetsBundles);
        for (WidgetsBundle widgetsBundle : createdWidgetsBundles) {
            this.widgetsBundleService.deleteWidgetsBundle(tenantId, widgetsBundle.getId());
        }
        loadedWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(tenantId);
        Collections.sort(systemWidgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals((Object)systemWidgetsBundles, loadedWidgetsBundles);
    }

    @Test
    public void testFindSystemWidgetsBundles() {
        TenantId tenantId = TenantId.fromUUID((UUID)ModelConstants.NULL_UUID);
        List systemWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(tenantId);
        ArrayList<WidgetsBundle> createdWidgetsBundles = new ArrayList<WidgetsBundle>();
        for (int i = 0; i < 135; ++i) {
            WidgetsBundle widgetsBundle = new WidgetsBundle();
            widgetsBundle.setTenantId(tenantId);
            widgetsBundle.setTitle("Widgets bundle " + i);
            createdWidgetsBundles.add(this.widgetsBundleService.saveWidgetsBundle(widgetsBundle));
        }
        ArrayList widgetsBundles = new ArrayList(createdWidgetsBundles);
        widgetsBundles.addAll(systemWidgetsBundles);
        List loadedWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(tenantId);
        Collections.sort(widgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(widgetsBundles, (Object)loadedWidgetsBundles);
        for (WidgetsBundle widgetsBundle : createdWidgetsBundles) {
            this.widgetsBundleService.deleteWidgetsBundle(tenantId, widgetsBundle.getId());
        }
        loadedWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(tenantId);
        Collections.sort(systemWidgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals((Object)systemWidgetsBundles, (Object)loadedWidgetsBundles);
    }

    @Test
    public void testFindTenantWidgetsBundlesByTenantId() {
        ArrayList<WidgetsBundle> widgetsBundles = new ArrayList<WidgetsBundle>();
        for (int i = 0; i < 127; ++i) {
            WidgetsBundle widgetsBundle = new WidgetsBundle();
            widgetsBundle.setTenantId(this.tenantId);
            widgetsBundle.setTitle("Widgets bundle " + i);
            widgetsBundles.add(this.widgetsBundleService.saveWidgetsBundle(widgetsBundle));
        }
        ArrayList loadedWidgetsBundles = new ArrayList();
        PageLink pageLink = new PageLink(11);
        PageData pageData = null;
        do {
            pageData = this.widgetsBundleService.findTenantWidgetsBundlesByTenantId(this.tenantId, pageLink);
            loadedWidgetsBundles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(widgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(widgetsBundles, loadedWidgetsBundles);
        this.widgetsBundleService.deleteWidgetsBundlesByTenantId(this.tenantId);
        pageLink = new PageLink(15);
        pageData = this.widgetsBundleService.findTenantWidgetsBundlesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindAllWidgetsBundlesByTenantIdAndPageLink() {
        List systemWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(this.tenantId);
        TenantId systemTenantId = TenantId.fromUUID((UUID)ModelConstants.NULL_UUID);
        ArrayList<WidgetsBundle> createdWidgetsBundles = new ArrayList<WidgetsBundle>();
        ArrayList<WidgetsBundle> createdSystemWidgetsBundles = new ArrayList<WidgetsBundle>();
        for (int i = 0; i < 177; ++i) {
            WidgetsBundle widgetsBundle = new WidgetsBundle();
            widgetsBundle.setTenantId(i % 2 == 0 ? this.tenantId : systemTenantId);
            widgetsBundle.setTitle((i % 2 == 0 ? "Widgets bundle " : "System widget bundle ") + i);
            WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
            createdWidgetsBundles.add(savedWidgetsBundle);
            if (i % 2 != 1) continue;
            createdSystemWidgetsBundles.add(savedWidgetsBundle);
        }
        ArrayList widgetsBundles = new ArrayList(createdWidgetsBundles);
        widgetsBundles.addAll(systemWidgetsBundles);
        ArrayList loadedWidgetsBundles = new ArrayList();
        PageLink pageLink = new PageLink(17);
        PageData pageData = null;
        do {
            pageData = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantIdAndPageLink(WidgetsBundleFilter.fromTenantId((TenantId)this.tenantId), pageLink);
            loadedWidgetsBundles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(widgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(widgetsBundles, loadedWidgetsBundles);
        this.widgetsBundleService.deleteWidgetsBundlesByTenantId(this.tenantId);
        loadedWidgetsBundles.clear();
        pageLink = new PageLink(14);
        do {
            pageData = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantIdAndPageLink(WidgetsBundleFilter.fromTenantId((TenantId)this.tenantId), pageLink);
            loadedWidgetsBundles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        ArrayList<WidgetsBundle> allSystemWidgetsBundles = new ArrayList<WidgetsBundle>(systemWidgetsBundles);
        allSystemWidgetsBundles.addAll(createdSystemWidgetsBundles);
        Collections.sort(allSystemWidgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(allSystemWidgetsBundles, loadedWidgetsBundles);
        for (WidgetsBundle widgetsBundle : createdSystemWidgetsBundles) {
            this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, widgetsBundle.getId());
        }
        loadedWidgetsBundles.clear();
        pageLink = new PageLink(18);
        do {
            pageData = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantIdAndPageLink(WidgetsBundleFilter.fromTenantId((TenantId)this.tenantId), pageLink);
            loadedWidgetsBundles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(systemWidgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals((Object)systemWidgetsBundles, loadedWidgetsBundles);
    }

    @Test
    public void testFindAllWidgetsBundlesByTenantId() {
        List systemWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(this.tenantId);
        TenantId systemTenantId = TenantId.fromUUID((UUID)ModelConstants.NULL_UUID);
        ArrayList<WidgetsBundle> createdWidgetsBundles = new ArrayList<WidgetsBundle>();
        ArrayList<WidgetsBundle> createdSystemWidgetsBundles = new ArrayList<WidgetsBundle>();
        for (int i = 0; i < 277; ++i) {
            WidgetsBundle widgetsBundle = new WidgetsBundle();
            widgetsBundle.setTenantId(i % 2 == 0 ? this.tenantId : systemTenantId);
            widgetsBundle.setTitle((i % 2 == 0 ? "Widgets bundle " : "System widget bundle ") + i);
            WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
            createdWidgetsBundles.add(savedWidgetsBundle);
            if (i % 2 != 1) continue;
            createdSystemWidgetsBundles.add(savedWidgetsBundle);
        }
        ArrayList widgetsBundles = new ArrayList(createdWidgetsBundles);
        widgetsBundles.addAll(systemWidgetsBundles);
        List loadedWidgetsBundles = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantId(this.tenantId);
        Collections.sort(widgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(widgetsBundles, (Object)loadedWidgetsBundles);
        this.widgetsBundleService.deleteWidgetsBundlesByTenantId(this.tenantId);
        loadedWidgetsBundles = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantId(this.tenantId);
        ArrayList<WidgetsBundle> allSystemWidgetsBundles = new ArrayList<WidgetsBundle>(systemWidgetsBundles);
        allSystemWidgetsBundles.addAll(createdSystemWidgetsBundles);
        Collections.sort(allSystemWidgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals(allSystemWidgetsBundles, (Object)loadedWidgetsBundles);
        for (WidgetsBundle widgetsBundle : createdSystemWidgetsBundles) {
            this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, widgetsBundle.getId());
        }
        loadedWidgetsBundles = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantId(this.tenantId);
        Collections.sort(systemWidgetsBundles, this.idComparator);
        Collections.sort(loadedWidgetsBundles, this.idComparator);
        Assert.assertEquals((Object)systemWidgetsBundles, (Object)loadedWidgetsBundles);
    }
}

