/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.widget.BaseWidgetType;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;

@DaoSqlTest
public class WidgetTypeServiceTest
extends AbstractServiceTest {
    @Autowired
    WidgetsBundleService widgetsBundleService;
    @Autowired
    WidgetTypeService widgetTypeService;
    private AbstractServiceTest.IdComparator<WidgetType> idComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveWidgetType() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        WidgetTypeDetails savedWidgetType = this.widgetTypeService.saveWidgetType(widgetType);
        Assert.assertNotNull((Object)savedWidgetType);
        Assert.assertNotNull((Object)savedWidgetType.getId());
        Assert.assertNotNull((Object)savedWidgetType.getFqn());
        Assert.assertTrue((savedWidgetType.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)widgetType.getTenantId(), (Object)savedWidgetType.getTenantId());
        Assert.assertEquals((Object)widgetType.getName(), (Object)savedWidgetType.getName());
        Assert.assertEquals((Object)widgetType.getDescriptor(), (Object)savedWidgetType.getDescriptor());
        savedWidgetType.setName("New Widget Type");
        this.widgetTypeService.saveWidgetType(savedWidgetType);
        WidgetType foundWidgetType = this.widgetTypeService.findWidgetTypeById(this.tenantId, savedWidgetType.getId());
        Assert.assertEquals((Object)foundWidgetType.getName(), (Object)savedWidgetType.getName());
        this.widgetTypeService.deleteWidgetType(this.tenantId, savedWidgetType.getId());
    }

    @Test
    public void testSaveWidgetTypeWithEmptyName() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        Assertions.assertThrows(DataValidationException.class, () -> this.widgetTypeService.saveWidgetType(widgetType));
    }

    @Test
    public void testSaveWidgetTypeWithEmptyDescriptor() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{}", JsonNode.class));
        Assertions.assertThrows(DataValidationException.class, () -> this.widgetTypeService.saveWidgetType(widgetType));
    }

    @Test
    public void testSaveWidgetTypeWithInvalidTenant() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        Assertions.assertThrows(DataValidationException.class, () -> this.widgetTypeService.saveWidgetType(widgetType));
    }

    @Test
    public void testUpdateWidgetTypeTenant() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        WidgetTypeDetails savedWidgetType = this.widgetTypeService.saveWidgetType(widgetType);
        savedWidgetType.setTenantId(TenantId.fromUUID((UUID)ModelConstants.NULL_UUID));
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.widgetTypeService.saveWidgetType(savedWidgetType));
        }
        finally {
            this.widgetTypeService.deleteWidgetType(this.tenantId, savedWidgetType.getId());
        }
    }

    @Test
    public void testUpdateWidgetTypeFqn() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        WidgetTypeDetails savedWidgetType = this.widgetTypeService.saveWidgetType(widgetType);
        savedWidgetType.setFqn("some_fqn");
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.widgetTypeService.saveWidgetType(savedWidgetType));
        }
        finally {
            this.widgetTypeService.deleteWidgetType(this.tenantId, savedWidgetType.getId());
        }
    }

    @Test
    public void testFindWidgetTypeById() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        WidgetTypeDetails savedWidgetType = this.widgetTypeService.saveWidgetType(widgetType);
        WidgetTypeDetails foundWidgetType = this.widgetTypeService.findWidgetTypeDetailsById(this.tenantId, savedWidgetType.getId());
        Assert.assertNotNull((Object)foundWidgetType);
        Assert.assertEquals((Object)savedWidgetType, (Object)foundWidgetType);
        this.widgetTypeService.deleteWidgetType(this.tenantId, savedWidgetType.getId());
    }

    @Test
    public void testFindWidgetTypeByTenantIdAndFqn() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        WidgetType savedWidgetType = new WidgetType((WidgetType)this.widgetTypeService.saveWidgetType(widgetType));
        WidgetType foundWidgetType = this.widgetTypeService.findWidgetTypeByTenantIdAndFqn(this.tenantId, savedWidgetType.getFqn());
        Assert.assertNotNull((Object)foundWidgetType);
        Assert.assertEquals((Object)savedWidgetType, (Object)foundWidgetType);
        this.widgetTypeService.deleteWidgetType(this.tenantId, savedWidgetType.getId());
    }

    @Test
    public void testDeleteWidgetType() throws IOException {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(this.tenantId);
        widgetType.setName("Widget Type");
        widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
        WidgetTypeDetails savedWidgetType = this.widgetTypeService.saveWidgetType(widgetType);
        WidgetType foundWidgetType = this.widgetTypeService.findWidgetTypeById(this.tenantId, savedWidgetType.getId());
        Assert.assertNotNull((Object)foundWidgetType);
        this.widgetTypeService.deleteWidgetType(this.tenantId, savedWidgetType.getId());
        foundWidgetType = this.widgetTypeService.findWidgetTypeById(this.tenantId, savedWidgetType.getId());
        Assert.assertNull((Object)foundWidgetType);
    }

    @Test
    public void testFindWidgetTypesByTenantIdAndWidgetsBundleId() throws IOException {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        widgetsBundle.setTitle("Widgets bundle");
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        ArrayList<WidgetType> widgetTypes = new ArrayList<WidgetType>();
        for (int i = 0; i < 121; ++i) {
            WidgetTypeDetails widgetType = new WidgetTypeDetails();
            widgetType.setTenantId(this.tenantId);
            widgetType.setName("Widget Type " + i);
            widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
            widgetTypes.add(new WidgetType((WidgetType)this.widgetTypeService.saveWidgetType(widgetType)));
        }
        List widgetTypeIds = widgetTypes.stream().map(BaseWidgetType::getId).collect(Collectors.toList());
        this.widgetTypeService.updateWidgetsBundleWidgetTypes(this.tenantId, savedWidgetsBundle.getId(), widgetTypeIds);
        List loadedWidgetTypes = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(this.tenantId, savedWidgetsBundle.getId());
        Collections.sort(widgetTypes, this.idComparator);
        Collections.sort(loadedWidgetTypes, this.idComparator);
        Assert.assertEquals(widgetTypes, (Object)loadedWidgetTypes);
        for (WidgetTypeId id : widgetTypeIds) {
            this.widgetTypeService.deleteWidgetType(this.tenantId, id);
        }
        loadedWidgetTypes = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertTrue((boolean)loadedWidgetTypes.isEmpty());
        this.widgetsBundleService.deleteWidgetsBundle(this.tenantId, savedWidgetsBundle.getId());
    }

    @Test
    public void testDeleteAllTypesFromWidgetsBundle() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(this.tenantId);
        widgetsBundle.setTitle("Widgets bundle");
        WidgetsBundle savedWidgetsBundle = this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
        ArrayList<WidgetType> widgetTypes = new ArrayList<WidgetType>();
        for (int i = 0; i < 5; ++i) {
            WidgetTypeDetails widgetType = new WidgetTypeDetails();
            widgetType.setTenantId(this.tenantId);
            widgetType.setName("Widget Type " + i);
            widgetType.setDescriptor((JsonNode)JacksonUtil.fromString((String)"{ \"someKey\": \"someValue\" }", JsonNode.class));
            widgetTypes.add(new WidgetType((WidgetType)this.widgetTypeService.saveWidgetType(widgetType)));
        }
        List widgetTypeIds = widgetTypes.stream().map(BaseWidgetType::getId).collect(Collectors.toList());
        this.widgetTypeService.updateWidgetsBundleWidgetTypes(this.tenantId, savedWidgetsBundle.getId(), widgetTypeIds);
        List loadedWidgetTypes = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertEquals((long)widgetTypes.size(), (long)loadedWidgetTypes.size());
        this.widgetTypeService.updateWidgetsBundleWidgetTypes(this.tenantId, savedWidgetsBundle.getId(), Collections.emptyList());
        loadedWidgetTypes = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(this.tenantId, savedWidgetsBundle.getId());
        Assert.assertEquals((long)0L, (long)loadedWidgetTypes.size());
    }
}

