/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.service.Validator;

class ValidatorTest {
    final DeviceId goodDeviceId = new DeviceId(UUID.fromString("18594c15-9f05-4cda-b58e-70172467c3e5"));
    final UserId nullUserId = new UserId(null);

    ValidatorTest() {
    }

    @Test
    void validateEntityIdTest() {
        Validator.validateEntityId((EntityId)TenantId.SYS_TENANT_ID, id -> "Incorrect entityId " + String.valueOf(id));
        Validator.validateEntityId((EntityId)this.goodDeviceId, id -> "Incorrect entityId " + String.valueOf(id));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateEntityId(null, id -> "Incorrect entityId " + String.valueOf(id))).as("EntityId is null", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect entityId null");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateEntityId((EntityId)this.nullUserId, id -> "Incorrect entityId " + String.valueOf(id))).as("EntityId with null UUID", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect entityId null");
    }

    @Test
    void validateStringTest() {
        Validator.validateString((String)"Hello", s -> "Incorrect string " + s);
        Validator.validateString((String)" ", s -> "Incorrect string " + s);
        Validator.validateString((String)"\n", s -> "Incorrect string " + s);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateString(null, s -> "Incorrect string " + s)).as("String is null", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect string null");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateString((String)"", s -> "Incorrect string " + s)).as("String is empty", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessage("Incorrect string ");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateString((String)"", s -> "Incorrect string [" + s + "]")).as("String is empty []", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessage("Incorrect string []");
    }

    @Test
    void validateUUIDIdTest() {
        Validator.validateId((UUID)UUID.randomUUID(), id -> "Incorrect Id " + String.valueOf(id));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateId((UUID)null, id -> "Incorrect Id " + String.valueOf(id))).as("Id is null", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect Id null");
    }

    @Test
    void validateUUIDBasedIdTest() {
        Validator.validateId((UUIDBased)TenantId.SYS_TENANT_ID, id -> "Incorrect Id " + String.valueOf(id));
        Validator.validateId((UUIDBased)this.goodDeviceId, id -> "Incorrect Id " + String.valueOf(id));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateId((UUIDBased)null, id -> "Incorrect Id " + String.valueOf(id))).as("Id is null", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect Id null");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateId((UUIDBased)this.nullUserId, id -> "Incorrect Id " + String.valueOf(id))).as("Id with null UUIDBased", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect Id null");
    }

    @Test
    void validateIdsTest() {
        List<DeviceId> list = List.of(this.goodDeviceId);
        Validator.validateIds(list, ids -> "Incorrect Id " + String.valueOf(ids));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateIds(null, id -> "Incorrect Ids " + String.valueOf(id))).as("Ids are null", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect Ids null");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateIds(Collections.emptyList(), ids -> "Incorrect Ids " + String.valueOf(ids))).as("List is empty", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect Ids []");
        ArrayList<DeviceId> badList = new ArrayList<DeviceId>(2);
        badList.add(this.goodDeviceId);
        badList.add(null);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validator.validateIds((List)badList, ids -> "Incorrect Ids " + String.valueOf(ids))).as("List contains null", new Object[0])).isInstanceOf(IncorrectParameterException.class)).hasMessageContaining("Incorrect Ids ").hasMessageContaining(this.goodDeviceId.getId().toString()).hasMessageContaining("null");
    }
}

