/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.settings.UserSettings;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.user.UserService;

@DaoSqlTest
public class UserServiceTest
extends AbstractServiceTest {
    @Autowired
    CustomerService customerService;
    @Autowired
    UserService userService;
    private AbstractServiceTest.IdComparator<User> idComparator = new AbstractServiceTest.IdComparator();
    private UserSettings userSettings;

    @Before
    public void before() {
        User tenantAdmin = new User();
        tenantAdmin.setAuthority(Authority.TENANT_ADMIN);
        tenantAdmin.setTenantId(this.tenantId);
        tenantAdmin.setEmail("tenant@thingsboard.org");
        this.userService.saveUser(TenantId.SYS_TENANT_ID, tenantAdmin);
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        User customerUser = new User();
        customerUser.setAuthority(Authority.CUSTOMER_USER);
        customerUser.setTenantId(this.tenantId);
        customerUser.setCustomerId(savedCustomer.getId());
        customerUser.setEmail("customer@thingsboard.org");
        customerUser = this.userService.saveUser(this.tenantId, customerUser);
        UserSettings userSettings = this.createUserSettings(customerUser.getId());
    }

    @Test
    public void testFindUserByEmail() {
        User user = this.userService.findUserByEmail(SYSTEM_TENANT_ID, "sysadmin@thingsboard.org");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Authority.SYS_ADMIN, (Object)user.getAuthority());
        user = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Authority.TENANT_ADMIN, (Object)user.getAuthority());
        user = this.userService.findUserByEmail(this.tenantId, "customer@thingsboard.org");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Authority.CUSTOMER_USER, (Object)user.getAuthority());
        user = this.userService.findUserByEmail(this.tenantId, "fake@thingsboard.org");
        Assert.assertNull((Object)user);
    }

    @Test
    public void testFindUserByTenantIdAndEmail() {
        User user = this.userService.findUserByTenantIdAndEmail(SYSTEM_TENANT_ID, "sysadmin@thingsboard.org");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Authority.SYS_ADMIN, (Object)user.getAuthority());
        user = this.userService.findUserByTenantIdAndEmail(this.tenantId, "tenant@thingsboard.org");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Authority.TENANT_ADMIN, (Object)user.getAuthority());
        user = this.userService.findUserByTenantIdAndEmail(this.tenantId, "customer@thingsboard.org");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Authority.CUSTOMER_USER, (Object)user.getAuthority());
        user = this.userService.findUserByTenantIdAndEmail(this.tenantId, "fake@thingsboard.org");
        Assert.assertNull((Object)user);
    }

    @Test
    public void testFindUserById() {
        User user = this.userService.findUserByEmail(SYSTEM_TENANT_ID, "sysadmin@thingsboard.org");
        Assert.assertNotNull((Object)user);
        User foundUser = this.userService.findUserById(SYSTEM_TENANT_ID, user.getId());
        Assert.assertNotNull((Object)foundUser);
        Assert.assertEquals((Object)user, (Object)foundUser);
    }

    @Test
    public void testFindUserCredentials() {
        User user = this.userService.findUserByEmail(SYSTEM_TENANT_ID, "sysadmin@thingsboard.org");
        Assert.assertNotNull((Object)user);
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(SYSTEM_TENANT_ID, user.getId());
        Assert.assertNotNull((Object)userCredentials);
    }

    @Test
    public void testSaveUser() {
        User tenantAdminUser = this.userService.findUserByEmail(SYSTEM_TENANT_ID, "tenant@thingsboard.org");
        User user = new User();
        user.setAuthority(Authority.TENANT_ADMIN);
        user.setTenantId(tenantAdminUser.getTenantId());
        user.setEmail("tenant2@thingsboard.org");
        User savedUser = this.userService.saveUser(TenantId.SYS_TENANT_ID, user);
        Assert.assertNotNull((Object)savedUser);
        Assert.assertNotNull((Object)savedUser.getId());
        Assert.assertTrue((savedUser.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)user.getEmail(), (Object)savedUser.getEmail());
        Assert.assertEquals((Object)user.getTenantId(), (Object)savedUser.getTenantId());
        Assert.assertEquals((Object)user.getAuthority(), (Object)savedUser.getAuthority());
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(this.tenantId, savedUser.getId());
        Assert.assertNotNull((Object)userCredentials);
        Assert.assertNotNull((Object)userCredentials.getId());
        Assert.assertNotNull((Object)userCredentials.getUserId());
        Assert.assertNotNull((Object)userCredentials.getActivateToken());
        savedUser.setFirstName("Joe");
        savedUser.setLastName("Downs");
        this.userService.saveUser(TenantId.SYS_TENANT_ID, savedUser);
        savedUser = this.userService.findUserById(this.tenantId, savedUser.getId());
        Assert.assertEquals((Object)"Joe", (Object)savedUser.getFirstName());
        Assert.assertEquals((Object)"Downs", (Object)savedUser.getLastName());
        this.userService.deleteUser(this.tenantId, savedUser);
    }

    @Test
    public void testSaveUserWithSameEmail() {
        User tenantAdminUser = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        tenantAdminUser.setEmail("sysadmin@thingsboard.org");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.userService.saveUser(this.tenantId, tenantAdminUser)).isInstanceOf(DataValidationException.class)).hasMessage("User with email 'sysadmin@thingsboard.org' already present in database!");
    }

    @Test
    public void testSaveUserWithInvalidEmail() {
        User tenantAdminUser = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        tenantAdminUser.setEmail("tenant_thingsboard.org");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.userService.saveUser(this.tenantId, tenantAdminUser)).isInstanceOf(DataValidationException.class)).hasMessage("Invalid email address format 'tenant_thingsboard.org'!");
    }

    @Test
    public void testSaveUserWithEmptyEmail() {
        User tenantAdminUser = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        tenantAdminUser.setEmail(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.userService.saveUser(this.tenantId, tenantAdminUser)).isInstanceOf(DataValidationException.class)).hasMessage("User email should be specified!");
    }

    @Test
    public void testSaveUserWithoutTenant() {
        User tenantAdminUser = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        tenantAdminUser.setTenantId(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.userService.saveUser(this.tenantId, tenantAdminUser)).isInstanceOf(DataValidationException.class)).hasMessage("Tenant administrator should be assigned to tenant!");
    }

    @Test
    public void testDeleteUser() {
        User tenantAdminUser = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        User user = new User();
        user.setAuthority(Authority.TENANT_ADMIN);
        user.setTenantId(tenantAdminUser.getTenantId());
        user.setEmail("tenant2@thingsboard.org");
        User savedUser = this.userService.saveUser(TenantId.SYS_TENANT_ID, user);
        Assert.assertNotNull((Object)savedUser);
        Assert.assertNotNull((Object)savedUser.getId());
        User foundUser = this.userService.findUserById(this.tenantId, savedUser.getId());
        Assert.assertNotNull((Object)foundUser);
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(this.tenantId, foundUser.getId());
        Assert.assertNotNull((Object)userCredentials);
        this.userService.deleteUser(this.tenantId, foundUser);
        userCredentials = this.userService.findUserCredentialsByUserId(this.tenantId, foundUser.getId());
        foundUser = this.userService.findUserById(this.tenantId, foundUser.getId());
        Assert.assertNull((Object)foundUser);
        Assert.assertNull((Object)userCredentials);
    }

    @Test
    public void testFindTenantAdmins() {
        User tenantAdminUser = this.userService.findUserByEmail(this.tenantId, "tenant@thingsboard.org");
        PageData pageData = this.userService.findTenantAdmins(tenantAdminUser.getTenantId(), new PageLink(10));
        Assert.assertFalse((boolean)pageData.hasNext());
        List users = pageData.getData();
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)tenantAdminUser, users.get(0));
        TenantId secondTenantId = this.createTenant().getId();
        ArrayList<User> tenantAdmins = new ArrayList<User>();
        for (int i = 0; i < 124; ++i) {
            User user = new User();
            user.setAuthority(Authority.TENANT_ADMIN);
            user.setTenantId(secondTenantId);
            user.setEmail("testTenant" + i + "@thingsboard.org");
            tenantAdmins.add(this.userService.saveUser(TenantId.SYS_TENANT_ID, user));
        }
        ArrayList loadedTenantAdmins = new ArrayList();
        PageLink pageLink = new PageLink(33);
        do {
            pageData = this.userService.findTenantAdmins(secondTenantId, pageLink);
            loadedTenantAdmins.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantAdmins, this.idComparator);
        Collections.sort(loadedTenantAdmins, this.idComparator);
        Assert.assertEquals(tenantAdmins, loadedTenantAdmins);
        this.tenantService.deleteTenant(secondTenantId);
        pageLink = new PageLink(33);
        pageData = this.userService.findTenantAdmins(secondTenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindTenantAdminsByEmail() {
        String email1 = "testEmail1";
        ArrayList<User> tenantAdminsEmail1 = new ArrayList<User>();
        for (int i = 0; i < 94; ++i) {
            User user = new User();
            user.setAuthority(Authority.TENANT_ADMIN);
            user.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(5.0 + Math.random() * 10.0)));
            Object email = email1 + suffix + "@thingsboard.org";
            email = i % 2 == 0 ? ((String)email).toLowerCase() : ((String)email).toUpperCase();
            user.setEmail((String)email);
            tenantAdminsEmail1.add(this.userService.saveUser(TenantId.SYS_TENANT_ID, user));
        }
        String email2 = "testEmail2";
        ArrayList<User> tenantAdminsEmail2 = new ArrayList<User>();
        for (int i = 0; i < 132; ++i) {
            User user = new User();
            user.setAuthority(Authority.TENANT_ADMIN);
            user.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(5.0 + Math.random() * 10.0)));
            Object email = email2 + suffix + "@thingsboard.org";
            email = i % 2 == 0 ? ((String)email).toLowerCase() : ((String)email).toUpperCase();
            user.setEmail((String)email);
            tenantAdminsEmail2.add(this.userService.saveUser(TenantId.SYS_TENANT_ID, user));
        }
        ArrayList loadedTenantAdminsEmail1 = new ArrayList();
        PageLink pageLink = new PageLink(33, 0, email1);
        PageData pageData = null;
        do {
            pageData = this.userService.findTenantAdmins(this.tenantId, pageLink);
            loadedTenantAdminsEmail1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantAdminsEmail1, this.idComparator);
        Collections.sort(loadedTenantAdminsEmail1, this.idComparator);
        Assert.assertEquals(tenantAdminsEmail1, loadedTenantAdminsEmail1);
        ArrayList loadedTenantAdminsEmail2 = new ArrayList();
        pageLink = new PageLink(16, 0, email2);
        do {
            pageData = this.userService.findTenantAdmins(this.tenantId, pageLink);
            loadedTenantAdminsEmail2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantAdminsEmail2, this.idComparator);
        Collections.sort(loadedTenantAdminsEmail2, this.idComparator);
        Assert.assertEquals(tenantAdminsEmail2, loadedTenantAdminsEmail2);
        for (User user : loadedTenantAdminsEmail1) {
            this.userService.deleteUser(this.tenantId, user);
        }
        pageLink = new PageLink(4, 0, email1);
        pageData = this.userService.findTenantAdmins(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (User user : loadedTenantAdminsEmail2) {
            this.userService.deleteUser(this.tenantId, user);
        }
        pageLink = new PageLink(4, 0, email2);
        pageData = this.userService.findTenantAdmins(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindCustomerUsers() {
        User customerUser = this.userService.findUserByEmail(this.tenantId, "customer@thingsboard.org");
        PageData pageData = this.userService.findCustomerUsers(customerUser.getTenantId(), customerUser.getCustomerId(), new PageLink(10));
        Assert.assertFalse((boolean)pageData.hasNext());
        List users = pageData.getData();
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)customerUser, users.get(0));
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        ArrayList<User> customerUsers = new ArrayList<User>();
        for (int i = 0; i < 156; ++i) {
            User user = new User();
            user.setAuthority(Authority.CUSTOMER_USER);
            user.setTenantId(this.tenantId);
            user.setCustomerId(customerId);
            user.setEmail("testCustomer" + i + "@thingsboard.org");
            customerUsers.add(this.userService.saveUser(this.tenantId, user));
        }
        ArrayList loadedCustomerUsers = new ArrayList();
        PageLink pageLink = new PageLink(33);
        do {
            pageData = this.userService.findCustomerUsers(this.tenantId, customerId, pageLink);
            loadedCustomerUsers.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(customerUsers, this.idComparator);
        Collections.sort(loadedCustomerUsers, this.idComparator);
        Assert.assertEquals(customerUsers, loadedCustomerUsers);
        this.tenantService.deleteTenant(this.tenantId);
        pageData = this.userService.findCustomerUsers(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindCustomerUsersByEmail() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        String email1 = "testEmail1";
        ArrayList<User> customerUsersEmail1 = new ArrayList<User>();
        for (int i = 0; i < 124; ++i) {
            User user = new User();
            user.setAuthority(Authority.CUSTOMER_USER);
            user.setTenantId(this.tenantId);
            user.setCustomerId(customerId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(5.0 + Math.random() * 10.0)));
            Object email = email1 + suffix + "@thingsboard.org";
            email = i % 2 == 0 ? ((String)email).toLowerCase() : ((String)email).toUpperCase();
            user.setEmail((String)email);
            customerUsersEmail1.add(this.userService.saveUser(this.tenantId, user));
        }
        String email2 = "testEmail2";
        ArrayList<User> customerUsersEmail2 = new ArrayList<User>();
        for (int i = 0; i < 132; ++i) {
            User user = new User();
            user.setAuthority(Authority.CUSTOMER_USER);
            user.setTenantId(this.tenantId);
            user.setCustomerId(customerId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(5.0 + Math.random() * 10.0)));
            Object email = email2 + suffix + "@thingsboard.org";
            email = i % 2 == 0 ? ((String)email).toLowerCase() : ((String)email).toUpperCase();
            user.setEmail((String)email);
            customerUsersEmail2.add(this.userService.saveUser(this.tenantId, user));
        }
        ArrayList loadedCustomerUsersEmail1 = new ArrayList();
        PageLink pageLink = new PageLink(33, 0, email1);
        PageData pageData = null;
        do {
            pageData = this.userService.findCustomerUsers(this.tenantId, customerId, pageLink);
            loadedCustomerUsersEmail1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(customerUsersEmail1, this.idComparator);
        Collections.sort(loadedCustomerUsersEmail1, this.idComparator);
        Assert.assertEquals(customerUsersEmail1, loadedCustomerUsersEmail1);
        ArrayList loadedCustomerUsersEmail2 = new ArrayList();
        pageLink = new PageLink(16, 0, email2);
        do {
            pageData = this.userService.findCustomerUsers(this.tenantId, customerId, pageLink);
            loadedCustomerUsersEmail2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(customerUsersEmail2, this.idComparator);
        Collections.sort(loadedCustomerUsersEmail2, this.idComparator);
        Assert.assertEquals(customerUsersEmail2, loadedCustomerUsersEmail2);
        for (User user : loadedCustomerUsersEmail1) {
            this.userService.deleteUser(this.tenantId, user);
        }
        pageLink = new PageLink(4, 0, email1);
        pageData = this.userService.findCustomerUsers(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (User user : loadedCustomerUsersEmail2) {
            this.userService.deleteUser(this.tenantId, user);
        }
        pageLink = new PageLink(4, 0, email2);
        pageData = this.userService.findCustomerUsers(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    private UserSettings createUserSettings(UserId userId) {
        UserSettings userSettings = new UserSettings();
        userSettings.setUserId(userId);
        userSettings.setSettings((JsonNode)JacksonUtil.newObjectNode().put("text", StringUtils.randomAlphanumeric((int)10)));
        return userSettings;
    }
}

