/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfoFilter;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantInfo;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.device.profile.DeviceProfileData;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.MqttDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rpc.Rpc;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.rpc.RpcService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.service.OtaPackageServiceTest;
import org.thingsboard.server.dao.tenant.TenantDao;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.usagerecord.ApiUsageStateService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;

@DaoSqlTest
public class TenantServiceTest
extends AbstractServiceTest {
    @SpyBean
    TenantDao tenantDao;
    @Autowired
    ApiUsageStateService apiUsageStateService;
    @Autowired
    AssetService assetService;
    @Autowired
    CustomerService customerService;
    @Autowired
    DashboardService dashboardService;
    @Autowired
    DeviceProfileService deviceProfileService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    EdgeService edgeService;
    @Autowired
    EntityViewService entityViewService;
    @Autowired
    OtaPackageService otaPackageService;
    @Autowired
    ResourceService resourceService;
    @Autowired
    RpcService rpcService;
    @Autowired
    RuleChainService ruleChainService;
    @Autowired
    TbTransactionalCache<TenantId, Boolean> existsTenantCache;
    @Autowired
    TbTransactionalCache<TenantId, Tenant> cache;
    @Autowired
    TenantProfileService tenantProfileService;
    @Autowired
    UserService userService;
    @Autowired
    WidgetsBundleService widgetsBundleService;
    private final AbstractServiceTest.IdComparator<Tenant> idComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveTenant() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Assert.assertNotNull((Object)savedTenant);
        Assert.assertNotNull((Object)savedTenant.getId());
        Assert.assertTrue((savedTenant.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)tenant.getTitle(), (Object)savedTenant.getTitle());
        savedTenant.setTitle("My new tenant");
        this.tenantService.saveTenant(savedTenant);
        Tenant foundTenant = this.tenantService.findTenantById(savedTenant.getId());
        Assert.assertEquals((Object)foundTenant.getTitle(), (Object)savedTenant.getTitle());
        this.tenantService.deleteTenant(savedTenant.getId());
    }

    @Test
    public void testFindTenantById() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Tenant foundTenant = this.tenantService.findTenantById(savedTenant.getId());
        Assert.assertNotNull((Object)foundTenant);
        Assert.assertEquals((Object)savedTenant, (Object)foundTenant);
        this.tenantService.deleteTenant(savedTenant.getId());
    }

    @Test
    public void testFindTenantInfoById() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        TenantInfo foundTenant = this.tenantService.findTenantInfoById(savedTenant.getId());
        Assert.assertNotNull((Object)foundTenant);
        Assert.assertEquals((Object)new TenantInfo(savedTenant, "Default"), (Object)foundTenant);
        this.tenantService.deleteTenant(savedTenant.getId());
    }

    @Test
    public void testSaveTenantWithEmptyTitle() {
        Tenant tenant = new Tenant();
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.tenantService.saveTenant(tenant));
    }

    @Test
    public void testSaveTenantWithInvalidEmail() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        tenant.setEmail("invalid@mail");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.tenantService.saveTenant(tenant));
    }

    @Test
    public void testDeleteTenant() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        this.tenantService.deleteTenant(savedTenant.getId());
        Tenant foundTenant = this.tenantService.findTenantById(savedTenant.getId());
        Assert.assertNull((Object)foundTenant);
    }

    @Test
    public void testFindTenants() {
        this.tenantService.deleteTenants();
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        PageLink pageLink = new PageLink(17);
        PageData pageData = this.tenantService.findTenants(pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
        tenants.addAll(pageData.getData());
        for (int i = 0; i < 156; ++i) {
            Tenant tenant = new Tenant();
            tenant.setTitle("Tenant" + i);
            tenants.add(this.tenantService.saveTenant(tenant));
        }
        ArrayList loadedTenants = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.tenantService.findTenants(pageLink);
            loadedTenants.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenants, this.idComparator);
        Collections.sort(loadedTenants, this.idComparator);
        Assert.assertEquals(tenants, loadedTenants);
        for (Tenant tenant : loadedTenants) {
            this.tenantService.deleteTenant(tenant.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.tenantService.findTenants(pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindTenantsByTitle() {
        String title1 = "Tenant title 1";
        ArrayList<Tenant> tenantsTitle1 = new ArrayList<Tenant>();
        for (int i = 0; i < 134; ++i) {
            Tenant tenant = new Tenant();
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 15.0)));
            Object title = title1 + suffix;
            title = i % 2 == 0 ? ((String)title).toLowerCase() : ((String)title).toUpperCase();
            tenant.setTitle((String)title);
            tenantsTitle1.add(this.tenantService.saveTenant(tenant));
        }
        String title2 = "Tenant title 2";
        ArrayList<Tenant> tenantsTitle2 = new ArrayList<Tenant>();
        for (int i = 0; i < 127; ++i) {
            Tenant tenant = new Tenant();
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 15.0)));
            Object title = title2 + suffix;
            title = i % 2 == 0 ? ((String)title).toLowerCase() : ((String)title).toUpperCase();
            tenant.setTitle((String)title);
            tenantsTitle2.add(this.tenantService.saveTenant(tenant));
        }
        ArrayList loadedTenantsTitle1 = new ArrayList();
        PageLink pageLink = new PageLink(15, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.tenantService.findTenants(pageLink);
            loadedTenantsTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantsTitle1, this.idComparator);
        Collections.sort(loadedTenantsTitle1, this.idComparator);
        Assert.assertEquals(tenantsTitle1, loadedTenantsTitle1);
        ArrayList loadedTenantsTitle2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.tenantService.findTenants(pageLink);
            loadedTenantsTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantsTitle2, this.idComparator);
        Collections.sort(loadedTenantsTitle2, this.idComparator);
        Assert.assertEquals(tenantsTitle2, loadedTenantsTitle2);
        for (Tenant tenant : loadedTenantsTitle1) {
            this.tenantService.deleteTenant(tenant.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.tenantService.findTenants(pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Tenant tenant : loadedTenantsTitle2) {
            this.tenantService.deleteTenant(tenant.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.tenantService.findTenants(pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindTenantInfos() {
        this.tenantService.deleteTenants();
        ArrayList<TenantInfo> tenants = new ArrayList<TenantInfo>();
        PageLink pageLink = new PageLink(17);
        PageData pageData = this.tenantService.findTenantInfos(pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
        tenants.addAll(pageData.getData());
        for (int i = 0; i < 156; ++i) {
            Tenant tenant = new Tenant();
            tenant.setTitle("Tenant" + i);
            tenants.add(new TenantInfo(this.tenantService.saveTenant(tenant), "Default"));
        }
        ArrayList loadedTenants = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.tenantService.findTenantInfos(pageLink);
            loadedTenants.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenants, this.idComparator);
        Collections.sort(loadedTenants, this.idComparator);
        Assert.assertEquals(tenants, loadedTenants);
        for (TenantInfo tenant : loadedTenants) {
            this.tenantService.deleteTenant(tenant.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.tenantService.findTenantInfos(pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testGettingTenantAddingItToCache() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Mockito.reset((Object[])new TenantDao[]{this.tenantDao});
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)0))).findById((TenantId)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        this.tenantService.findTenantById(savedTenant.getId());
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)1))).findById((TenantId)ArgumentMatchers.eq((Object)savedTenant.getId()), (UUID)ArgumentMatchers.eq((Object)savedTenant.getId().getId()));
        TbCacheValueWrapper cachedTenant = this.cache.get((Serializable)savedTenant.getId());
        Assert.assertNotNull((String)"Getting an existing Tenant doesn't add it to the cache!", (Object)cachedTenant);
        Assert.assertEquals((Object)savedTenant, (Object)cachedTenant.get());
        for (int i = 0; i < 100; ++i) {
            this.tenantService.findTenantById(savedTenant.getId());
        }
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)1))).findById((TenantId)ArgumentMatchers.eq((Object)savedTenant.getId()), (UUID)ArgumentMatchers.eq((Object)savedTenant.getId().getId()));
        this.tenantService.deleteTenant(savedTenant.getId());
    }

    @Test
    public void testExistsTenantAddingResultToCache() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Mockito.reset((Object[])new TenantDao[]{this.tenantDao});
        this.existsTenantCache.evict((Serializable)savedTenant.getTenantId());
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)0))).existsById((TenantId)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        this.tenantService.tenantExists(savedTenant.getId());
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)1))).existsById((TenantId)ArgumentMatchers.eq((Object)savedTenant.getId()), (UUID)ArgumentMatchers.eq((Object)savedTenant.getId().getId()));
        TbCacheValueWrapper isExists = this.existsTenantCache.get((Serializable)savedTenant.getId());
        Assert.assertNotNull((String)"Getting an existing Tenant doesn't add it to the cache!", (Object)isExists);
        for (int i = 0; i < 100; ++i) {
            this.tenantService.tenantExists(savedTenant.getId());
        }
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)1))).existsById((TenantId)ArgumentMatchers.eq((Object)savedTenant.getId()), (UUID)ArgumentMatchers.eq((Object)savedTenant.getId().getId()));
        this.tenantService.deleteTenant(savedTenant.getId());
    }

    @Test
    public void testUpdatingExistingTenantEvictCache() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        this.tenantService.findTenantById(savedTenant.getId());
        TbCacheValueWrapper cachedTenant = this.cache.get((Serializable)savedTenant.getId());
        Assert.assertNotNull((String)"Saving a Tenant doesn't add it to the cache!", (Object)cachedTenant);
        Assert.assertEquals((Object)savedTenant, (Object)cachedTenant.get());
        savedTenant.setTitle("My new tenant");
        savedTenant = this.tenantService.saveTenant(savedTenant);
        Mockito.reset((Object[])new TenantDao[]{this.tenantDao});
        cachedTenant = this.cache.get((Serializable)savedTenant.getId());
        Assert.assertNull((String)"Updating a Tenant doesn't evict the cache!", (Object)cachedTenant);
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)0))).findById((TenantId)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        this.tenantService.findTenantById(savedTenant.getId());
        ((TenantDao)Mockito.verify((Object)this.tenantDao, (VerificationMode)Mockito.times((int)1))).findById((TenantId)ArgumentMatchers.eq((Object)savedTenant.getId()), (UUID)ArgumentMatchers.eq((Object)savedTenant.getId().getId()));
        this.tenantService.deleteTenant(savedTenant.getId());
    }

    @Test
    public void testRemovingTenantEvictCache() {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        this.tenantService.findTenantById(savedTenant.getId());
        this.tenantService.tenantExists(savedTenant.getId());
        TbCacheValueWrapper cachedTenant = this.cache.get((Serializable)savedTenant.getId());
        TbCacheValueWrapper cachedExists = this.existsTenantCache.get((Serializable)savedTenant.getId());
        Assert.assertNotNull((String)"Saving a Tenant doesn't add it to the cache!", (Object)cachedTenant);
        Assert.assertNotNull((String)"Saving a Tenant doesn't add it to the cache!", (Object)cachedExists);
        this.tenantService.deleteTenant(savedTenant.getId());
        cachedTenant = this.cache.get((Serializable)savedTenant.getId());
        cachedExists = this.existsTenantCache.get((Serializable)savedTenant.getId());
        Assert.assertNull((String)"Removing a Tenant doesn't evict the cache!", (Object)cachedTenant);
        Assert.assertNull((String)"Removing a Tenant doesn't evict the cache!", (Object)cachedExists);
    }

    @Test
    public void testDeleteTenantDeletingAllRelatedEntities() throws Exception {
        TenantProfile profile = this.createAndSaveTenantProfile();
        Tenant tenant = this.createAndSaveTenant(profile);
        User user = this.createAndSaveUserFor(tenant);
        Customer customer = this.createAndSaveCustomerFor(tenant);
        WidgetsBundle widgetsBundle = this.createAndSaveWidgetBundleFor(tenant);
        DeviceProfile deviceProfile = this.createAndSaveDeviceProfileWithProfileDataFor(tenant);
        Device device = this.createAndSaveDeviceFor(tenant, customer, deviceProfile);
        EntityView entityView = this.createAndSaveEntityViewFor(tenant, customer, device);
        Asset asset = this.createAndSaveAssetFor(tenant, customer);
        Dashboard dashboard = this.createAndSaveDashboardFor(tenant, customer);
        RuleChain ruleChain = this.createAndSaveRuleChainFor(tenant);
        Edge edge = this.createAndSaveEdgeFor(tenant);
        OtaPackage otaPackage = this.createAndSaveOtaPackageFor(tenant, deviceProfile);
        TbResource resource = this.createAndSaveResourceFor(tenant);
        Rpc rpc = this.createAndSaveRpcFor(tenant, device);
        this.tenantService.deleteTenant(tenant.getId());
        Assert.assertNull((Object)this.tenantService.findTenantById(tenant.getId()));
        this.assertCustomerIsDeleted(tenant, customer);
        this.assertWidgetsBundleIsDeleted(tenant, widgetsBundle);
        this.assertEntityViewIsDeleted(tenant, device, entityView);
        this.assertAssetIsDeleted(tenant, asset);
        this.assertDeviceIsDeleted(tenant, device);
        this.assertDeviceProfileIsDeleted(tenant, deviceProfile);
        this.assertDashboardIsDeleted(tenant, dashboard);
        this.assertEdgeIsDeleted(tenant, edge);
        this.assertTenantAdminIsDeleted(tenant);
        this.assertUserIsDeleted(tenant, user);
        Assert.assertNull((Object)this.ruleChainService.findRuleChainById(tenant.getId(), ruleChain.getId()));
        Assert.assertNull((Object)this.apiUsageStateService.findTenantApiUsageState(tenant.getId()));
        this.assertResourceIsDeleted(tenant, resource);
        this.assertOtaPackageIsDeleted(tenant, otaPackage);
        Assert.assertNull((Object)this.rpcService.findById(tenant.getId(), rpc.getId()));
        this.tenantProfileService.deleteTenantProfile(TenantId.SYS_TENANT_ID, profile.getId());
    }

    private void assertOtaPackageIsDeleted(Tenant tenant, OtaPackage otaPackage) {
        ((ObjectAssert)Assertions.assertThat((Object)this.otaPackageService.findOtaPackageById(tenant.getId(), otaPackage.getId())).as("otaPackage", new Object[0])).isNull();
        PageLink pageLinkOta = new PageLink(1);
        PageData pageDataOta = this.otaPackageService.findTenantOtaPackagesByTenantId(tenant.getId(), pageLinkOta);
        Assert.assertEquals((long)0L, (long)pageDataOta.getTotalElements());
    }

    private void assertResourceIsDeleted(Tenant tenant, TbResource resource) {
        ((ObjectAssert)Assertions.assertThat((Object)this.resourceService.findResourceById(tenant.getId(), resource.getId())).as("resource", new Object[0])).isNull();
        PageLink pageLinkResources = new PageLink(1);
        TbResourceInfoFilter filter = TbResourceInfoFilter.builder().tenantId(this.tenantId).build();
        PageData tenantResources = this.resourceService.findAllTenantResourcesByTenantId(filter, pageLinkResources);
        Assert.assertEquals((long)0L, (long)tenantResources.getTotalElements());
    }

    private void assertUserIsDeleted(Tenant tenant, User user) {
        ((ObjectAssert)Assertions.assertThat((Object)this.userService.findUserById(tenant.getId(), user.getId())).as("user", new Object[0])).isNull();
        PageLink pageLinkUsers = new PageLink(1);
        PageData users = this.userService.findUsersByTenantId(tenant.getId(), pageLinkUsers);
        Assert.assertEquals((long)0L, (long)users.getTotalElements());
    }

    private void assertTenantAdminIsDeleted(Tenant savedTenant) {
        PageLink pageLinkTenantAdmins = new PageLink(1);
        PageData tenantAdmins = this.userService.findTenantAdmins(savedTenant.getId(), pageLinkTenantAdmins);
        Assert.assertEquals((long)0L, (long)tenantAdmins.getTotalElements());
    }

    private void assertEdgeIsDeleted(Tenant tenant, Edge edge) {
        ((ObjectAssert)Assertions.assertThat((Object)this.edgeService.findEdgeById(tenant.getId(), edge.getId())).as("edge", new Object[0])).isNull();
        PageLink pageLinkEdges = new PageLink(1);
        PageData edges = this.edgeService.findEdgesByTenantId(tenant.getId(), pageLinkEdges);
        Assert.assertEquals((long)0L, (long)edges.getTotalElements());
    }

    private void assertDashboardIsDeleted(Tenant tenant, Dashboard dashboard) {
        ((ObjectAssert)Assertions.assertThat((Object)this.dashboardService.findDashboardById(tenant.getId(), dashboard.getId())).as("dashboard", new Object[0])).isNull();
        PageLink pageLinkDashboards = new PageLink(1);
        PageData dashboards = this.dashboardService.findDashboardsByTenantId(tenant.getId(), pageLinkDashboards);
        Assert.assertEquals((long)0L, (long)dashboards.getTotalElements());
    }

    private void assertDeviceProfileIsDeleted(Tenant tenant, DeviceProfile deviceProfile) {
        ((ObjectAssert)Assertions.assertThat((Object)this.deviceProfileService.findDeviceProfileById(tenant.getId(), deviceProfile.getId())).as("deviceProfile", new Object[0])).isNull();
        PageLink pageLinkDeviceProfiles = new PageLink(1);
        PageData profiles = this.deviceProfileService.findDeviceProfiles(tenant.getId(), pageLinkDeviceProfiles);
        Assert.assertEquals((long)0L, (long)profiles.getTotalElements());
    }

    private void assertDeviceIsDeleted(Tenant tenant, Device device) {
        ((ObjectAssert)Assertions.assertThat((Object)this.deviceService.findDeviceById(tenant.getId(), device.getId())).as("device", new Object[0])).isNull();
        PageLink pageLinkDevices = new PageLink(1);
        PageData devices = this.deviceService.findDevicesByTenantId(tenant.getId(), pageLinkDevices);
        Assert.assertEquals((long)0L, (long)devices.getTotalElements());
    }

    private void assertAssetIsDeleted(Tenant tenant, Asset asset) {
        ((ObjectAssert)Assertions.assertThat((Object)this.assetService.findAssetById(tenant.getId(), asset.getId())).as("asset", new Object[0])).isNull();
        PageLink pageLinkAssets = new PageLink(1);
        PageData assets = this.assetService.findAssetsByTenantId(tenant.getId(), pageLinkAssets);
        Assert.assertEquals((long)0L, (long)assets.getTotalElements());
    }

    private void assertEntityViewIsDeleted(Tenant tenant, Device device, EntityView entityView) {
        ((ObjectAssert)Assertions.assertThat((Object)this.entityViewService.findEntityViewById(tenant.getId(), entityView.getId())).as("entityView", new Object[0])).isNull();
        List entityViews = this.entityViewService.findEntityViewsByTenantIdAndEntityId(tenant.getId(), (EntityId)device.getId());
        Assert.assertTrue((boolean)entityViews.isEmpty());
    }

    private void assertWidgetsBundleIsDeleted(Tenant tenant, WidgetsBundle widgetsBundle) {
        ((ObjectAssert)Assertions.assertThat((Object)this.widgetsBundleService.findWidgetsBundleById(tenant.getId(), widgetsBundle.getId())).as("widgetBundle", new Object[0])).isNull();
        List widgetsBundlesByTenantId = this.widgetsBundleService.findAllTenantWidgetsBundlesByTenantId(tenant.getId());
        Assert.assertTrue((boolean)widgetsBundlesByTenantId.isEmpty());
    }

    private void assertCustomerIsDeleted(Tenant tenant, Customer customer) {
        ((ObjectAssert)Assertions.assertThat((Object)this.customerService.findCustomerById(tenant.getId(), customer.getId())).as("customer", new Object[0])).isNull();
        PageLink pageLinkCustomer = new PageLink(1);
        PageData pageDataCustomer = this.customerService.findCustomersByTenantId(tenant.getId(), pageLinkCustomer);
        Assert.assertEquals((long)0L, (long)pageDataCustomer.getTotalElements());
    }

    private Rpc createAndSaveRpcFor(Tenant tenant, Device device) {
        Rpc rpc = new Rpc();
        rpc.setTenantId(tenant.getId());
        rpc.setDeviceId(device.getId());
        rpc.setStatus(RpcStatus.QUEUED);
        rpc.setRequest(JacksonUtil.toJsonNode((String)"{}"));
        return this.rpcService.save(rpc);
    }

    private TbResource createAndSaveResourceFor(Tenant tenant) {
        TbResource resource = new TbResource();
        resource.setTenantId(tenant.getId());
        resource.setTitle("Test resource");
        resource.setResourceType(ResourceType.LWM2M_MODEL);
        resource.setFileName("filename.txt");
        resource.setResourceKey("Test resource key");
        resource.setData("Some super test data".getBytes(StandardCharsets.UTF_8));
        return this.resourceService.saveResource(resource);
    }

    private OtaPackage createAndSaveOtaPackageFor(Tenant tenant, DeviceProfile deviceProfile) {
        return this.otaPackageService.saveOtaPackage(OtaPackageServiceTest.createFirmware(tenant.getId(), "2", deviceProfile.getId()));
    }

    private Edge createAndSaveEdgeFor(Tenant tenant) {
        Edge edge = this.constructEdge(tenant.getId(), "Test edge", "Simple");
        return this.edgeService.saveEdge(edge);
    }

    private RuleChain createAndSaveRuleChainFor(Tenant tenant) {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setTenantId(tenant.getId());
        ruleChain.setName("Test rule chain");
        ruleChain.setType(RuleChainType.CORE);
        return this.ruleChainService.saveRuleChain(ruleChain);
    }

    private Dashboard createAndSaveDashboardFor(Tenant tenant, Customer customer) {
        Dashboard dashboard = new Dashboard();
        dashboard.setTenantId(tenant.getId());
        dashboard.setTitle("Test dashboard");
        dashboard.setAssignedCustomers(Set.of(customer.toShortCustomerInfo()));
        return this.dashboardService.saveDashboard(dashboard);
    }

    private Asset createAndSaveAssetFor(Tenant tenant, Customer customer) {
        Asset asset = new Asset();
        asset.setTenantId(tenant.getId());
        asset.setCustomerId(customer.getId());
        asset.setType("Test asset type");
        asset.setName("Test asset type");
        asset.setLabel("Test asset type");
        return this.assetService.saveAsset(asset);
    }

    private EntityView createAndSaveEntityViewFor(Tenant tenant, Customer customer, Device device) {
        EntityView entityView = new EntityView();
        entityView.setEntityId((EntityId)device.getId());
        entityView.setTenantId(tenant.getId());
        entityView.setCustomerId(customer.getId());
        entityView.setType("Test type");
        entityView.setName("Test entity view");
        entityView.setStartTimeMs(0L);
        entityView.setEndTimeMs(840000L);
        return this.entityViewService.saveEntityView(entityView);
    }

    private Device createAndSaveDeviceFor(Tenant tenant, Customer customer, DeviceProfile deviceProfile) {
        Device device = new Device();
        device.setCustomerId(customer.getId());
        device.setTenantId(tenant.getId());
        device.setType("Test type");
        device.setName("TestType");
        device.setLabel("Test type");
        device.setDeviceProfileId(deviceProfile.getId());
        return this.deviceService.saveDevice(device);
    }

    private DeviceProfile createAndSaveDeviceProfileWithProfileDataFor(Tenant tenant) {
        DeviceProfile deviceProfile = new DeviceProfile();
        deviceProfile.setTenantId(tenant.getId());
        deviceProfile.setTransportType(DeviceTransportType.MQTT);
        deviceProfile.setName("Test device profile");
        deviceProfile.setType(DeviceProfileType.DEFAULT);
        DeviceProfileData profileData = new DeviceProfileData();
        profileData.setTransportConfiguration((DeviceProfileTransportConfiguration)new MqttDeviceProfileTransportConfiguration());
        deviceProfile.setProfileData(profileData);
        return this.deviceProfileService.saveDeviceProfile(deviceProfile);
    }

    private WidgetsBundle createAndSaveWidgetBundleFor(Tenant tenant) {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTenantId(tenant.getId());
        widgetsBundle.setTitle("Test widgets bundle");
        widgetsBundle.setAlias("TestWidgetsBundle");
        widgetsBundle.setDescription("Just a simple widgets bundle");
        return this.widgetsBundleService.saveWidgetsBundle(widgetsBundle);
    }

    private Customer createAndSaveCustomerFor(Tenant tenant) {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(tenant.getId());
        customer.setEmail("testCustomer@test.com");
        return this.customerService.saveCustomer(customer);
    }

    private User createAndSaveUserFor(Tenant tenant) {
        User user = new User();
        user.setAuthority(Authority.TENANT_ADMIN);
        user.setEmail("tenantAdmin@test.com");
        user.setFirstName("tenantAdmin");
        user.setLastName("tenantAdmin");
        user.setTenantId(tenant.getId());
        return this.userService.saveUser(TenantId.SYS_TENANT_ID, user);
    }

    private Tenant createAndSaveTenant(TenantProfile tenantProfile) {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        tenant.setTenantProfileId(tenantProfile.getId());
        return this.tenantService.saveTenant(tenant);
    }

    private TenantProfile createAndSaveTenantProfile() {
        TenantProfile tenantProfile = new TenantProfile();
        tenantProfile.setName("Test tenant profile");
        return this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
    }
}

