/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.data.queue.ProcessingStrategyType;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.common.data.queue.SubmitStrategyType;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.gen.transport.TransportProtos;

@DaoSqlTest
public class TenantProfileServiceTest
extends AbstractServiceTest {
    @Autowired
    TenantProfileService tenantProfileService;
    private AbstractServiceTest.IdComparator<TenantProfile> idComparator = new AbstractServiceTest.IdComparator();
    private AbstractServiceTest.IdComparator<EntityInfo> tenantProfileInfoIdComparator = new AbstractServiceTest.IdComparator();

    @Before
    public void before() {
        this.tenantId = null;
        this.tenantService.deleteTenants();
        this.tenantProfileService.deleteTenantProfiles(TenantId.SYS_TENANT_ID);
    }

    @After
    public void after() {
        this.tenantProfileService.deleteTenantProfiles(TenantId.SYS_TENANT_ID);
    }

    @Test
    public void testSaveTenantProfile() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        tenantProfile.setIsolatedTbRuleEngine(true);
        TenantProfileQueueConfiguration mainQueueConfiguration = new TenantProfileQueueConfiguration();
        mainQueueConfiguration.setName("Main");
        mainQueueConfiguration.setTopic("tb_rule_engine.main");
        mainQueueConfiguration.setPollInterval(25);
        mainQueueConfiguration.setPartitions(10);
        mainQueueConfiguration.setConsumerPerPartition(true);
        mainQueueConfiguration.setPackProcessingTimeout(2000L);
        SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
        mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
        mainQueueSubmitStrategy.setBatchSize(1000);
        mainQueueConfiguration.setSubmitStrategy(mainQueueSubmitStrategy);
        ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
        mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
        mainQueueProcessingStrategy.setRetries(3);
        mainQueueProcessingStrategy.setFailurePercentage(0.0);
        mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
        mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
        mainQueueConfiguration.setProcessingStrategy(mainQueueProcessingStrategy);
        mainQueueConfiguration.setAdditionalInfo((JsonNode)NullNode.getInstance());
        tenantProfile.getProfileData().setQueueConfiguration(Collections.singletonList(mainQueueConfiguration));
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        Assert.assertNotNull((Object)savedTenantProfile);
        Assert.assertNotNull((Object)savedTenantProfile.getId());
        Assert.assertTrue((savedTenantProfile.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)tenantProfile.getName(), (Object)savedTenantProfile.getName());
        Assert.assertEquals((Object)tenantProfile.getDescription(), (Object)savedTenantProfile.getDescription());
        Assert.assertEquals((Object)tenantProfile.getProfileData(), (Object)savedTenantProfile.getProfileData());
        Assert.assertEquals((Object)tenantProfile.isDefault(), (Object)savedTenantProfile.isDefault());
        Assert.assertEquals((Object)tenantProfile.isIsolatedTbRuleEngine(), (Object)savedTenantProfile.isIsolatedTbRuleEngine());
        savedTenantProfile.setName("New tenant profile");
        this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, savedTenantProfile);
        TenantProfile foundTenantProfile = this.tenantProfileService.findTenantProfileById(TenantId.SYS_TENANT_ID, savedTenantProfile.getId());
        Assert.assertEquals((Object)foundTenantProfile.getName(), (Object)savedTenantProfile.getName());
    }

    @Test
    public void testFindTenantProfileById() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        TenantProfile foundTenantProfile = this.tenantProfileService.findTenantProfileById(TenantId.SYS_TENANT_ID, savedTenantProfile.getId());
        Assert.assertNotNull((Object)foundTenantProfile);
        Assert.assertEquals((Object)savedTenantProfile, (Object)foundTenantProfile);
    }

    @Test
    public void testFindTenantProfileInfoById() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        EntityInfo foundTenantProfileInfo = this.tenantProfileService.findTenantProfileInfoById(TenantId.SYS_TENANT_ID, savedTenantProfile.getId());
        Assert.assertNotNull((Object)foundTenantProfileInfo);
        Assert.assertEquals((Object)savedTenantProfile.getId(), (Object)foundTenantProfileInfo.getId());
        Assert.assertEquals((Object)savedTenantProfile.getName(), (Object)foundTenantProfileInfo.getName());
    }

    @Test
    public void testFindDefaultTenantProfile() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Default Tenant Profile");
        tenantProfile.setDefault(true);
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        TenantProfile foundDefaultTenantProfile = this.tenantProfileService.findDefaultTenantProfile(TenantId.SYS_TENANT_ID);
        Assert.assertNotNull((Object)foundDefaultTenantProfile);
        Assert.assertEquals((Object)savedTenantProfile, (Object)foundDefaultTenantProfile);
    }

    @Test
    public void testFindDefaultTenantProfileInfo() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Default Tenant Profile");
        tenantProfile.setDefault(true);
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        EntityInfo foundDefaultTenantProfileInfo = this.tenantProfileService.findDefaultTenantProfileInfo(TenantId.SYS_TENANT_ID);
        Assert.assertNotNull((Object)foundDefaultTenantProfileInfo);
        Assert.assertEquals((Object)savedTenantProfile.getId(), (Object)foundDefaultTenantProfileInfo.getId());
        Assert.assertEquals((Object)savedTenantProfile.getName(), (Object)foundDefaultTenantProfileInfo.getName());
    }

    @Test
    public void testSetDefaultTenantProfile() {
        TenantProfile tenantProfile1 = TenantProfileServiceTest.createTenantProfile("Tenant Profile 1");
        TenantProfile tenantProfile2 = TenantProfileServiceTest.createTenantProfile("Tenant Profile 2");
        TenantProfile savedTenantProfile1 = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile1);
        TenantProfile savedTenantProfile2 = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile2);
        boolean result = this.tenantProfileService.setDefaultTenantProfile(TenantId.SYS_TENANT_ID, savedTenantProfile1.getId());
        Assert.assertTrue((boolean)result);
        TenantProfile defaultTenantProfile = this.tenantProfileService.findDefaultTenantProfile(TenantId.SYS_TENANT_ID);
        Assert.assertNotNull((Object)defaultTenantProfile);
        Assert.assertEquals((Object)savedTenantProfile1.getId(), (Object)defaultTenantProfile.getId());
        result = this.tenantProfileService.setDefaultTenantProfile(TenantId.SYS_TENANT_ID, savedTenantProfile2.getId());
        Assert.assertTrue((boolean)result);
        defaultTenantProfile = this.tenantProfileService.findDefaultTenantProfile(TenantId.SYS_TENANT_ID);
        Assert.assertNotNull((Object)defaultTenantProfile);
        Assert.assertEquals((Object)savedTenantProfile2.getId(), (Object)defaultTenantProfile.getId());
    }

    @Test
    public void testSaveTenantProfileWithEmptyName() {
        TenantProfile tenantProfile = new TenantProfile();
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile));
    }

    @Test
    public void testSaveTenantProfileWithSameName() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        TenantProfile tenantProfile2 = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTenantProfileWithExistingTenant() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        Tenant tenant = new Tenant();
        tenant.setTitle("Test tenant");
        tenant.setTenantProfileId(savedTenantProfile.getId());
        tenant = this.tenantService.saveTenant(tenant);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.tenantProfileService.deleteTenantProfile(TenantId.SYS_TENANT_ID, savedTenantProfile.getId()));
        }
        finally {
            this.tenantService.deleteTenant(tenant.getId());
        }
    }

    @Test
    public void testDeleteTenantProfile() {
        TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile");
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        this.tenantProfileService.deleteTenantProfile(TenantId.SYS_TENANT_ID, savedTenantProfile.getId());
        TenantProfile foundTenantProfile = this.tenantProfileService.findTenantProfileById(TenantId.SYS_TENANT_ID, savedTenantProfile.getId());
        Assert.assertNull((Object)foundTenantProfile);
    }

    @Test
    public void testFindTenantProfiles() {
        ArrayList<TenantProfile> tenantProfiles = new ArrayList<TenantProfile>();
        PageLink pageLink = new PageLink(17);
        PageData pageData = this.tenantProfileService.findTenantProfiles(TenantId.SYS_TENANT_ID, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
        tenantProfiles.addAll(pageData.getData());
        for (int i = 0; i < 28; ++i) {
            TenantProfile tenantProfile = TenantProfileServiceTest.createTenantProfile("Tenant Profile" + i);
            tenantProfiles.add(this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile));
        }
        ArrayList loadedTenantProfiles = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.tenantProfileService.findTenantProfiles(TenantId.SYS_TENANT_ID, pageLink);
            loadedTenantProfiles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantProfiles, this.idComparator);
        Collections.sort(loadedTenantProfiles, this.idComparator);
        Assert.assertEquals(tenantProfiles, loadedTenantProfiles);
        for (TenantProfile tenantProfile : loadedTenantProfiles) {
            this.tenantProfileService.deleteTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.tenantProfileService.findTenantProfiles(TenantId.SYS_TENANT_ID, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindTenantProfileInfos() {
        PageData pageData;
        ArrayList<TenantProfile> tenantProfiles = new ArrayList<TenantProfile>();
        for (int i = 0; i < 28; ++i) {
            TenantProfile tenantProfile2 = TenantProfileServiceTest.createTenantProfile("Tenant Profile" + i);
            tenantProfiles.add(this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile2));
        }
        ArrayList loadedTenantProfileInfos = new ArrayList();
        PageLink pageLink = new PageLink(17);
        do {
            pageData = this.tenantProfileService.findTenantProfileInfos(TenantId.SYS_TENANT_ID, pageLink);
            loadedTenantProfileInfos.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(tenantProfiles, this.idComparator);
        Collections.sort(loadedTenantProfileInfos, this.tenantProfileInfoIdComparator);
        List tenantProfileInfos = tenantProfiles.stream().map(tenantProfile -> new EntityInfo((EntityId)tenantProfile.getId(), tenantProfile.getName())).collect(Collectors.toList());
        Assert.assertEquals(tenantProfileInfos, loadedTenantProfileInfos);
        for (EntityInfo tenantProfile3 : loadedTenantProfileInfos) {
            this.tenantProfileService.deleteTenantProfile(TenantId.SYS_TENANT_ID, new TenantProfileId(tenantProfile3.getId().getId()));
        }
        pageLink = new PageLink(17);
        pageData = this.tenantProfileService.findTenantProfileInfos(TenantId.SYS_TENANT_ID, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testTenantProfileSerialization_proto() {
        TenantProfile tenantProfile = new TenantProfile();
        tenantProfile.setId((UUIDBased)new TenantProfileId(UUID.randomUUID()));
        tenantProfile.setName("testProfile");
        TenantProfileData profileData = new TenantProfileData();
        tenantProfile.setProfileData(profileData);
        profileData.setConfiguration((TenantProfileConfiguration)new DefaultTenantProfileConfiguration());
        TenantProfileServiceTest.addMainQueueConfig(tenantProfile);
        byte[] serialized = (byte[])org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ProtoUtils.toProto((TenantProfile)tenantProfile).toByteArray());
        TenantProfile deserialized = (TenantProfile)org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ProtoUtils.fromProto((TransportProtos.TenantProfileProto)TransportProtos.TenantProfileProto.parseFrom((byte[])serialized)));
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)tenantProfile);
        Assertions.assertThat((Object)deserialized.getProfileData()).isNotNull();
        Assertions.assertThat((List)deserialized.getProfileData().getQueueConfiguration()).isNotEmpty();
    }

    public static TenantProfile createTenantProfile(String name) {
        TenantProfile tenantProfile = new TenantProfile();
        tenantProfile.setName(name);
        tenantProfile.setDescription(name + " Test");
        TenantProfileData profileData = new TenantProfileData();
        profileData.setConfiguration((TenantProfileConfiguration)new DefaultTenantProfileConfiguration());
        tenantProfile.setProfileData(profileData);
        tenantProfile.setDefault(false);
        tenantProfile.setIsolatedTbRuleEngine(false);
        return tenantProfile;
    }

    public static void addMainQueueConfig(TenantProfile tenantProfile) {
        TenantProfileQueueConfiguration mainQueueConfiguration = new TenantProfileQueueConfiguration();
        mainQueueConfiguration.setName("Main");
        mainQueueConfiguration.setTopic("tb_rule_engine.main");
        mainQueueConfiguration.setPollInterval(25);
        mainQueueConfiguration.setPartitions(10);
        mainQueueConfiguration.setConsumerPerPartition(true);
        mainQueueConfiguration.setPackProcessingTimeout(2000L);
        SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
        mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
        mainQueueSubmitStrategy.setBatchSize(1000);
        mainQueueConfiguration.setSubmitStrategy(mainQueueSubmitStrategy);
        ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
        mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
        mainQueueProcessingStrategy.setRetries(3);
        mainQueueProcessingStrategy.setFailurePercentage(0.0);
        mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
        mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
        mainQueueConfiguration.setProcessingStrategy(mainQueueProcessingStrategy);
        TenantProfileData profileData = tenantProfile.getProfileData();
        profileData.setQueueConfiguration(Collections.singletonList(mainQueueConfiguration));
        tenantProfile.setProfileData(profileData);
    }
}

