/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class TbCacheSerializationTest
extends AbstractServiceTest {
    @Autowired
    TbTransactionalCache<TenantId, PageData<EntitySubtype>> alarmTypesCache;

    @Test
    public void AlarmTypesSerializationTest() {
        int typesCount = 13;
        TenantId tenantId = new TenantId(UUID.randomUUID());
        ArrayList<EntitySubtype> types = new ArrayList<EntitySubtype>(typesCount);
        for (int i = 0; i < typesCount; ++i) {
            types.add(new EntitySubtype(tenantId, EntityType.ALARM, "alarm_type_" + i));
        }
        PageData alarmTypesPage = new PageData(types, 1, (long)typesCount, false);
        this.alarmTypesCache.put((Serializable)tenantId, (Serializable)alarmTypesPage);
        PageData foundAlarmTypes = (PageData)this.alarmTypesCache.get((Serializable)tenantId).get();
        Assert.assertEquals((Object)alarmTypesPage, (Object)foundAlarmTypes);
    }
}

