/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class RuleChainServiceTest
extends AbstractServiceTest {
    @Autowired
    EdgeService edgeService;
    @Autowired
    RuleChainService ruleChainService;
    @Autowired
    RelationService relationService;
    private AbstractServiceTest.IdComparator<RuleChain> idComparator = new AbstractServiceTest.IdComparator();
    private AbstractServiceTest.IdComparator<RuleNode> ruleNodeIdComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveRuleChain() throws IOException {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setName("My RuleChain");
        RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
        Assert.assertNotNull((Object)savedRuleChain);
        Assert.assertNotNull((Object)savedRuleChain.getId());
        Assert.assertTrue((savedRuleChain.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)ruleChain.getTenantId(), (Object)savedRuleChain.getTenantId());
        Assert.assertEquals((Object)ruleChain.getName(), (Object)savedRuleChain.getName());
        savedRuleChain.setName("My new RuleChain");
        this.ruleChainService.saveRuleChain(savedRuleChain);
        RuleChain foundRuleChain = this.ruleChainService.findRuleChainById(this.tenantId, savedRuleChain.getId());
        Assert.assertEquals((Object)foundRuleChain.getName(), (Object)savedRuleChain.getName());
        this.ruleChainService.deleteRuleChainById(this.tenantId, savedRuleChain.getId());
    }

    @Test
    public void testSaveRuleChainWithEmptyName() {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.ruleChainService.saveRuleChain(ruleChain));
    }

    @Test
    public void testSaveRuleChainWithInvalidTenant() {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setName("My RuleChain");
        ruleChain.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.ruleChainService.saveRuleChain(ruleChain));
    }

    @Test
    public void testFindRuleChainById() {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setName("My RuleChain");
        RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
        RuleChain foundRuleChain = this.ruleChainService.findRuleChainById(this.tenantId, savedRuleChain.getId());
        Assert.assertNotNull((Object)foundRuleChain);
        Assert.assertEquals((Object)savedRuleChain, (Object)foundRuleChain);
        this.ruleChainService.deleteRuleChainById(this.tenantId, savedRuleChain.getId());
    }

    @Test
    public void testDeleteRuleChain() {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setName("My RuleChain");
        RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
        RuleChain foundRuleChain = this.ruleChainService.findRuleChainById(this.tenantId, savedRuleChain.getId());
        Assert.assertNotNull((Object)foundRuleChain);
        this.ruleChainService.deleteRuleChainById(this.tenantId, savedRuleChain.getId());
        foundRuleChain = this.ruleChainService.findRuleChainById(this.tenantId, savedRuleChain.getId());
        Assert.assertNull((Object)foundRuleChain);
    }

    @Test
    public void testFindRuleChainsByTenantId() {
        ArrayList<RuleChain> ruleChains = new ArrayList<RuleChain>();
        for (int i = 0; i < 165; ++i) {
            RuleChain ruleChain = new RuleChain();
            ruleChain.setTenantId(this.tenantId);
            ruleChain.setName("RuleChain" + i);
            ruleChains.add(this.ruleChainService.saveRuleChain(ruleChain));
        }
        ArrayList loadedRuleChains = new ArrayList();
        PageLink pageLink = new PageLink(16);
        PageData pageData = null;
        do {
            pageData = this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, pageLink);
            loadedRuleChains.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(ruleChains, this.idComparator);
        Collections.sort(loadedRuleChains, this.idComparator);
        Assert.assertEquals(ruleChains, loadedRuleChains);
        this.ruleChainService.deleteRuleChainsByTenantId(this.tenantId);
        pageLink = new PageLink(31);
        pageData = this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindRuleChainsByTenantIdAndName() {
        String name1 = "RuleChain name 1";
        ArrayList<RuleChain> ruleChainsName1 = new ArrayList<RuleChain>();
        for (int i = 0; i < 123; ++i) {
            RuleChain ruleChain = new RuleChain();
            ruleChain.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 17.0)));
            Object name = name1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            ruleChain.setName((String)name);
            ruleChainsName1.add(this.ruleChainService.saveRuleChain(ruleChain));
        }
        String name2 = "RuleChain name 2";
        ArrayList<RuleChain> ruleChainsName2 = new ArrayList<RuleChain>();
        for (int i = 0; i < 193; ++i) {
            RuleChain ruleChain = new RuleChain();
            ruleChain.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 15.0)));
            Object name = name2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            ruleChain.setName((String)name);
            ruleChainsName2.add(this.ruleChainService.saveRuleChain(ruleChain));
        }
        ArrayList loadedRuleChainsName1 = new ArrayList();
        PageLink pageLink = new PageLink(19, 0, name1);
        PageData pageData = null;
        do {
            pageData = this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, pageLink);
            loadedRuleChainsName1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(ruleChainsName1, this.idComparator);
        Collections.sort(loadedRuleChainsName1, this.idComparator);
        Assert.assertEquals(ruleChainsName1, loadedRuleChainsName1);
        ArrayList loadedRuleChainsName2 = new ArrayList();
        pageLink = new PageLink(4, 0, name2);
        do {
            pageData = this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, pageLink);
            loadedRuleChainsName2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(ruleChainsName2, this.idComparator);
        Collections.sort(loadedRuleChainsName2, this.idComparator);
        Assert.assertEquals(ruleChainsName2, loadedRuleChainsName2);
        for (RuleChain ruleChain : loadedRuleChainsName1) {
            this.ruleChainService.deleteRuleChainById(this.tenantId, ruleChain.getId());
        }
        pageLink = new PageLink(4, 0, name1);
        pageData = this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (RuleChain ruleChain : loadedRuleChainsName2) {
            this.ruleChainService.deleteRuleChainById(this.tenantId, ruleChain.getId());
        }
        pageLink = new PageLink(4, 0, name2);
        pageData = this.ruleChainService.findTenantRuleChainsByType(this.tenantId, RuleChainType.CORE, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testSaveRuleChainMetaData() throws Exception {
        RuleChainMetaData savedRuleChainMetaData = this.createRuleChainMetadata();
        Assert.assertEquals((long)3L, (long)savedRuleChainMetaData.getNodes().size());
        Assert.assertEquals((long)3L, (long)savedRuleChainMetaData.getConnections().size());
        for (RuleNode ruleNode : savedRuleChainMetaData.getNodes()) {
            Assert.assertNotNull((Object)ruleNode.getId());
            List relations = this.ruleChainService.getRuleNodeRelations(this.tenantId, ruleNode.getId());
            if ("name1".equals(ruleNode.getName())) {
                Assert.assertEquals((long)2L, (long)relations.size());
                continue;
            }
            if ("name2".equals(ruleNode.getName())) {
                Assert.assertEquals((long)1L, (long)relations.size());
                continue;
            }
            if (!"name3".equals(ruleNode.getName())) continue;
            Assert.assertEquals((long)0L, (long)relations.size());
        }
        List loadedRuleNodes = this.ruleChainService.getRuleChainNodes(this.tenantId, savedRuleChainMetaData.getRuleChainId());
        Collections.sort(savedRuleChainMetaData.getNodes(), this.ruleNodeIdComparator);
        Collections.sort(loadedRuleNodes, this.ruleNodeIdComparator);
        Assert.assertEquals((Object)savedRuleChainMetaData.getNodes(), (Object)loadedRuleNodes);
        this.ruleChainService.deleteRuleChainById(this.tenantId, savedRuleChainMetaData.getRuleChainId());
    }

    @Test
    public void testUpdateRuleChainMetaData() throws Exception {
        RuleChainMetaData savedRuleChainMetaData = this.createRuleChainMetadata();
        List ruleNodes = savedRuleChainMetaData.getNodes();
        int name3Index = -1;
        for (int i = 0; i < ruleNodes.size(); ++i) {
            if (!"name3".equals(((RuleNode)ruleNodes.get(i)).getName())) continue;
            name3Index = i;
            break;
        }
        RuleNode ruleNode4 = new RuleNode();
        ruleNode4.setName("name4");
        ruleNode4.setType("type4");
        ruleNode4.setConfiguration(JacksonUtil.toJsonNode((String)"\"key4\": \"val4\""));
        ruleNodes.set(name3Index, ruleNode4);
        Assert.assertTrue((boolean)this.ruleChainService.saveRuleChainMetaData(this.tenantId, savedRuleChainMetaData, Function.identity()).isSuccess());
        RuleChainMetaData updatedRuleChainMetaData = this.ruleChainService.loadRuleChainMetaData(this.tenantId, savedRuleChainMetaData.getRuleChainId());
        Assert.assertEquals((long)3L, (long)updatedRuleChainMetaData.getNodes().size());
        Assert.assertEquals((long)3L, (long)updatedRuleChainMetaData.getConnections().size());
        for (RuleNode ruleNode : updatedRuleChainMetaData.getNodes()) {
            Assert.assertNotNull((Object)ruleNode.getId());
            List relations = this.ruleChainService.getRuleNodeRelations(this.tenantId, ruleNode.getId());
            if ("name1".equals(ruleNode.getName())) {
                Assert.assertEquals((long)2L, (long)relations.size());
                continue;
            }
            if ("name2".equals(ruleNode.getName())) {
                Assert.assertEquals((long)1L, (long)relations.size());
                continue;
            }
            if (!"name4".equals(ruleNode.getName())) continue;
            Assert.assertEquals((long)0L, (long)relations.size());
        }
        List loadedRuleNodes = this.ruleChainService.getRuleChainNodes(this.tenantId, savedRuleChainMetaData.getRuleChainId());
        Collections.sort(updatedRuleChainMetaData.getNodes(), this.ruleNodeIdComparator);
        Collections.sort(loadedRuleNodes, this.ruleNodeIdComparator);
        Assert.assertEquals((Object)updatedRuleChainMetaData.getNodes(), (Object)loadedRuleNodes);
        this.ruleChainService.deleteRuleChainById(this.tenantId, savedRuleChainMetaData.getRuleChainId());
    }

    @Test
    public void testUpdateRuleChainMetaDataWithCirclingRelation() {
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.ruleChainService.saveRuleChainMetaData(this.tenantId, this.createRuleChainMetadataWithCirclingRelation(), Function.identity()));
    }

    @Test
    public void testUpdateRuleChainMetaDataWithCirclingRelation2() {
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.ruleChainService.saveRuleChainMetaData(this.tenantId, this.createRuleChainMetadataWithCirclingRelation2(), Function.identity()));
    }

    @Test
    public void testGetDefaultEdgeRuleChains() throws Exception {
        RuleChainId ruleChainId = this.saveRuleChainAndSetAutoAssignToEdge("Default Edge Rule Chain 1");
        this.saveRuleChainAndSetAutoAssignToEdge("Default Edge Rule Chain 2");
        PageData result = this.ruleChainService.findAutoAssignToEdgeRuleChainsByTenantId(this.tenantId, new PageLink(100));
        Assert.assertEquals((long)2L, (long)result.getData().size());
        this.ruleChainService.unsetAutoAssignToEdgeRuleChain(this.tenantId, ruleChainId);
        result = this.ruleChainService.findAutoAssignToEdgeRuleChainsByTenantId(this.tenantId, new PageLink(100));
        Assert.assertEquals((long)1L, (long)result.getData().size());
    }

    @Test
    public void setEdgeTemplateRootRuleChain() throws Exception {
        RuleChainId ruleChainId1 = this.saveRuleChainAndSetAutoAssignToEdge("Default Edge Rule Chain 1");
        RuleChainId ruleChainId2 = this.saveRuleChainAndSetAutoAssignToEdge("Default Edge Rule Chain 2");
        this.ruleChainService.setEdgeTemplateRootRuleChain(this.tenantId, ruleChainId1);
        this.ruleChainService.setEdgeTemplateRootRuleChain(this.tenantId, ruleChainId2);
        RuleChain ruleChainById = this.ruleChainService.findRuleChainById(this.tenantId, ruleChainId1);
        Assert.assertFalse((boolean)ruleChainById.isRoot());
        ruleChainById = this.ruleChainService.findRuleChainById(this.tenantId, ruleChainId2);
        Assert.assertTrue((boolean)ruleChainById.isRoot());
    }

    @Test
    public void testSaveRuleChainWithInputNode() {
        RuleChain fromRuleChain = new RuleChain();
        fromRuleChain.setName("From RuleChain");
        fromRuleChain.setTenantId(this.tenantId);
        fromRuleChain = this.ruleChainService.saveRuleChain(fromRuleChain);
        RuleChainId fromRuleChainId = fromRuleChain.getId();
        RuleChain toRuleChain1 = new RuleChain();
        toRuleChain1.setName("To Rule Chain 1");
        toRuleChain1.setTenantId(this.tenantId);
        toRuleChain1 = this.ruleChainService.saveRuleChain(toRuleChain1);
        RuleChainId toRuleChain1Id = toRuleChain1.getId();
        RuleChainMetaData ruleChainMetaData = new RuleChainMetaData();
        ruleChainMetaData.setRuleChainId(fromRuleChainId);
        RuleNode toRuleChain1Node = new RuleNode();
        toRuleChain1Node.setName("To Rule Chain 1");
        toRuleChain1Node.setType("org.thingsboard.rule.engine.flow.TbRuleChainInputNode");
        toRuleChain1Node.setConfiguration((JsonNode)JacksonUtil.newObjectNode().put("ruleChainId", toRuleChain1Id.toString()));
        RuleNode toRuleChain1Node2 = new RuleNode();
        toRuleChain1Node2.setName("To Rule Chain 1");
        toRuleChain1Node2.setType("org.thingsboard.rule.engine.flow.TbRuleChainInputNode");
        toRuleChain1Node2.setConfiguration((JsonNode)JacksonUtil.newObjectNode().put("ruleChainId", toRuleChain1Id.toString()));
        ArrayList<RuleNode> ruleNodes = new ArrayList<RuleNode>();
        ruleNodes.add(toRuleChain1Node);
        ruleNodes.add(toRuleChain1Node2);
        ruleChainMetaData.setFirstNodeIndex(Integer.valueOf(0));
        ruleChainMetaData.setNodes(ruleNodes);
        this.ruleChainService.saveRuleChainMetaData(this.tenantId, ruleChainMetaData, Function.identity());
        List relations = this.relationService.findByFromAndType(this.tenantId, (EntityId)fromRuleChainId, "Uses", RelationTypeGroup.COMMON);
        ((ObjectAssert)Assertions.assertThat((List)relations).singleElement()).satisfies(new ThrowingConsumer[]{relationToRuleChain1 -> {
            Assertions.assertThat((Object)relationToRuleChain1.getFrom()).isEqualTo((Object)fromRuleChainId);
            Assertions.assertThat((Object)relationToRuleChain1.getTo()).isEqualTo((Object)toRuleChain1Id);
        }});
        RuleChain toRuleChain2 = new RuleChain();
        toRuleChain2.setName("To Rule Chain 2");
        toRuleChain2.setTenantId(this.tenantId);
        toRuleChain2 = this.ruleChainService.saveRuleChain(toRuleChain2);
        RuleChainId toRuleChain2Id = toRuleChain2.getId();
        RuleNode toRuleChain2Node = new RuleNode();
        toRuleChain2Node.setName("To Rule Chain 2");
        toRuleChain2Node.setType("org.thingsboard.rule.engine.flow.TbRuleChainInputNode");
        toRuleChain2Node.setConfiguration((JsonNode)JacksonUtil.newObjectNode().put("ruleChainId", toRuleChain2Id.toString()));
        ArrayList<RuleNode> newRuleNodes = new ArrayList<RuleNode>();
        newRuleNodes.add(toRuleChain2Node);
        newRuleNodes.add(toRuleChain1Node);
        ruleChainMetaData = this.ruleChainService.loadRuleChainMetaData(this.tenantId, ruleChainMetaData.getRuleChainId());
        ruleChainMetaData.setNodes(newRuleNodes);
        this.ruleChainService.saveRuleChainMetaData(this.tenantId, ruleChainMetaData, Function.identity());
        List newRelations = this.relationService.findByFromAndType(this.tenantId, (EntityId)fromRuleChainId, "Uses", RelationTypeGroup.COMMON);
        Assertions.assertThat((List)newRelations).hasSize(2);
        Assertions.assertThat((List)newRelations).anySatisfy(relationToRuleChain1 -> {
            Assertions.assertThat((Object)relationToRuleChain1.getFrom()).isEqualTo((Object)fromRuleChainId);
            Assertions.assertThat((Object)relationToRuleChain1.getTo()).isEqualTo((Object)toRuleChain1Id);
        });
        Assertions.assertThat((List)newRelations).anySatisfy(relationToRuleChain2 -> {
            Assertions.assertThat((Object)relationToRuleChain2.getFrom()).isEqualTo((Object)fromRuleChainId);
            Assertions.assertThat((Object)relationToRuleChain2.getTo()).isEqualTo((Object)toRuleChain2Id);
        });
    }

    private RuleChainId saveRuleChainAndSetAutoAssignToEdge(String name) {
        RuleChain edgeRuleChain = new RuleChain();
        edgeRuleChain.setTenantId(this.tenantId);
        edgeRuleChain.setType(RuleChainType.EDGE);
        edgeRuleChain.setName(name);
        RuleChain savedEdgeRuleChain = this.ruleChainService.saveRuleChain(edgeRuleChain);
        this.ruleChainService.setAutoAssignToEdgeRuleChain(this.tenantId, savedEdgeRuleChain.getId());
        return savedEdgeRuleChain.getId();
    }

    private RuleChainMetaData createRuleChainMetadata() throws Exception {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setName("My RuleChain");
        ruleChain.setTenantId(this.tenantId);
        RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
        RuleChainMetaData ruleChainMetaData = new RuleChainMetaData();
        ruleChainMetaData.setRuleChainId(savedRuleChain.getId());
        RuleNode ruleNode1 = new RuleNode();
        ruleNode1.setName("name1");
        ruleNode1.setType("type1");
        ruleNode1.setConfiguration(JacksonUtil.toJsonNode((String)"\"key1\": \"val1\""));
        RuleNode ruleNode2 = new RuleNode();
        ruleNode2.setName("name2");
        ruleNode2.setType("type2");
        ruleNode2.setConfiguration(JacksonUtil.toJsonNode((String)"\"key2\": \"val2\""));
        RuleNode ruleNode3 = new RuleNode();
        ruleNode3.setName("name3");
        ruleNode3.setType("type3");
        ruleNode3.setConfiguration(JacksonUtil.toJsonNode((String)"\"key3\": \"val3\""));
        ArrayList<RuleNode> ruleNodes = new ArrayList<RuleNode>();
        ruleNodes.add(ruleNode1);
        ruleNodes.add(ruleNode2);
        ruleNodes.add(ruleNode3);
        ruleChainMetaData.setFirstNodeIndex(Integer.valueOf(0));
        ruleChainMetaData.setNodes(ruleNodes);
        ruleChainMetaData.addConnectionInfo(0, 1, "success");
        ruleChainMetaData.addConnectionInfo(0, 2, "fail");
        ruleChainMetaData.addConnectionInfo(1, 2, "success");
        Assert.assertTrue((boolean)this.ruleChainService.saveRuleChainMetaData(this.tenantId, ruleChainMetaData, Function.identity()).isSuccess());
        return this.ruleChainService.loadRuleChainMetaData(this.tenantId, ruleChainMetaData.getRuleChainId());
    }

    private RuleChainMetaData createRuleChainMetadataWithCirclingRelation() throws Exception {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setName("My RuleChain");
        ruleChain.setTenantId(this.tenantId);
        RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
        RuleChainMetaData ruleChainMetaData = new RuleChainMetaData();
        ruleChainMetaData.setRuleChainId(savedRuleChain.getId());
        RuleNode ruleNode1 = new RuleNode();
        ruleNode1.setName("name1");
        ruleNode1.setType("type1");
        ruleNode1.setConfiguration(JacksonUtil.toJsonNode((String)"\"key1\": \"val1\""));
        RuleNode ruleNode2 = new RuleNode();
        ruleNode2.setName("name2");
        ruleNode2.setType("type2");
        ruleNode2.setConfiguration(JacksonUtil.toJsonNode((String)"\"key2\": \"val2\""));
        RuleNode ruleNode3 = new RuleNode();
        ruleNode3.setName("name3");
        ruleNode3.setType("type3");
        ruleNode3.setConfiguration(JacksonUtil.toJsonNode((String)"\"key3\": \"val3\""));
        ArrayList<RuleNode> ruleNodes = new ArrayList<RuleNode>();
        ruleNodes.add(ruleNode1);
        ruleNodes.add(ruleNode2);
        ruleNodes.add(ruleNode3);
        ruleChainMetaData.setFirstNodeIndex(Integer.valueOf(0));
        ruleChainMetaData.setNodes(ruleNodes);
        ruleChainMetaData.addConnectionInfo(0, 1, "success");
        ruleChainMetaData.addConnectionInfo(0, 2, "fail");
        ruleChainMetaData.addConnectionInfo(1, 2, "success");
        ruleChainMetaData.addConnectionInfo(2, 2, "success");
        return ruleChainMetaData;
    }

    private RuleChainMetaData createRuleChainMetadataWithCirclingRelation2() throws Exception {
        RuleChain ruleChain = new RuleChain();
        ruleChain.setName("My RuleChain");
        ruleChain.setTenantId(this.tenantId);
        RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
        RuleChainMetaData ruleChainMetaData = new RuleChainMetaData();
        ruleChainMetaData.setRuleChainId(savedRuleChain.getId());
        RuleNode ruleNode1 = new RuleNode();
        ruleNode1.setName("name1");
        ruleNode1.setType("type1");
        ruleNode1.setConfiguration(JacksonUtil.toJsonNode((String)"\"key1\": \"val1\""));
        RuleNode ruleNode2 = new RuleNode();
        ruleNode2.setName("name2");
        ruleNode2.setType("type2");
        ruleNode2.setConfiguration(JacksonUtil.toJsonNode((String)"\"key2\": \"val2\""));
        RuleNode ruleNode3 = new RuleNode();
        ruleNode3.setName("name3");
        ruleNode3.setType("type3");
        ruleNode3.setConfiguration(JacksonUtil.toJsonNode((String)"\"key3\": \"val3\""));
        ArrayList<RuleNode> ruleNodes = new ArrayList<RuleNode>();
        ruleNodes.add(ruleNode1);
        ruleNodes.add(ruleNode2);
        ruleNodes.add(ruleNode3);
        ruleChainMetaData.setFirstNodeIndex(Integer.valueOf(0));
        ruleChainMetaData.setNodes(ruleNodes);
        ruleChainMetaData.addConnectionInfo(0, 1, "success");
        ruleChainMetaData.addConnectionInfo(0, 2, "fail");
        ruleChainMetaData.addConnectionInfo(1, 2, "success");
        ruleChainMetaData.addConnectionInfo(2, 0, "success");
        return ruleChainMetaData;
    }

    @Test
    public void testFindEdgeRuleChainsByTenantIdAndName() {
        Edge edge = this.constructEdge(this.tenantId, "My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        String name1 = "Edge RuleChain name 1";
        ArrayList<RuleChain> ruleChainsName1 = new ArrayList<RuleChain>();
        for (int i = 0; i < 123; ++i) {
            RuleChain ruleChain2 = new RuleChain();
            ruleChain2.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 17.0)));
            Object name = name1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            ruleChain2.setName((String)name);
            ruleChain2.setType(RuleChainType.EDGE);
            ruleChainsName1.add(this.ruleChainService.saveRuleChain(ruleChain2));
        }
        ruleChainsName1.forEach(ruleChain -> this.ruleChainService.assignRuleChainToEdge(this.tenantId, ruleChain.getId(), savedEdge.getId()));
        String name2 = "Edge RuleChain name 2";
        ArrayList<RuleChain> ruleChainsName2 = new ArrayList<RuleChain>();
        for (int i = 0; i < 193; ++i) {
            RuleChain ruleChain3 = new RuleChain();
            ruleChain3.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 15.0)));
            Object name = name2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            ruleChain3.setName((String)name);
            ruleChain3.setType(RuleChainType.EDGE);
            ruleChainsName2.add(this.ruleChainService.saveRuleChain(ruleChain3));
        }
        ruleChainsName2.forEach(ruleChain -> this.ruleChainService.assignRuleChainToEdge(this.tenantId, ruleChain.getId(), savedEdge.getId()));
        ArrayList loadedRuleChainsName1 = new ArrayList();
        PageLink pageLink = new PageLink(19, 0, name1);
        PageData pageData = null;
        do {
            pageData = this.ruleChainService.findRuleChainsByTenantIdAndEdgeId(this.tenantId, savedEdge.getId(), pageLink);
            loadedRuleChainsName1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(ruleChainsName1, this.idComparator);
        Collections.sort(loadedRuleChainsName1, this.idComparator);
        Assert.assertEquals(ruleChainsName1, loadedRuleChainsName1);
        ArrayList loadedRuleChainsName2 = new ArrayList();
        pageLink = new PageLink(4, 0, name2);
        do {
            pageData = this.ruleChainService.findRuleChainsByTenantIdAndEdgeId(this.tenantId, savedEdge.getId(), pageLink);
            loadedRuleChainsName2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(ruleChainsName2, this.idComparator);
        Collections.sort(loadedRuleChainsName2, this.idComparator);
        Assert.assertEquals(ruleChainsName2, loadedRuleChainsName2);
        for (RuleChain ruleChain4 : loadedRuleChainsName1) {
            this.ruleChainService.deleteRuleChainById(this.tenantId, ruleChain4.getId());
        }
        pageLink = new PageLink(4, 0, name1);
        pageData = this.ruleChainService.findRuleChainsByTenantIdAndEdgeId(this.tenantId, savedEdge.getId(), pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (RuleChain ruleChain4 : loadedRuleChainsName2) {
            this.ruleChainService.deleteRuleChainById(this.tenantId, ruleChain4.getId());
        }
        pageLink = new PageLink(4, 0, name2);
        pageData = this.ruleChainService.findRuleChainsByTenantIdAndEdgeId(this.tenantId, savedEdge.getId(), pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testSaveRuleChainWithExistingExternalId() {
        RuleChainId externalRuleChainId = new RuleChainId(UUID.fromString("2675d180-e1e5-11ee-9f06-71b6c7dc2cbf"));
        RuleChain ruleChain = this.getRuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setExternalId(externalRuleChainId);
        this.ruleChainService.saveRuleChain(ruleChain);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.ruleChainService.saveRuleChain(ruleChain)).isInstanceOf(DataValidationException.class)).hasMessage("Rule Chain with such external id already exists!");
        this.ruleChainService.deleteRuleChainsByTenantId(this.tenantId);
    }

    private RuleChain getRuleChain() {
        String ruleChainStr = "{\n  \"name\": \"Root Rule Chain\",\n  \"type\": \"CORE\",\n  \"firstRuleNodeId\": {\n    \"entityType\": \"RULE_NODE\",\n    \"id\": \"91ad0b00-e779-11ee-9cf0-15d8b6079fdb\"\n  },\n  \"debugMode\": false,\n  \"configuration\": null,\n  \"additionalInfo\": null\n}";
        return (RuleChain)JacksonUtil.fromString((String)ruleChainStr, RuleChain.class);
    }
}

