/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationEntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class RelationServiceTest
extends AbstractServiceTest {
    @Autowired
    RelationService relationService;

    @Before
    public void before() {
    }

    @After
    public void after() {
    }

    @Test
    public void testSaveRelation() {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relation = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        Assert.assertNotNull((Object)this.saveRelation(relation));
        Assert.assertTrue((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)parentId, (EntityId)childId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)parentId, (EntityId)childId, "NOT_EXISTING_TYPE", RelationTypeGroup.COMMON));
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)parentId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)parentId, "NOT_EXISTING_TYPE", RelationTypeGroup.COMMON));
    }

    @Test
    public void testDeleteRelation() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        AssetId subChildId = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)childId, (EntityId)subChildId, "Contains");
        this.saveRelation(relationA);
        this.saveRelation(relationB);
        Assert.assertTrue((boolean)((Boolean)this.relationService.deleteRelationAsync(SYSTEM_TENANT_ID, relationA).get()));
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)parentId, (EntityId)childId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertTrue((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)subChildId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertTrue((boolean)((Boolean)this.relationService.deleteRelationAsync(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)subChildId, "Contains", RelationTypeGroup.COMMON).get()));
    }

    @Test
    public void testDeleteRelationConcurrently() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        this.saveRelation(relationA);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (int i = 0; i < 2; ++i) {
            futures.add(this.relationService.deleteRelationAsync(SYSTEM_TENANT_ID, relationA));
        }
        List results = (List)Futures.allAsList(futures).get();
        Assert.assertTrue((boolean)results.contains(true));
    }

    @Test
    public void testDeleteEntityRelations() throws ExecutionException, InterruptedException {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        AssetId subChildId = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)childId, (EntityId)subChildId, "Contains");
        this.saveRelation(relationA);
        this.saveRelation(relationB);
        this.relationService.deleteEntityRelations(SYSTEM_TENANT_ID, (EntityId)childId);
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)parentId, (EntityId)childId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)subChildId, "Contains", RelationTypeGroup.COMMON));
    }

    @Test
    public void testDeleteEntityCommonRelations() {
        AssetId parentId = new AssetId(Uuids.timeBased());
        AssetId childId = new AssetId(Uuids.timeBased());
        AssetId subChildId = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)parentId, (EntityId)childId, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)childId, (EntityId)subChildId, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)parentId, (EntityId)childId, "Manages", RelationTypeGroup.EDGE);
        EntityRelation relationD = new EntityRelation((EntityId)childId, (EntityId)subChildId, "Manages", RelationTypeGroup.EDGE);
        this.saveRelation(relationA);
        this.saveRelation(relationB);
        this.saveRelation(relationC);
        this.saveRelation(relationD);
        this.relationService.deleteEntityCommonRelations(SYSTEM_TENANT_ID, (EntityId)childId);
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)parentId, (EntityId)childId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertFalse((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)subChildId, "Contains", RelationTypeGroup.COMMON));
        Assert.assertTrue((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)parentId, (EntityId)childId, "Manages", RelationTypeGroup.EDGE));
        Assert.assertTrue((boolean)this.relationService.checkRelation(SYSTEM_TENANT_ID, (EntityId)childId, (EntityId)subChildId, "Manages", RelationTypeGroup.EDGE));
    }

    @Test
    public void testFindFrom() throws ExecutionException, InterruptedException {
        AssetId parentA = new AssetId(Uuids.timeBased());
        AssetId parentB = new AssetId(Uuids.timeBased());
        AssetId childA = new AssetId(Uuids.timeBased());
        AssetId childB = new AssetId(Uuids.timeBased());
        EntityRelation relationA1 = new EntityRelation((EntityId)parentA, (EntityId)childA, "Contains");
        EntityRelation relationA2 = new EntityRelation((EntityId)parentA, (EntityId)childB, "Contains");
        EntityRelation relationB1 = new EntityRelation((EntityId)parentB, (EntityId)childA, "Manages");
        EntityRelation relationB2 = new EntityRelation((EntityId)parentB, (EntityId)childB, "Manages");
        this.saveRelation(relationA1);
        this.saveRelation(relationA2);
        this.saveRelation(relationB1);
        this.saveRelation(relationB2);
        List relations = this.relationService.findByFrom(SYSTEM_TENANT_ID, (EntityId)parentA, RelationTypeGroup.COMMON);
        Assert.assertEquals((long)2L, (long)relations.size());
        for (EntityRelation relation : relations) {
            Assert.assertEquals((Object)"Contains", (Object)relation.getType());
            Assert.assertEquals((Object)parentA, (Object)relation.getFrom());
            Assert.assertTrue((childA.equals((Object)relation.getTo()) || childB.equals((Object)relation.getTo()) ? 1 : 0) != 0);
        }
        relations = this.relationService.findByFromAndType(SYSTEM_TENANT_ID, (EntityId)parentA, "Contains", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)2L, (long)relations.size());
        relations = this.relationService.findByFromAndType(SYSTEM_TENANT_ID, (EntityId)parentA, "Manages", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)0L, (long)relations.size());
        relations = this.relationService.findByFrom(SYSTEM_TENANT_ID, (EntityId)parentB, RelationTypeGroup.COMMON);
        Assert.assertEquals((long)2L, (long)relations.size());
        for (EntityRelation relation : relations) {
            Assert.assertEquals((Object)"Manages", (Object)relation.getType());
            Assert.assertEquals((Object)parentB, (Object)relation.getFrom());
            Assert.assertTrue((childA.equals((Object)relation.getTo()) || childB.equals((Object)relation.getTo()) ? 1 : 0) != 0);
        }
        relations = this.relationService.findByFromAndType(SYSTEM_TENANT_ID, (EntityId)parentB, "Contains", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)0L, (long)relations.size());
        relations = this.relationService.findByFromAndType(SYSTEM_TENANT_ID, (EntityId)parentB, "Contains", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)0L, (long)relations.size());
    }

    private EntityRelation saveRelation(EntityRelation relation) {
        return this.relationService.saveRelation(SYSTEM_TENANT_ID, relation);
    }

    @Test
    public void testFindTo() throws ExecutionException, InterruptedException {
        AssetId parentA = new AssetId(Uuids.timeBased());
        AssetId parentB = new AssetId(Uuids.timeBased());
        AssetId childA = new AssetId(Uuids.timeBased());
        AssetId childB = new AssetId(Uuids.timeBased());
        EntityRelation relationA1 = new EntityRelation((EntityId)parentA, (EntityId)childA, "Contains");
        EntityRelation relationA2 = new EntityRelation((EntityId)parentA, (EntityId)childB, "Contains");
        EntityRelation relationB1 = new EntityRelation((EntityId)parentB, (EntityId)childA, "Manages");
        EntityRelation relationB2 = new EntityRelation((EntityId)parentB, (EntityId)childB, "Manages");
        this.saveRelation(relationA1);
        this.saveRelation(relationA2);
        this.saveRelation(relationB1);
        this.saveRelation(relationB2);
        List relations = this.relationService.findByTo(SYSTEM_TENANT_ID, (EntityId)childA, RelationTypeGroup.COMMON);
        Assert.assertEquals((long)2L, (long)relations.size());
        for (EntityRelation relation : relations) {
            Assert.assertEquals((Object)childA, (Object)relation.getTo());
            Assert.assertTrue((parentA.equals((Object)relation.getFrom()) || parentB.equals((Object)relation.getFrom()) ? 1 : 0) != 0);
        }
        relations = this.relationService.findByToAndType(SYSTEM_TENANT_ID, (EntityId)childA, "Contains", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)1L, (long)relations.size());
        relations = this.relationService.findByToAndType(SYSTEM_TENANT_ID, (EntityId)childB, "Manages", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)1L, (long)relations.size());
        relations = this.relationService.findByToAndType(SYSTEM_TENANT_ID, (EntityId)parentA, "Manages", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)0L, (long)relations.size());
        relations = this.relationService.findByToAndType(SYSTEM_TENANT_ID, (EntityId)parentB, "Manages", RelationTypeGroup.COMMON);
        Assert.assertEquals((long)0L, (long)relations.size());
        relations = this.relationService.findByTo(SYSTEM_TENANT_ID, (EntityId)childB, RelationTypeGroup.COMMON);
        Assert.assertEquals((long)2L, (long)relations.size());
        for (EntityRelation relation : relations) {
            Assert.assertEquals((Object)childB, (Object)relation.getTo());
            Assert.assertTrue((parentA.equals((Object)relation.getFrom()) || parentB.equals((Object)relation.getFrom()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCyclicRecursiveRelation() throws ExecutionException, InterruptedException {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)assetB, (EntityId)assetC, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)assetC, (EntityId)assetA, "Contains");
        relationA = this.saveRelation(relationA);
        relationB = this.saveRelation(relationB);
        relationC = this.saveRelation(relationC);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, -1, false));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)3L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationB));
        Assert.assertTrue((boolean)relations.contains(relationC));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)3L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationB));
        Assert.assertTrue((boolean)relations.contains(relationC));
    }

    @Test
    public void testRecursiveRelation() throws ExecutionException, InterruptedException {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        DeviceId deviceD = new DeviceId(Uuids.timeBased());
        EntityRelation relationAB = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationBC = new EntityRelation((EntityId)assetB, (EntityId)assetC, "Contains");
        EntityRelation relationBD = new EntityRelation((EntityId)assetB, (EntityId)deviceD, "Contains");
        relationAB = this.saveRelation(relationAB);
        relationBC = this.saveRelation(relationBC);
        this.saveRelation(relationBD);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, -1, false));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)2L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationAB));
        Assert.assertTrue((boolean)relations.contains(relationBC));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)2L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationAB));
        Assert.assertTrue((boolean)relations.contains(relationBC));
    }

    @Test
    public void testRecursiveRelationDepth() throws ExecutionException, InterruptedException {
        int maxLevel = 1000;
        AssetId root = new AssetId(Uuids.timeBased());
        AssetId left = new AssetId(Uuids.timeBased());
        AssetId right = new AssetId(Uuids.timeBased());
        ArrayList<EntityRelation> expected = new ArrayList<EntityRelation>();
        EntityRelation relationAB = new EntityRelation((EntityId)root, (EntityId)left, "Contains");
        EntityRelation relationBC = new EntityRelation((EntityId)root, (EntityId)right, "Contains");
        expected.add(this.saveRelation(relationAB));
        expected.add(this.saveRelation(relationBC));
        for (int i = 0; i < maxLevel; ++i) {
            AssetId newLeft = new AssetId(Uuids.timeBased());
            AssetId newRight = new AssetId(Uuids.timeBased());
            EntityRelation relationLeft = new EntityRelation((EntityId)left, (EntityId)newLeft, "Contains");
            EntityRelation relationRight = new EntityRelation((EntityId)right, (EntityId)newRight, "Contains");
            expected.add(this.saveRelation(relationLeft));
            expected.add(this.saveRelation(relationRight));
            left = newLeft;
            right = newRight;
        }
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)root, EntitySearchDirection.FROM, -1, false));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)expected.size(), (long)relations.size());
        for (EntityRelation r : expected) {
            Assert.assertTrue((boolean)relations.contains(r));
        }
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)expected.size(), (long)relations.size());
        for (EntityRelation r : expected) {
            Assert.assertTrue((boolean)relations.contains(r));
        }
    }

    @Test
    public void testSaveRelationWithEmptyFrom() throws ExecutionException, InterruptedException {
        EntityRelation relation = new EntityRelation();
        relation.setTo((EntityId)new AssetId(Uuids.timeBased()));
        relation.setType("Contains");
        Assertions.assertThrows(DataValidationException.class, () -> Assert.assertNotNull((Object)this.saveRelation(relation)));
    }

    @Test
    public void testSaveRelationWithEmptyTo() throws ExecutionException, InterruptedException {
        EntityRelation relation = new EntityRelation();
        relation.setFrom((EntityId)new AssetId(Uuids.timeBased()));
        relation.setType("Contains");
        Assertions.assertThrows(DataValidationException.class, () -> Assert.assertNotNull((Object)this.saveRelation(relation)));
    }

    @Test
    public void testSaveRelationWithEmptyType() throws ExecutionException, InterruptedException {
        EntityRelation relation = new EntityRelation();
        relation.setFrom((EntityId)new AssetId(Uuids.timeBased()));
        relation.setTo((EntityId)new AssetId(Uuids.timeBased()));
        Assertions.assertThrows(DataValidationException.class, () -> Assert.assertNotNull((Object)this.saveRelation(relation)));
    }

    @Test
    public void testFindByQueryFetchLastOnlyTreeLike() throws Exception {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        AssetId assetD = new AssetId(Uuids.timeBased());
        AssetId assetE = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)assetA, (EntityId)assetC, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)assetC, (EntityId)assetD, "Contains");
        EntityRelation relationD = new EntityRelation((EntityId)assetC, (EntityId)assetE, "Contains");
        relationA = this.saveRelation(relationA);
        relationB = this.saveRelation(relationB);
        relationC = this.saveRelation(relationC);
        relationD = this.saveRelation(relationD);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, -1, true));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)3L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertFalse((boolean)relations.contains(relationB));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertFalse((boolean)relations.contains(relationB));
    }

    @Test
    public void testFindByQueryFetchLastOnlySingleLinked() throws Exception {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        AssetId assetD = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)assetB, (EntityId)assetC, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)assetC, (EntityId)assetD, "Contains");
        relationA = this.saveRelation(relationA);
        relationB = this.saveRelation(relationB);
        relationC = this.saveRelation(relationC);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, -1, true));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)1L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertFalse((boolean)relations.contains(relationA));
        Assert.assertFalse((boolean)relations.contains(relationB));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertFalse((boolean)relations.contains(relationA));
        Assert.assertFalse((boolean)relations.contains(relationB));
    }

    @Test
    public void testFindByQueryFetchLastOnlyTreeLikeWithMaxLvl() throws Exception {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        AssetId assetD = new AssetId(Uuids.timeBased());
        AssetId assetE = new AssetId(Uuids.timeBased());
        AssetId assetF = new AssetId(Uuids.timeBased());
        AssetId assetG = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)assetA, (EntityId)assetC, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)assetC, (EntityId)assetD, "Contains");
        EntityRelation relationD = new EntityRelation((EntityId)assetC, (EntityId)assetE, "Contains");
        EntityRelation relationE = new EntityRelation((EntityId)assetD, (EntityId)assetF, "Contains");
        EntityRelation relationF = new EntityRelation((EntityId)assetD, (EntityId)assetG, "Contains");
        relationA = this.saveRelation(relationA);
        relationB = this.saveRelation(relationB);
        relationC = this.saveRelation(relationC);
        relationD = this.saveRelation(relationD);
        relationE = this.saveRelation(relationE);
        relationF = this.saveRelation(relationF);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, 2, true));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)3L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertFalse((boolean)relations.contains(relationB));
        Assert.assertFalse((boolean)relations.contains(relationE));
        Assert.assertFalse((boolean)relations.contains(relationF));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertFalse((boolean)relations.contains(relationB));
        Assert.assertFalse((boolean)relations.contains(relationE));
        Assert.assertFalse((boolean)relations.contains(relationF));
    }

    @Test
    public void testFindByQueryTreeLikeWithMaxLvl() throws Exception {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        AssetId assetD = new AssetId(Uuids.timeBased());
        AssetId assetE = new AssetId(Uuids.timeBased());
        AssetId assetF = new AssetId(Uuids.timeBased());
        AssetId assetG = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)assetA, (EntityId)assetC, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)assetC, (EntityId)assetD, "Contains");
        EntityRelation relationD = new EntityRelation((EntityId)assetC, (EntityId)assetE, "Contains");
        EntityRelation relationE = new EntityRelation((EntityId)assetD, (EntityId)assetF, "Contains");
        EntityRelation relationF = new EntityRelation((EntityId)assetD, (EntityId)assetG, "Contains");
        relationA = this.saveRelation(relationA);
        relationB = this.saveRelation(relationB);
        relationC = this.saveRelation(relationC);
        relationD = this.saveRelation(relationD);
        relationE = this.saveRelation(relationE);
        relationF = this.saveRelation(relationF);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, 2, false));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)4L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationB));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertFalse((boolean)relations.contains(relationE));
        Assert.assertFalse((boolean)relations.contains(relationF));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationB));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertFalse((boolean)relations.contains(relationE));
        Assert.assertFalse((boolean)relations.contains(relationF));
    }

    @Test
    public void testFindByQueryTreeLikeWithUnlimLvl() throws Exception {
        AssetId assetA = new AssetId(Uuids.timeBased());
        AssetId assetB = new AssetId(Uuids.timeBased());
        AssetId assetC = new AssetId(Uuids.timeBased());
        AssetId assetD = new AssetId(Uuids.timeBased());
        AssetId assetE = new AssetId(Uuids.timeBased());
        AssetId assetF = new AssetId(Uuids.timeBased());
        AssetId assetG = new AssetId(Uuids.timeBased());
        EntityRelation relationA = new EntityRelation((EntityId)assetA, (EntityId)assetB, "Contains");
        EntityRelation relationB = new EntityRelation((EntityId)assetA, (EntityId)assetC, "Contains");
        EntityRelation relationC = new EntityRelation((EntityId)assetC, (EntityId)assetD, "Contains");
        EntityRelation relationD = new EntityRelation((EntityId)assetC, (EntityId)assetE, "Contains");
        EntityRelation relationE = new EntityRelation((EntityId)assetD, (EntityId)assetF, "Contains");
        EntityRelation relationF = new EntityRelation((EntityId)assetD, (EntityId)assetG, "Contains");
        relationA = this.saveRelation(relationA);
        relationB = this.saveRelation(relationB);
        relationC = this.saveRelation(relationC);
        relationD = this.saveRelation(relationD);
        relationE = this.saveRelation(relationE);
        relationF = this.saveRelation(relationF);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)assetA, EntitySearchDirection.FROM, -1, false));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)6L, (long)relations.size());
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationB));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertTrue((boolean)relations.contains(relationE));
        Assert.assertTrue((boolean)relations.contains(relationF));
        relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertTrue((boolean)relations.contains(relationA));
        Assert.assertTrue((boolean)relations.contains(relationB));
        Assert.assertTrue((boolean)relations.contains(relationC));
        Assert.assertTrue((boolean)relations.contains(relationD));
        Assert.assertTrue((boolean)relations.contains(relationE));
        Assert.assertTrue((boolean)relations.contains(relationF));
    }

    @Test
    public void testFindByQueryLargeHierarchyFetchAllWithUnlimLvl() throws Exception {
        AssetId rootAsset = new AssetId(Uuids.timeBased());
        int hierarchyLvl = 10;
        LinkedList<EntityRelation> expectedRelations = new LinkedList<EntityRelation>();
        this.createAssetRelationsRecursively(rootAsset, 10, expectedRelations, false);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)rootAsset, EntitySearchDirection.FROM, -1, false));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)expectedRelations.size(), (long)relations.size());
        Assert.assertTrue((boolean)relations.containsAll(expectedRelations));
    }

    @Test
    public void testFindByQueryLargeHierarchyFetchLastOnlyWithUnlimLvl() throws Exception {
        AssetId rootAsset = new AssetId(Uuids.timeBased());
        int hierarchyLvl = 10;
        LinkedList<EntityRelation> expectedRelations = new LinkedList<EntityRelation>();
        this.createAssetRelationsRecursively(rootAsset, 10, expectedRelations, true);
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters((EntityId)rootAsset, EntitySearchDirection.FROM, -1, true));
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter("Contains", Collections.singletonList(EntityType.ASSET))));
        List relations = (List)this.relationService.findByQuery(SYSTEM_TENANT_ID, query).get();
        Assert.assertEquals((long)expectedRelations.size(), (long)relations.size());
        Assert.assertTrue((boolean)relations.containsAll(expectedRelations));
    }

    private void createAssetRelationsRecursively(AssetId rootAsset, int lvl, List<EntityRelation> entityRelations, boolean lastLvlOnly) throws Exception {
        if (lvl == 0) {
            return;
        }
        AssetId firstAsset = new AssetId(Uuids.timeBased());
        AssetId secondAsset = new AssetId(Uuids.timeBased());
        EntityRelation firstRelation = new EntityRelation((EntityId)rootAsset, (EntityId)firstAsset, "Contains");
        EntityRelation secondRelation = new EntityRelation((EntityId)rootAsset, (EntityId)secondAsset, "Contains");
        firstRelation = this.saveRelation(firstRelation);
        secondRelation = this.saveRelation(secondRelation);
        if (!lastLvlOnly || lvl == 1) {
            entityRelations.add(firstRelation);
            entityRelations.add(secondRelation);
        }
        this.createAssetRelationsRecursively(firstAsset, lvl - 1, entityRelations, lastLvlOnly);
        this.createAssetRelationsRecursively(secondAsset, lvl - 1, entityRelations, lastLvlOnly);
    }
}

