/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.QueueStatsId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.queue.QueueStats;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.queue.QueueStatsService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class QueueStatsServiceTest
extends AbstractServiceTest {
    @Autowired
    QueueStatsService queueStatsService;
    private TenantId tenantId;

    @Before
    public void before() throws NoSuchFieldException, IllegalAccessException {
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Assert.assertNotNull((Object)savedTenant);
        this.tenantId = savedTenant.getId();
    }

    @After
    public void after() {
        this.tenantService.deleteTenant(this.tenantId);
    }

    @Test
    public void testSaveQueueStats() {
        QueueStats queueStats = new QueueStats();
        queueStats.setTenantId(this.tenantId);
        String queueName = StringUtils.randomAlphabetic((int)8);
        queueStats.setQueueName(queueName);
        queueStats.setServiceId(StringUtils.randomAlphabetic((int)8));
        QueueStats savedQueueStats = this.queueStatsService.save(this.tenantId, queueStats);
        Assert.assertNotNull((Object)savedQueueStats);
        Assert.assertNotNull((Object)savedQueueStats.getId());
        Assert.assertTrue((savedQueueStats.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)queueStats.getTenantId(), (Object)savedQueueStats.getTenantId());
        Assert.assertEquals((Object)savedQueueStats.getQueueName(), (Object)queueStats.getQueueName());
        QueueStats retrievedQueueStatsById = this.queueStatsService.findQueueStatsById(this.tenantId, (QueueStatsId)savedQueueStats.getId());
        Assert.assertEquals((Object)retrievedQueueStatsById.getQueueName(), (Object)queueName);
        String secondQueueName = StringUtils.randomAlphabetic((int)8);
        queueStats.setQueueName(secondQueueName);
        QueueStats savedQueueStats2 = this.queueStatsService.save(this.tenantId, queueStats);
        QueueStats retrievedQueueStatsById2 = this.queueStatsService.findQueueStatsById(this.tenantId, (QueueStatsId)savedQueueStats2.getId());
        Assert.assertEquals((Object)retrievedQueueStatsById2.getQueueName(), (Object)secondQueueName);
        PageData queueStatsList = this.queueStatsService.findByTenantId(this.tenantId, new PageLink(10));
        Assert.assertEquals((long)2L, (long)queueStatsList.getData().size());
        Assertions.assertThat((List)queueStatsList.getData()).containsOnly((Object[])new QueueStats[]{retrievedQueueStatsById, retrievedQueueStatsById2});
        this.queueStatsService.deleteByTenantId(this.tenantId);
        QueueStats retrievedQueueStatsAfterDelete = this.queueStatsService.findQueueStatsById(this.tenantId, (QueueStatsId)savedQueueStats.getId());
        Assert.assertNull((Object)retrievedQueueStatsAfterDelete);
    }

    @Test
    public void testSaveWithNullQueueName() {
        QueueStats queueStats = new QueueStats();
        queueStats.setTenantId(this.tenantId);
        queueStats.setQueueName(null);
        queueStats.setServiceId(StringUtils.randomAlphabetic((int)8));
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.queueStatsService.save(this.tenantId, queueStats));
    }

    @Test
    public void testSaveWithNullServiceId() {
        QueueStats queueStats = new QueueStats();
        queueStats.setTenantId(this.tenantId);
        queueStats.setQueueName(StringUtils.randomAlphabetic((int)8));
        queueStats.setServiceId(null);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.queueStatsService.save(this.tenantId, queueStats));
    }

    @Test
    public void testFindByTenantIdAndNameAndServiceId() {
        QueueStats queueStats = new QueueStats();
        queueStats.setTenantId(this.tenantId);
        queueStats.setQueueName(StringUtils.randomAlphabetic((int)8));
        queueStats.setServiceId(StringUtils.randomAlphabetic((int)8));
        QueueStats savedQueueStats = this.queueStatsService.save(this.tenantId, queueStats);
        QueueStats queueStats2 = new QueueStats();
        queueStats2.setTenantId(this.tenantId);
        queueStats2.setQueueName(StringUtils.randomAlphabetic((int)8));
        queueStats2.setServiceId(StringUtils.randomAlphabetic((int)8));
        this.queueStatsService.save(this.tenantId, queueStats2);
        QueueStats retrievedQueueStatsById = this.queueStatsService.findByTenantIdAndNameAndServiceId(this.tenantId, queueStats.getQueueName(), queueStats.getServiceId());
        Assertions.assertThat((Object)retrievedQueueStatsById).isEqualTo((Object)savedQueueStats);
    }
}

