/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.queue.ProcessingStrategy;
import org.thingsboard.server.common.data.queue.ProcessingStrategyType;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.queue.SubmitStrategy;
import org.thingsboard.server.common.data.queue.SubmitStrategyType;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.tenant.TenantProfileService;

@DaoSqlTest
public class QueueServiceTest
extends AbstractServiceTest {
    @Autowired
    TenantProfileService tenantProfileService;
    @Autowired
    QueueService queueService;
    private AbstractServiceTest.IdComparator<Queue> idComparator = new AbstractServiceTest.IdComparator();
    private TenantId tenantId;
    private TenantProfileId tenantProfileId;

    @Before
    public void before() throws NoSuchFieldException, IllegalAccessException {
        TenantProfile tenantProfile = new TenantProfile();
        tenantProfile.setDefault(false);
        tenantProfile.setName("Isolated TB Rule Engine");
        tenantProfile.setDescription("Isolated TB Rule Engine tenant profile");
        tenantProfile.setIsolatedTbRuleEngine(true);
        TenantProfileQueueConfiguration mainQueueConfiguration = new TenantProfileQueueConfiguration();
        mainQueueConfiguration.setName("Main");
        mainQueueConfiguration.setTopic("tb_rule_engine.main");
        mainQueueConfiguration.setPollInterval(25);
        mainQueueConfiguration.setPartitions(10);
        mainQueueConfiguration.setConsumerPerPartition(true);
        mainQueueConfiguration.setPackProcessingTimeout(2000L);
        SubmitStrategy mainQueueSubmitStrategy = new SubmitStrategy();
        mainQueueSubmitStrategy.setType(SubmitStrategyType.BURST);
        mainQueueSubmitStrategy.setBatchSize(1000);
        mainQueueConfiguration.setSubmitStrategy(mainQueueSubmitStrategy);
        ProcessingStrategy mainQueueProcessingStrategy = new ProcessingStrategy();
        mainQueueProcessingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
        mainQueueProcessingStrategy.setRetries(3);
        mainQueueProcessingStrategy.setFailurePercentage(0.0);
        mainQueueProcessingStrategy.setPauseBetweenRetries(3L);
        mainQueueProcessingStrategy.setMaxPauseBetweenRetries(3L);
        mainQueueConfiguration.setProcessingStrategy(mainQueueProcessingStrategy);
        TenantProfileData profileData = tenantProfile.getProfileData();
        profileData.setQueueConfiguration(Collections.singletonList(mainQueueConfiguration));
        tenantProfile.setProfileData(profileData);
        TenantProfile savedTenantProfile = this.tenantProfileService.saveTenantProfile(TenantId.SYS_TENANT_ID, tenantProfile);
        Assert.assertNotNull((Object)savedTenantProfile);
        this.tenantProfileId = savedTenantProfile.getId();
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant");
        tenant.setTenantProfileId(this.tenantProfileId);
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Assert.assertNotNull((Object)savedTenant);
        this.tenantId = savedTenant.getId();
    }

    @After
    public void after() {
        this.tenantService.deleteTenant(this.tenantId);
        this.tenantProfileService.deleteTenantProfile(TenantId.SYS_TENANT_ID, this.tenantProfileId);
    }

    private ProcessingStrategy createTestProcessingStrategy() {
        ProcessingStrategy processingStrategy = new ProcessingStrategy();
        processingStrategy.setType(ProcessingStrategyType.SKIP_ALL_FAILURES);
        processingStrategy.setRetries(3);
        processingStrategy.setFailurePercentage(0.0);
        processingStrategy.setPauseBetweenRetries(3L);
        processingStrategy.setMaxPauseBetweenRetries(3L);
        return processingStrategy;
    }

    private SubmitStrategy createTestSubmitStrategy() {
        SubmitStrategy submitStrategy = new SubmitStrategy();
        submitStrategy.setType(SubmitStrategyType.BURST);
        submitStrategy.setBatchSize(1000);
        return submitStrategy;
    }

    @Test
    public void testSaveQueue() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Queue savedQueue = this.queueService.saveQueue(queue);
        Assert.assertNotNull((Object)savedQueue);
        Assert.assertNotNull((Object)savedQueue.getId());
        Assert.assertTrue((savedQueue.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)queue.getTenantId(), (Object)savedQueue.getTenantId());
        Assert.assertEquals((Object)queue.getName(), (Object)queue.getName());
        savedQueue.setPollInterval(100);
        this.queueService.saveQueue(savedQueue);
        Queue foundQueue = this.queueService.findQueueById(this.tenantId, (QueueId)savedQueue.getId());
        Assert.assertEquals((long)foundQueue.getPollInterval(), (long)savedQueue.getPollInterval());
        this.queueService.deleteQueue(this.tenantId, (QueueId)foundQueue.getId());
    }

    @Test
    public void testSaveQueueWithEmptyName() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithInvalidName() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test 1");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptyTopic() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithInvalidTopic() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb rule engine test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptyPollInterval() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptyPartitions() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptyPackProcessingTimeout() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptySubmitStrategy() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptyProcessingStrategy() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptySubmitStrategyType() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.getSubmitStrategy().setType(null);
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptySubmitStrategyBatchSize() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.getSubmitStrategy().setType(SubmitStrategyType.BATCH);
        queue.getSubmitStrategy().setBatchSize(0);
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithEmptyProcessingStrategyType() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        queue.getProcessingStrategy().setType(null);
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithNegativeProcessingStrategyRetries() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        queue.getProcessingStrategy().setRetries(-1);
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithNegativeProcessingStrategyFailurePercentage() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        queue.getProcessingStrategy().setFailurePercentage(-1.0);
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithNegativeProcessingStrategyPauseBetweenRetries() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        queue.getProcessingStrategy().setPauseBetweenRetries(-1L);
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    @Test
    public void testSaveQueueWithProcessingStrategyPauseBetweenRetriesBiggerThenMaxPauseBetweenRetries() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        queue.getProcessingStrategy().setPauseBetweenRetries(100L);
        Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveQueueWithNotIsolatedTenant() {
        Tenant tenant = new Tenant();
        tenant.setTitle("Not isolated tenant");
        Tenant savedTenant = this.tenantService.saveTenant(tenant);
        Assert.assertNotNull((Object)savedTenant);
        Queue queue = new Queue();
        queue.setTenantId(savedTenant.getId());
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.queueService.saveQueue(queue));
        }
        finally {
            this.tenantService.deleteTenant(savedTenant.getId());
        }
    }

    @Test
    public void testUpdateQueue() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Queue savedQueue = this.queueService.saveQueue(queue);
        Assert.assertNotNull((Object)savedQueue);
        queue.setPollInterval(1000);
        this.queueService.saveQueue(savedQueue);
        Queue foundQueue = this.queueService.findQueueById(this.tenantId, (QueueId)savedQueue.getId());
        Assert.assertEquals((Object)savedQueue, (Object)foundQueue);
    }

    @Test
    public void testFindQueueById() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Queue savedQueue = this.queueService.saveQueue(queue);
        Queue foundQueue = this.queueService.findQueueById(this.tenantId, (QueueId)savedQueue.getId());
        Assert.assertNotNull((Object)foundQueue);
        Assert.assertEquals((Object)savedQueue, (Object)foundQueue);
    }

    @Test
    public void testDeleteQueue() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Queue savedQueue = this.queueService.saveQueue(queue);
        Queue foundQueue = this.queueService.findQueueById(this.tenantId, (QueueId)savedQueue.getId());
        Assert.assertNotNull((Object)foundQueue);
        this.queueService.deleteQueue(this.tenantId, (QueueId)savedQueue.getId());
        foundQueue = this.queueService.findQueueById(this.tenantId, (QueueId)savedQueue.getId());
        Assert.assertNull((Object)foundQueue);
    }

    @Test
    public void testFindQueueByTenantIdAndName() {
        Queue queue = new Queue();
        queue.setTenantId(this.tenantId);
        queue.setName("Test");
        queue.setTopic("tb_rule_engine.test");
        queue.setPollInterval(25);
        queue.setPartitions(1);
        queue.setPackProcessingTimeout(2000L);
        queue.setSubmitStrategy(this.createTestSubmitStrategy());
        queue.setProcessingStrategy(this.createTestProcessingStrategy());
        Queue savedQueue = this.queueService.saveQueue(queue);
        Queue foundQueue = this.queueService.findQueueByTenantIdAndName(this.tenantId, savedQueue.getName());
        Assert.assertNotNull((Object)foundQueue);
        Assert.assertEquals((Object)savedQueue, (Object)foundQueue);
    }

    @Test
    public void testFindQueuesByTenantId() {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        for (int i = 1; i < 10; ++i) {
            Queue queue = new Queue();
            queue.setTenantId(this.tenantId);
            queue.setName("Test" + i);
            queue.setTopic("tb_rule_engine.test" + i);
            queue.setPollInterval(25);
            queue.setPartitions(1);
            queue.setPackProcessingTimeout(2000L);
            queue.setSubmitStrategy(this.createTestSubmitStrategy());
            queue.setProcessingStrategy(this.createTestProcessingStrategy());
            queues.add(this.queueService.saveQueue(queue));
        }
        ArrayList loadedQueues = new ArrayList();
        PageLink pageLink = new PageLink(3);
        PageData pageData = null;
        do {
            pageData = this.queueService.findQueuesByTenantId(this.tenantId, pageLink);
            loadedQueues.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        for (int i = 0; i < loadedQueues.size(); ++i) {
            Queue queue = (Queue)loadedQueues.get(i);
            if (!queue.getName().equals("Main")) continue;
            loadedQueues.remove(queue);
            break;
        }
        Collections.sort(queues, this.idComparator);
        Collections.sort(loadedQueues, this.idComparator);
        Assert.assertEquals(queues, loadedQueues);
        this.queueService.deleteQueuesByTenantId(this.tenantId);
        pageLink = new PageLink(33);
        pageData = this.queueService.findQueuesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }
}

