/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.tenant.TenantProfileService;

@DaoSqlTest
public class OtaPackageServiceTest
extends AbstractServiceTest {
    public static final String TITLE = "My firmware";
    public static final String TARGET_FW_VERSION = "fw.v.1.5.0-update";
    private static final String FILE_NAME = "filename.txt";
    private static final String VERSION = "v1.0";
    private static final String CONTENT_TYPE = "text/plain";
    private static final ChecksumAlgorithm CHECKSUM_ALGORITHM = ChecksumAlgorithm.SHA256;
    private static final String CHECKSUM = "4bf5122f344554c53bde2ebb8cd2b7e3d1600ad631c385a5d7cce23c7785459a";
    private static final long DATA_SIZE = 1L;
    private static final ByteBuffer DATA = ByteBuffer.wrap(new byte[]{1});
    private static final String URL = "http://firmware.test.org";
    private final AbstractServiceTest.IdComparator<OtaPackageInfo> idComparator = new AbstractServiceTest.IdComparator();
    private DeviceProfileId deviceProfileId;
    @Autowired
    DeviceProfileService deviceProfileService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    OtaPackageService otaPackageService;
    @Autowired
    TenantProfileService tenantProfileService;

    @Before
    public void before() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        Assert.assertNotNull((Object)savedDeviceProfile);
        this.deviceProfileId = savedDeviceProfile.getId();
    }

    @After
    public void after() {
        this.tenantService.deleteTenant(this.tenantId);
        this.tenantProfileService.deleteTenantProfiles(this.tenantId);
    }

    @Test
    public void testSaveOtaPackageWithMaxSumDataSizeOutOfLimit() {
        TenantProfile defaultTenantProfile = this.tenantProfileService.findDefaultTenantProfile(this.tenantId);
        defaultTenantProfile.getProfileData().setConfiguration((TenantProfileConfiguration)DefaultTenantProfileConfiguration.builder().maxOtaPackagesInBytes(1L).build());
        this.tenantProfileService.saveTenantProfile(this.tenantId, defaultTenantProfile);
        Assert.assertEquals((long)0L, (long)this.otaPackageService.sumDataSizeByTenantId(this.tenantId));
        this.createAndSaveFirmware(this.tenantId, "1");
        Assert.assertEquals((long)1L, (long)this.otaPackageService.sumDataSizeByTenantId(this.tenantId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createAndSaveFirmware(this.tenantId, "2")).isInstanceOf(DataValidationException.class)).hasMessageContaining("Ota packages total size exceeds the maximum of %d bytes", new Object[]{1L});
    }

    @Test
    public void sumDataSizeByTenantId() {
        Assert.assertEquals((long)0L, (long)this.otaPackageService.sumDataSizeByTenantId(this.tenantId));
        this.createAndSaveFirmware(this.tenantId, "0.1");
        Assert.assertEquals((long)1L, (long)this.otaPackageService.sumDataSizeByTenantId(this.tenantId));
        int maxSumDataSize = 8;
        ArrayList<OtaPackage> packages = new ArrayList<OtaPackage>(maxSumDataSize);
        for (int i = 2; i <= maxSumDataSize; ++i) {
            packages.add(this.createAndSaveFirmware(this.tenantId, "0." + i));
            Assert.assertEquals((long)i, (long)this.otaPackageService.sumDataSizeByTenantId(this.tenantId));
        }
        Assert.assertEquals((long)maxSumDataSize, (long)this.otaPackageService.sumDataSizeByTenantId(this.tenantId));
    }

    @Test
    public void testSaveFirmware() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        firmware.setDataSize(Long.valueOf(1L));
        OtaPackage savedFirmware = this.otaPackageService.saveOtaPackage(firmware);
        Assert.assertNotNull((Object)savedFirmware);
        Assert.assertNotNull((Object)savedFirmware.getId());
        Assert.assertTrue((savedFirmware.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)firmware.getTenantId(), (Object)savedFirmware.getTenantId());
        Assert.assertEquals((Object)firmware.getTitle(), (Object)savedFirmware.getTitle());
        Assert.assertEquals((Object)firmware.getFileName(), (Object)savedFirmware.getFileName());
        Assert.assertEquals((Object)firmware.getContentType(), (Object)savedFirmware.getContentType());
        Assert.assertEquals((Object)firmware.getData(), (Object)savedFirmware.getData());
        savedFirmware.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode());
        this.otaPackageService.saveOtaPackage(savedFirmware);
        OtaPackage foundFirmware = this.otaPackageService.findOtaPackageById(this.tenantId, savedFirmware.getId());
        Assert.assertEquals((Object)foundFirmware.getTitle(), (Object)savedFirmware.getTitle());
        this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
    }

    @Test
    public void testSaveFirmwareWithUrl() {
        OtaPackageInfo firmware = new OtaPackageInfo();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setUrl(URL);
        firmware.setDataSize(Long.valueOf(0L));
        OtaPackageInfo savedFirmware = this.otaPackageService.saveOtaPackageInfo(firmware, true);
        Assert.assertNotNull((Object)savedFirmware);
        Assert.assertNotNull((Object)savedFirmware.getId());
        Assert.assertTrue((savedFirmware.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)firmware.getTenantId(), (Object)savedFirmware.getTenantId());
        Assert.assertEquals((Object)firmware.getTitle(), (Object)savedFirmware.getTitle());
        Assert.assertEquals((Object)firmware.getFileName(), (Object)savedFirmware.getFileName());
        Assert.assertEquals((Object)firmware.getContentType(), (Object)savedFirmware.getContentType());
        savedFirmware.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode());
        this.otaPackageService.saveOtaPackageInfo(savedFirmware, true);
        OtaPackage foundFirmware = this.otaPackageService.findOtaPackageById(this.tenantId, savedFirmware.getId());
        Assert.assertEquals((Object)foundFirmware.getTitle(), (Object)savedFirmware.getTitle());
        this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
    }

    @Test
    public void testSaveFirmwareInfoAndUpdateWithData() {
        OtaPackageInfo firmwareInfo = new OtaPackageInfo();
        firmwareInfo.setTenantId(this.tenantId);
        firmwareInfo.setDeviceProfileId(this.deviceProfileId);
        firmwareInfo.setType(OtaPackageType.FIRMWARE);
        firmwareInfo.setTitle(TITLE);
        firmwareInfo.setVersion(VERSION);
        OtaPackageInfo savedFirmwareInfo = this.otaPackageService.saveOtaPackageInfo(firmwareInfo, false);
        Assert.assertNotNull((Object)savedFirmwareInfo);
        Assert.assertNotNull((Object)savedFirmwareInfo.getId());
        Assert.assertTrue((savedFirmwareInfo.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)firmwareInfo.getTenantId(), (Object)savedFirmwareInfo.getTenantId());
        Assert.assertEquals((Object)firmwareInfo.getTitle(), (Object)savedFirmwareInfo.getTitle());
        OtaPackage firmware = new OtaPackage(savedFirmwareInfo.getId());
        firmware.setCreatedTime(firmwareInfo.getCreatedTime());
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        firmware.setDataSize(Long.valueOf(1L));
        this.otaPackageService.saveOtaPackage(firmware);
        savedFirmwareInfo = this.otaPackageService.findOtaPackageInfoById(this.tenantId, savedFirmwareInfo.getId());
        savedFirmwareInfo.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode());
        this.otaPackageService.saveOtaPackageInfo(savedFirmwareInfo, false);
        OtaPackage foundFirmware = this.otaPackageService.findOtaPackageById(this.tenantId, firmware.getId());
        firmware.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode());
        Assert.assertEquals((Object)foundFirmware.getTitle(), (Object)firmware.getTitle());
        Assert.assertTrue((boolean)foundFirmware.isHasData());
        this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmwareInfo.getId());
    }

    @Test
    public void testSaveFirmwareWithEmptyTenant() {
        OtaPackage firmware = new OtaPackage();
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage should be assigned to tenant!");
    }

    @Test
    public void testSaveFirmwareWithEmptyType() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("Type should be specified!");
    }

    @Test
    public void testSaveFirmwareWithEmptyTitle() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage title should be specified!");
    }

    @Test
    public void testSaveFirmwareWithEmptyFileName() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage file name should be specified!");
    }

    @Test
    public void testSaveFirmwareWithEmptyContentType() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage content type should be specified!");
    }

    @Test
    public void testSaveFirmwareWithEmptyData() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage data should be specified!");
    }

    @Test
    public void testSaveFirmwareWithInvalidTenant() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage is referencing to non-existent tenant!");
    }

    @Test
    public void testSaveFirmwareWithInvalidDeviceProfileId() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(new DeviceProfileId(Uuids.timeBased()));
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage is referencing to non-existent device profile!");
    }

    @Test
    public void testSaveFirmwareWithEmptyChecksum() {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setData(DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(firmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage checksum should be specified!");
    }

    @Test
    public void testSaveFirmwareInfoWithExistingTitleAndVersion() {
        OtaPackageInfo firmwareInfo = new OtaPackageInfo();
        firmwareInfo.setTenantId(this.tenantId);
        firmwareInfo.setDeviceProfileId(this.deviceProfileId);
        firmwareInfo.setType(OtaPackageType.FIRMWARE);
        firmwareInfo.setTitle(TITLE);
        firmwareInfo.setVersion(VERSION);
        this.otaPackageService.saveOtaPackageInfo(firmwareInfo, false);
        OtaPackageInfo newFirmwareInfo = new OtaPackageInfo();
        newFirmwareInfo.setTenantId(this.tenantId);
        newFirmwareInfo.setDeviceProfileId(this.deviceProfileId);
        newFirmwareInfo.setType(OtaPackageType.FIRMWARE);
        newFirmwareInfo.setTitle(TITLE);
        newFirmwareInfo.setVersion(VERSION);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackageInfo(newFirmwareInfo, false)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage with such title and version already exists!");
    }

    @Test
    public void testSaveFirmwareWithExistingTitleAndVersion() {
        this.createAndSaveFirmware(this.tenantId, VERSION);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createAndSaveFirmware(this.tenantId, VERSION)).isInstanceOf(DataValidationException.class)).hasMessageContaining("OtaPackage with such title and version already exists!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFirmwareWithReferenceByDevice() {
        OtaPackage savedFirmware = this.createAndSaveFirmware(this.tenantId, VERSION);
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("My device");
        device.setDeviceProfileId(this.deviceProfileId);
        device.setFirmwareId(savedFirmware.getId());
        Device savedDevice = this.deviceService.saveDevice(device);
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId())).isInstanceOf(DataValidationException.class)).hasMessageContaining("The otaPackage referenced by the devices cannot be deleted!");
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, savedDevice.getId());
            this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
        }
    }

    @Test
    public void testUpdateDeviceProfileId() {
        OtaPackage savedFirmware = this.createAndSaveFirmware(this.tenantId, VERSION);
        savedFirmware.setDeviceProfileId(null);
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackage(savedFirmware)).isInstanceOf(DataValidationException.class)).hasMessageContaining("Updating otaPackage deviceProfile is prohibited!");
        }
        finally {
            this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFirmwareWithReferenceByDeviceProfile() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Test Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(savedDeviceProfile.getId());
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        firmware.setDataSize(Long.valueOf(1L));
        OtaPackage savedFirmware = this.otaPackageService.saveOtaPackage(firmware);
        savedDeviceProfile.setFirmwareId(savedFirmware.getId());
        this.deviceProfileService.saveDeviceProfile(savedDeviceProfile);
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId())).isInstanceOf(DataValidationException.class)).hasMessageContaining("The otaPackage referenced by the device profile cannot be deleted!");
        }
        finally {
            this.deviceProfileService.deleteDeviceProfile(this.tenantId, savedDeviceProfile.getId());
        }
    }

    @Test
    public void testFindFirmwareById() {
        OtaPackage savedFirmware = this.createAndSaveFirmware(this.tenantId, VERSION);
        OtaPackage foundFirmware = this.otaPackageService.findOtaPackageById(this.tenantId, savedFirmware.getId());
        Assert.assertNotNull((Object)foundFirmware);
        Assert.assertEquals((Object)savedFirmware, (Object)foundFirmware);
        this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
    }

    @Test
    public void testFindFirmwareInfoById() {
        OtaPackageInfo firmware = new OtaPackageInfo();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(this.deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(VERSION);
        OtaPackageInfo savedFirmware = this.otaPackageService.saveOtaPackageInfo(firmware, false);
        OtaPackageInfo foundFirmware = this.otaPackageService.findOtaPackageInfoById(this.tenantId, savedFirmware.getId());
        Assert.assertNotNull((Object)foundFirmware);
        Assert.assertEquals((Object)savedFirmware, (Object)foundFirmware);
        this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
    }

    @Test
    public void testDeleteFirmware() {
        OtaPackage savedFirmware = this.createAndSaveFirmware(this.tenantId, VERSION);
        OtaPackage foundFirmware = this.otaPackageService.findOtaPackageById(this.tenantId, savedFirmware.getId());
        Assert.assertNotNull((Object)foundFirmware);
        this.otaPackageService.deleteOtaPackage(this.tenantId, savedFirmware.getId());
        foundFirmware = this.otaPackageService.findOtaPackageById(this.tenantId, savedFirmware.getId());
        Assert.assertNull((Object)foundFirmware);
    }

    @Test
    public void testFindTenantFirmwaresByTenantId() {
        PageData pageData;
        ArrayList<OtaPackageInfo> firmwares = new ArrayList<OtaPackageInfo>();
        for (int i = 0; i < 165; ++i) {
            OtaPackageInfo info = new OtaPackageInfo((OtaPackageInfo)this.createAndSaveFirmware(this.tenantId, VERSION + i));
            info.setHasData(true);
            firmwares.add(info);
        }
        OtaPackageInfo firmwareWithUrl = new OtaPackageInfo();
        firmwareWithUrl.setTenantId(this.tenantId);
        firmwareWithUrl.setDeviceProfileId(this.deviceProfileId);
        firmwareWithUrl.setType(OtaPackageType.FIRMWARE);
        firmwareWithUrl.setTitle(TITLE);
        firmwareWithUrl.setVersion(VERSION);
        firmwareWithUrl.setUrl(URL);
        firmwareWithUrl.setDataSize(Long.valueOf(0L));
        OtaPackageInfo savedFwWithUrl = this.otaPackageService.saveOtaPackageInfo(firmwareWithUrl, true);
        savedFwWithUrl.setHasData(true);
        firmwares.add(savedFwWithUrl);
        ArrayList loadedFirmwares = new ArrayList();
        PageLink pageLink = new PageLink(16);
        do {
            pageData = this.otaPackageService.findTenantOtaPackagesByTenantId(this.tenantId, pageLink);
            loadedFirmwares.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(firmwares, this.idComparator);
        Collections.sort(loadedFirmwares, this.idComparator);
        Assertions.assertThat(firmwares).isEqualTo(loadedFirmwares);
        this.otaPackageService.deleteOtaPackagesByTenantId(this.tenantId);
        pageLink = new PageLink(31);
        pageData = this.otaPackageService.findTenantOtaPackagesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindTenantFirmwaresByTenantIdAndHasData() {
        PageData pageData;
        ArrayList<OtaPackageInfo> firmwares = new ArrayList<OtaPackageInfo>();
        for (int i = 0; i < 165; ++i) {
            firmwares.add(new OtaPackageInfo((OtaPackageInfo)this.otaPackageService.saveOtaPackage(this.createAndSaveFirmware(this.tenantId, VERSION + i))));
        }
        OtaPackageInfo firmwareWithUrl = new OtaPackageInfo();
        firmwareWithUrl.setTenantId(this.tenantId);
        firmwareWithUrl.setDeviceProfileId(this.deviceProfileId);
        firmwareWithUrl.setType(OtaPackageType.FIRMWARE);
        firmwareWithUrl.setTitle(TITLE);
        firmwareWithUrl.setVersion(VERSION);
        firmwareWithUrl.setUrl(URL);
        firmwareWithUrl.setDataSize(Long.valueOf(0L));
        OtaPackageInfo savedFwWithUrl = this.otaPackageService.saveOtaPackageInfo(firmwareWithUrl, true);
        savedFwWithUrl.setHasData(true);
        firmwares.add(savedFwWithUrl);
        ArrayList loadedFirmwares = new ArrayList();
        PageLink pageLink = new PageLink(16);
        do {
            pageData = this.otaPackageService.findTenantOtaPackagesByTenantIdAndDeviceProfileIdAndTypeAndHasData(this.tenantId, this.deviceProfileId, OtaPackageType.FIRMWARE, pageLink);
            loadedFirmwares.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        loadedFirmwares = new ArrayList();
        pageLink = new PageLink(16);
        do {
            pageData = this.otaPackageService.findTenantOtaPackagesByTenantIdAndDeviceProfileIdAndTypeAndHasData(this.tenantId, this.deviceProfileId, OtaPackageType.FIRMWARE, pageLink);
            loadedFirmwares.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(firmwares, this.idComparator);
        Collections.sort(loadedFirmwares, this.idComparator);
        Assertions.assertThat(firmwares).isEqualTo(loadedFirmwares);
        this.otaPackageService.deleteOtaPackagesByTenantId(this.tenantId);
        pageLink = new PageLink(31);
        pageData = this.otaPackageService.findTenantOtaPackagesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testSaveOtaPackageInfoWithBlankAndEmptyUrl() {
        OtaPackageInfo firmwareInfo = new OtaPackageInfo();
        firmwareInfo.setDeviceProfileId(this.deviceProfileId);
        firmwareInfo.setType(OtaPackageType.FIRMWARE);
        firmwareInfo.setTitle(TITLE);
        firmwareInfo.setVersion(VERSION);
        firmwareInfo.setUrl("   ");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackageInfo(firmwareInfo, true)).as("firmwareInfo url set whitespaces", new Object[0])).isInstanceOf(DataValidationException.class)).hasMessageContaining("Ota package URL should be specified!");
        firmwareInfo.setUrl("");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackageInfo(firmwareInfo, true)).as("firmwareInfo url is empty", new Object[0])).isInstanceOf(DataValidationException.class)).hasMessageContaining("Ota package URL should be specified!");
    }

    @Test
    public void testSaveOtaPackageUrlCantBeUpdated() {
        OtaPackageInfo firmwareInfo = new OtaPackageInfo();
        firmwareInfo.setDeviceProfileId(this.deviceProfileId);
        firmwareInfo.setType(OtaPackageType.FIRMWARE);
        firmwareInfo.setTitle(TITLE);
        firmwareInfo.setVersion(VERSION);
        firmwareInfo.setUrl(URL);
        firmwareInfo.setTenantId(this.tenantId);
        OtaPackageInfo savedFirmwareInfo = this.otaPackageService.saveOtaPackageInfo(firmwareInfo, true);
        savedFirmwareInfo.setUrl("https://newurl.com");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackageInfo(savedFirmwareInfo, true)).isInstanceOf(DataValidationException.class)).hasMessageContaining("Updating otaPackage URL is prohibited!");
    }

    @Test
    public void testSaveOtaPackageCantViolateSizeOfTitle() {
        OtaPackageInfo firmwareInfo = new OtaPackageInfo();
        firmwareInfo.setDeviceProfileId(this.deviceProfileId);
        firmwareInfo.setType(OtaPackageType.FIRMWARE);
        firmwareInfo.setTitle(StringUtils.random((int)257));
        firmwareInfo.setVersion(VERSION);
        firmwareInfo.setUrl(URL);
        firmwareInfo.setTenantId(this.tenantId);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackageInfo(firmwareInfo, true)).isInstanceOf(DataValidationException.class)).hasMessageContaining("title length must be equal or less than 255");
    }

    @Test
    public void testSaveOtaPackageCantViolateSizeOfVersion() {
        OtaPackageInfo firmwareInfo = new OtaPackageInfo();
        firmwareInfo.setDeviceProfileId(this.deviceProfileId);
        firmwareInfo.setType(OtaPackageType.FIRMWARE);
        firmwareInfo.setUrl(URL);
        firmwareInfo.setTenantId(this.tenantId);
        firmwareInfo.setTitle(TITLE);
        firmwareInfo.setVersion(StringUtils.random((int)257));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.otaPackageService.saveOtaPackageInfo(firmwareInfo, true)).isInstanceOf(DataValidationException.class)).hasMessageContaining("version length must be equal or less than 255");
    }

    private OtaPackage createAndSaveFirmware(TenantId tenantId, String version) {
        return this.otaPackageService.saveOtaPackage(OtaPackageServiceTest.createFirmware(tenantId, version, this.deviceProfileId));
    }

    public static OtaPackage createFirmware(TenantId tenantId, String version, DeviceProfileId deviceProfileId) {
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(tenantId);
        firmware.setDeviceProfileId(deviceProfileId);
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle(TITLE);
        firmware.setVersion(version);
        firmware.setFileName(FILE_NAME);
        firmware.setContentType(CONTENT_TYPE);
        firmware.setChecksumAlgorithm(CHECKSUM_ALGORITHM);
        firmware.setChecksum(CHECKSUM);
        firmware.setData(DATA);
        firmware.setDataSize(Long.valueOf(1L));
        return firmware;
    }
}

