/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.OAuth2ClientRegistrationTemplateId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.oauth2.MapperType;
import org.thingsboard.server.common.data.oauth2.OAuth2BasicMapperConfig;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientRegistrationTemplate;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.oauth2.OAuth2ConfigTemplateService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class OAuth2ConfigTemplateServiceTest
extends AbstractServiceTest {
    @Autowired
    protected OAuth2ConfigTemplateService oAuth2ConfigTemplateService;

    @Before
    public void beforeRun() throws Exception {
        Assert.assertTrue((boolean)this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates().isEmpty());
    }

    @After
    public void after() throws Exception {
        this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates().forEach(clientRegistrationTemplate -> this.oAuth2ConfigTemplateService.deleteClientRegistrationTemplateById((OAuth2ClientRegistrationTemplateId)clientRegistrationTemplate.getId()));
        Assert.assertTrue((boolean)this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates().isEmpty());
    }

    @Test
    public void testSaveDuplicateProviderId() {
        OAuth2ClientRegistrationTemplate first = this.validClientRegistrationTemplate("providerId");
        OAuth2ClientRegistrationTemplate second = this.validClientRegistrationTemplate("providerId");
        this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(first);
        Assertions.assertThrows(DataValidationException.class, () -> this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(second));
    }

    @Test
    public void testCreateNewTemplate() {
        OAuth2ClientRegistrationTemplate clientRegistrationTemplate = this.validClientRegistrationTemplate(UUID.randomUUID().toString());
        OAuth2ClientRegistrationTemplate savedClientRegistrationTemplate = this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(clientRegistrationTemplate);
        Assert.assertNotNull((Object)savedClientRegistrationTemplate);
        Assert.assertNotNull((Object)savedClientRegistrationTemplate.getId());
        clientRegistrationTemplate.setId((UUIDBased)((OAuth2ClientRegistrationTemplateId)savedClientRegistrationTemplate.getId()));
        clientRegistrationTemplate.setCreatedTime(savedClientRegistrationTemplate.getCreatedTime());
        Assert.assertEquals((Object)clientRegistrationTemplate, (Object)savedClientRegistrationTemplate);
    }

    @Test
    public void testFindTemplate() {
        OAuth2ClientRegistrationTemplate clientRegistrationTemplate = this.validClientRegistrationTemplate(UUID.randomUUID().toString());
        OAuth2ClientRegistrationTemplate savedClientRegistrationTemplate = this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(clientRegistrationTemplate);
        OAuth2ClientRegistrationTemplate foundClientRegistrationTemplate = this.oAuth2ConfigTemplateService.findClientRegistrationTemplateById((OAuth2ClientRegistrationTemplateId)savedClientRegistrationTemplate.getId());
        Assert.assertEquals((Object)savedClientRegistrationTemplate, (Object)foundClientRegistrationTemplate);
    }

    @Test
    public void testFindAll() {
        this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(this.validClientRegistrationTemplate(UUID.randomUUID().toString()));
        this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(this.validClientRegistrationTemplate(UUID.randomUUID().toString()));
        Assert.assertEquals((long)2L, (long)this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates().size());
    }

    @Test
    public void testDeleteTemplate() {
        this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(this.validClientRegistrationTemplate(UUID.randomUUID().toString()));
        this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(this.validClientRegistrationTemplate(UUID.randomUUID().toString()));
        OAuth2ClientRegistrationTemplate saved = this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(this.validClientRegistrationTemplate(UUID.randomUUID().toString()));
        Assert.assertEquals((long)3L, (long)this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates().size());
        Assert.assertNotNull((Object)this.oAuth2ConfigTemplateService.findClientRegistrationTemplateById((OAuth2ClientRegistrationTemplateId)saved.getId()));
        this.oAuth2ConfigTemplateService.deleteClientRegistrationTemplateById((OAuth2ClientRegistrationTemplateId)saved.getId());
        Assert.assertEquals((long)2L, (long)this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates().size());
        Assert.assertNull((Object)this.oAuth2ConfigTemplateService.findClientRegistrationTemplateById((OAuth2ClientRegistrationTemplateId)saved.getId()));
    }

    private OAuth2ClientRegistrationTemplate validClientRegistrationTemplate(String providerId) {
        OAuth2ClientRegistrationTemplate clientRegistrationTemplate = new OAuth2ClientRegistrationTemplate();
        clientRegistrationTemplate.setProviderId(providerId);
        clientRegistrationTemplate.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode().put(UUID.randomUUID().toString(), UUID.randomUUID().toString()));
        clientRegistrationTemplate.setMapperConfig(OAuth2MapperConfig.builder().type(MapperType.BASIC).basic(OAuth2BasicMapperConfig.builder().firstNameAttributeKey("firstName").lastNameAttributeKey("lastName").emailAttributeKey("email").tenantNamePattern("tenant").defaultDashboardName("Test").alwaysFullScreen(true).build()).build());
        clientRegistrationTemplate.setAuthorizationUri("authorizationUri");
        clientRegistrationTemplate.setAccessTokenUri("tokenUri");
        clientRegistrationTemplate.setScope(Arrays.asList("scope1", "scope2"));
        clientRegistrationTemplate.setUserInfoUri("userInfoUri");
        clientRegistrationTemplate.setUserNameAttributeName("userNameAttributeName");
        clientRegistrationTemplate.setJwkSetUri("jwkSetUri");
        clientRegistrationTemplate.setClientAuthenticationMethod("clientAuthenticationMethod");
        clientRegistrationTemplate.setComment("comment");
        clientRegistrationTemplate.setLoginButtonIcon("icon");
        clientRegistrationTemplate.setLoginButtonLabel("label");
        clientRegistrationTemplate.setHelpLink("helpLink");
        return clientRegistrationTemplate;
    }
}

