/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientInfo;
import org.thingsboard.server.common.data.oauth2.OAuth2CustomMapperConfig;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class OAuth2ClientServiceTest
extends AbstractServiceTest {
    @Autowired
    protected OAuth2ClientService oAuth2ClientService;

    @After
    public void after() {
        this.oAuth2ClientService.deleteByTenantId(TenantId.SYS_TENANT_ID);
    }

    @Test
    public void testSaveOauth2Client() {
        OAuth2Client oAuth2Client = this.validClientInfo(TenantId.SYS_TENANT_ID, "Test google client", List.of(PlatformType.ANDROID));
        OAuth2Client savedOauth2Client = this.oAuth2ClientService.saveOAuth2Client(SYSTEM_TENANT_ID, oAuth2Client);
        OAuth2Client retrievedOauth2Client = this.oAuth2ClientService.findOAuth2ClientById(savedOauth2Client.getTenantId(), (OAuth2ClientId)savedOauth2Client.getId());
        Assertions.assertThat((Object)retrievedOauth2Client).isEqualTo((Object)savedOauth2Client);
        savedOauth2Client.setTitle("New title");
        OAuth2Client updatedOauth2Client = this.oAuth2ClientService.saveOAuth2Client(SYSTEM_TENANT_ID, savedOauth2Client);
        OAuth2Client retrievedOauth2Client2 = this.oAuth2ClientService.findOAuth2ClientById(savedOauth2Client.getTenantId(), (OAuth2ClientId)savedOauth2Client.getId());
        Assertions.assertThat((Object)retrievedOauth2Client2).isEqualTo((Object)updatedOauth2Client);
    }

    @Test
    public void testSaveOauth2ClientWithoutMapper() {
        OAuth2Client oAuth2Client = this.validClientInfo(TenantId.SYS_TENANT_ID, "Test google client", List.of(PlatformType.ANDROID));
        oAuth2Client.setMapperConfig(null);
        Assertions.assertThatThrownBy(() -> this.oAuth2ClientService.saveOAuth2Client(TenantId.SYS_TENANT_ID, oAuth2Client)).hasMessageContaining("mapperConfig must not be null");
    }

    @Test
    public void testSaveOauth2ClientWithoutCustomConfig() {
        OAuth2Client oAuth2Client = this.validClientInfo(TenantId.SYS_TENANT_ID, "Test google client", List.of(PlatformType.ANDROID));
        oAuth2Client.getMapperConfig().setCustom(null);
        Assertions.assertThatThrownBy(() -> this.oAuth2ClientService.saveOAuth2Client(TenantId.SYS_TENANT_ID, oAuth2Client)).hasMessageContaining("Custom config should be specified!");
    }

    @Test
    public void testSaveOauth2ClientWithoutCustomUrl() {
        OAuth2Client oAuth2Client = this.validClientInfo(TenantId.SYS_TENANT_ID, "Test google client", List.of(PlatformType.ANDROID));
        oAuth2Client.getMapperConfig().setCustom(OAuth2CustomMapperConfig.builder().build());
        Assertions.assertThatThrownBy(() -> this.oAuth2ClientService.saveOAuth2Client(TenantId.SYS_TENANT_ID, oAuth2Client)).hasMessageContaining("Custom mapper URL should be specified!");
    }

    @Test
    public void testGetTenantOAuth2Clients() {
        ArrayList<OAuth2Client> oAuth2Clients = new ArrayList<OAuth2Client>();
        for (int i = 0; i < 5; ++i) {
            OAuth2Client oAuth2Client = this.validClientInfo(TenantId.SYS_TENANT_ID, StringUtils.randomAlphabetic((int)5));
            OAuth2Client savedOauth2Client = this.oAuth2ClientService.saveOAuth2Client(SYSTEM_TENANT_ID, oAuth2Client);
            oAuth2Clients.add(savedOauth2Client);
        }
        List retrieved = this.oAuth2ClientService.findOAuth2ClientsByTenantId(TenantId.SYS_TENANT_ID);
        Assertions.assertThat((List)retrieved).containsOnlyOnceElementsOf(oAuth2Clients);
        PageData retrievedInfos = this.oAuth2ClientService.findOAuth2ClientInfosByTenantId(TenantId.SYS_TENANT_ID, new PageLink(10));
        List oAuth2ClientInfos = oAuth2Clients.stream().map(OAuth2ClientInfo::new).collect(Collectors.toList());
        Assertions.assertThat((List)retrievedInfos.getData()).containsOnlyOnceElementsOf(oAuth2ClientInfos);
    }
}

