/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.common.data.mobile.app.MobileAppStatus;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class MobileAppServiceTest
extends AbstractServiceTest {
    @Autowired
    protected MobileAppService mobileAppService;
    @Autowired
    protected OAuth2ClientService oAuth2ClientService;

    @After
    public void after() {
        this.mobileAppService.deleteByTenantId(TenantId.SYS_TENANT_ID);
        this.oAuth2ClientService.deleteByTenantId(TenantId.SYS_TENANT_ID);
    }

    @Test
    public void testSaveMobileApp() {
        MobileApp MobileApp2 = this.validMobileApp(SYSTEM_TENANT_ID, "mobileApp.ce", PlatformType.IOS);
        MobileApp savedMobileApp = this.mobileAppService.saveMobileApp(SYSTEM_TENANT_ID, MobileApp2);
        MobileApp retrievedMobileApp = this.mobileAppService.findMobileAppById(savedMobileApp.getTenantId(), (MobileAppId)savedMobileApp.getId());
        Assertions.assertThat((Object)retrievedMobileApp).isEqualTo((Object)savedMobileApp);
        savedMobileApp.setPkgName("mobileApp.pe");
        MobileApp updatedMobileApp = this.mobileAppService.saveMobileApp(SYSTEM_TENANT_ID, savedMobileApp);
        MobileApp retrievedMobileApp2 = this.mobileAppService.findMobileAppById(savedMobileApp.getTenantId(), (MobileAppId)savedMobileApp.getId());
        Assertions.assertThat((Object)retrievedMobileApp2).isEqualTo((Object)updatedMobileApp);
        this.mobileAppService.deleteMobileAppById(SYSTEM_TENANT_ID, (MobileAppId)savedMobileApp.getId());
        Assertions.assertThat((Object)this.mobileAppService.findMobileAppById(SYSTEM_TENANT_ID, (MobileAppId)savedMobileApp.getId())).isNull();
    }

    @Test
    public void testGetTenantMobileApps() {
        ArrayList<MobileApp> mobileApps = new ArrayList<MobileApp>();
        for (int i = 0; i < 5; ++i) {
            MobileApp oAuth2Client = this.validMobileApp(SYSTEM_TENANT_ID, StringUtils.randomAlphabetic((int)5), PlatformType.ANDROID);
            MobileApp savedOauth2Client = this.mobileAppService.saveMobileApp(SYSTEM_TENANT_ID, oAuth2Client);
            mobileApps.add(savedOauth2Client);
        }
        PageData retrieved = this.mobileAppService.findMobileAppsByTenantId(TenantId.SYS_TENANT_ID, null, new PageLink(10, 0));
        Assertions.assertThat((List)retrieved.getData()).containsOnlyOnceElementsOf(mobileApps);
    }

    private MobileApp validMobileApp(TenantId tenantId, String mobileAppName, PlatformType platformType) {
        MobileApp MobileApp2 = new MobileApp();
        MobileApp2.setTenantId(tenantId);
        MobileApp2.setPkgName(mobileAppName);
        MobileApp2.setStatus(MobileAppStatus.DRAFT);
        MobileApp2.setAppSecret(StringUtils.randomAlphanumeric((int)24));
        MobileApp2.setPlatformType(platformType);
        return MobileApp2;
    }
}

