/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import lombok.Generated;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.entity.EntityDaoService;
import org.thingsboard.server.dao.entity.EntityServiceRegistry;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class EntityServiceRegistryTest
extends AbstractServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityServiceRegistryTest.class);
    @Autowired
    EntityServiceRegistry entityServiceRegistry;

    @Test
    public void givenAllEntityTypes_whenGetServiceByEntityTypeCalled_thenAllBeansExists() {
        for (EntityType entityType : EntityType.values()) {
            EntityDaoService entityDaoService = this.entityServiceRegistry.getServiceByEntityType(entityType);
            Assert.assertNotNull((String)("entityDaoService bean is missed for type: " + entityType.name()), (Object)entityDaoService);
        }
    }

    @Test
    public void givenRuleNodeEntityType_whenGetServiceByEntityTypeCalled_thenReturnedRuleChainService() {
        Assert.assertTrue((boolean)(this.entityServiceRegistry.getServiceByEntityType(EntityType.RULE_NODE) instanceof RuleChainService));
    }

    @Test
    public void givenCalculatedFieldLinkEntityType_whenGetServiceByEntityTypeCalled_thenReturnedCalculatedFieldService() {
        Assert.assertTrue((boolean)(this.entityServiceRegistry.getServiceByEntityType(EntityType.CALCULATED_FIELD_LINK) instanceof CalculatedFieldService));
    }
}

