/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class EntityDaoRegistryTest
extends AbstractServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityDaoRegistryTest.class);
    @Autowired
    EntityDaoRegistry entityDaoRegistry;
    @Autowired
    List<JpaRepository<?, ?>> repositories;

    @Test
    public void givenAllEntityTypes_whenGetDao_thenAllPresent() {
        for (EntityType entityType : EntityType.values()) {
            Dao dao = (Dao)org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.entityDaoRegistry.getDao(entityType));
            Assertions.assertThat((Object)dao).isNotNull();
        }
    }

    @Test
    public void givenAllDaos_whenFindById_thenOk() {
        for (EntityType entityType : EntityType.values()) {
            Dao dao = this.entityDaoRegistry.getDao(entityType);
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> dao.findById(TenantId.SYS_TENANT_ID, UUID.randomUUID()));
        }
    }

    @Test
    public void givenAllDaos_whenFindIdsByTenantIdAndIdOffset_thenOk() {
        for (EntityType entityType : EntityType.values()) {
            Dao dao = this.entityDaoRegistry.getDao(entityType);
            try {
                dao.findIdsByTenantIdAndIdOffset(TenantId.SYS_TENANT_ID, null, 10);
                dao.findIdsByTenantIdAndIdOffset(TenantId.SYS_TENANT_ID, UUID.randomUUID(), 10);
            }
            catch (Exception e) {
                String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
                if (error.contains("tenant_id")) {
                    log.debug("[{}] Ignoring not found tenant_id column", (Object)entityType);
                    continue;
                }
                Assertions.fail((String)("findIdsByTenantIdAndIdOffset for " + String.valueOf(entityType) + " dao threw error: " + error));
            }
        }
    }

    @Test
    public void testJpaRepositories() {
        for (JpaRepository<?, ?> repository : this.repositories) {
            repository.count();
        }
    }
}

