/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantProfileService;

@DaoSqlTest
public class EdgeServiceTest
extends AbstractServiceTest {
    @Autowired
    TbTenantProfileCache tbTenantProfileCache;
    @Autowired
    TenantProfileService tenantProfileService;
    @Autowired
    CustomerService customerService;
    @Autowired
    EdgeService edgeService;
    @Autowired
    RuleChainService ruleChainService;
    private final AbstractServiceTest.IdComparator<Edge> idComparator = new AbstractServiceTest.IdComparator();

    @After
    public void after() {
        this.tenantService.deleteTenant(this.tenantId);
        this.tenantProfileService.deleteTenantProfiles(this.tenantId);
    }

    @Test
    public void testSaveEdge() {
        Edge edge = this.constructEdge("My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        Assert.assertNotNull((Object)savedEdge);
        Assert.assertNotNull((Object)savedEdge.getId());
        Assert.assertTrue((savedEdge.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)edge.getTenantId(), (Object)savedEdge.getTenantId());
        Assert.assertNotNull((Object)savedEdge.getCustomerId());
        Assert.assertEquals((Object)ModelConstants.NULL_UUID, (Object)savedEdge.getCustomerId().getId());
        Assert.assertEquals((Object)edge.getName(), (Object)savedEdge.getName());
        savedEdge.setName("My new edge");
        this.edgeService.saveEdge(savedEdge);
        Edge foundEdge = this.edgeService.findEdgeById(this.tenantId, savedEdge.getId());
        Assert.assertEquals((Object)foundEdge.getName(), (Object)savedEdge.getName());
        this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
    }

    @Test
    public void testSaveEdgeWithEmptyName() {
        Edge edge = new Edge();
        edge.setType("default");
        edge.setTenantId(this.tenantId);
        Assertions.assertThrows(DataValidationException.class, () -> this.edgeService.saveEdge(edge));
    }

    @Test
    public void testSaveEdgeWithEmptyTenant() {
        Edge edge = new Edge();
        edge.setName("My edge");
        edge.setType("default");
        Assertions.assertThrows(DataValidationException.class, () -> this.edgeService.saveEdge(edge));
    }

    @Test
    public void testSaveEdgeWithInvalidTenant() {
        Edge edge = new Edge();
        edge.setName("My edge");
        edge.setType("default");
        edge.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        Assertions.assertThrows(DataValidationException.class, () -> this.edgeService.saveEdge(edge));
    }

    @Test
    public void testSaveEdgesWithInfiniteMaxEdgeLimit() {
        TenantProfile defaultTenantProfile = this.tenantProfileService.findDefaultTenantProfile(this.tenantId);
        defaultTenantProfile.getProfileData().setConfiguration((TenantProfileConfiguration)DefaultTenantProfileConfiguration.builder().maxEdges(Long.MAX_VALUE).build());
        this.tenantProfileService.saveTenantProfile(this.tenantId, defaultTenantProfile);
        Edge savedEdge = this.edgeService.saveEdge(this.constructEdge("My edge", "default"));
        this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
    }

    @Test
    public void testSaveEdgesWithMaxEdgeOutOfLimit() {
        TenantProfile defaultTenantProfile = this.tenantProfileService.findDefaultTenantProfile(this.tenantId);
        defaultTenantProfile.getProfileData().setConfiguration((TenantProfileConfiguration)DefaultTenantProfileConfiguration.builder().maxEdges(1L).build());
        this.tenantProfileService.saveTenantProfile(this.tenantId, defaultTenantProfile);
        this.tbTenantProfileCache.evict(defaultTenantProfile.getId());
        Assert.assertEquals((long)0L, (long)this.edgeService.countByTenantId(this.tenantId));
        Edge savedEdge = this.edgeService.saveEdge(this.constructEdge("My first edge", "default"));
        Assert.assertEquals((long)1L, (long)this.edgeService.countByTenantId(this.tenantId));
        Assertions.assertThrows(DataValidationException.class, () -> this.edgeService.saveEdge(this.constructEdge("My second edge that out of maxEdgeCount limit", "default")));
        this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
    }

    @Test
    public void testAssignEdgeToNonExistentCustomer() {
        Edge edge = this.constructEdge("My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.edgeService.assignEdgeToCustomer(this.tenantId, savedEdge.getId(), new CustomerId(Uuids.timeBased())));
        }
        finally {
            this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignEdgeToCustomerFromDifferentTenant() {
        Edge edge = this.constructEdge("My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        Tenant tenant = new Tenant();
        tenant.setTitle("Test different tenant");
        tenant = this.tenantService.saveTenant(tenant);
        Customer customer = new Customer();
        customer.setTenantId(tenant.getId());
        customer.setTitle("Test different customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.edgeService.assignEdgeToCustomer(this.tenantId, savedEdge.getId(), savedCustomer.getId()));
        }
        finally {
            this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
            this.tenantService.deleteTenant(tenant.getId());
        }
    }

    @Test
    public void testFindEdgeById() {
        Edge edge = this.constructEdge("My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        Edge foundEdge = this.edgeService.findEdgeById(this.tenantId, savedEdge.getId());
        Assert.assertNotNull((Object)foundEdge);
        Assert.assertEquals((Object)savedEdge, (Object)foundEdge);
        this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindEdgeTypesByTenantId() throws Exception {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        try {
            Edge edge2;
            int i;
            for (i = 0; i < 3; ++i) {
                edge2 = this.constructEdge("My edge B" + i, "typeB");
                edges.add(this.edgeService.saveEdge(edge2));
            }
            for (i = 0; i < 7; ++i) {
                edge2 = this.constructEdge("My edge C" + i, "typeC");
                edges.add(this.edgeService.saveEdge(edge2));
            }
            for (i = 0; i < 9; ++i) {
                edge2 = this.constructEdge("My edge A" + i, "typeA");
                edges.add(this.edgeService.saveEdge(edge2));
            }
            List edgeTypes = (List)this.edgeService.findEdgeTypesByTenantId(this.tenantId).get();
            Assert.assertNotNull((Object)edgeTypes);
            Assert.assertEquals((long)3L, (long)edgeTypes.size());
            Assert.assertEquals((Object)"typeA", (Object)((EntitySubtype)edgeTypes.get(0)).getType());
            Assert.assertEquals((Object)"typeB", (Object)((EntitySubtype)edgeTypes.get(1)).getType());
            Assert.assertEquals((Object)"typeC", (Object)((EntitySubtype)edgeTypes.get(2)).getType());
        }
        finally {
            edges.forEach(edge -> this.edgeService.deleteEdge(this.tenantId, edge.getId()));
        }
    }

    @Test
    public void testDeleteEdge() {
        Edge edge = this.constructEdge("My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        Edge foundEdge = this.edgeService.findEdgeById(this.tenantId, savedEdge.getId());
        Assert.assertNotNull((Object)foundEdge);
        this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
        foundEdge = this.edgeService.findEdgeById(this.tenantId, savedEdge.getId());
        Assert.assertNull((Object)foundEdge);
    }

    @Test
    public void testFindEdgesByTenantId() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < 178; ++i) {
            Edge edge = this.constructEdge(this.tenantId, "Edge " + i, "default");
            edges.add(this.edgeService.saveEdge(edge));
        }
        ArrayList loadedEdges = new ArrayList();
        PageLink pageLink = new PageLink(23);
        PageData pageData = null;
        do {
            pageData = this.edgeService.findEdgesByTenantId(this.tenantId, pageLink);
            loadedEdges.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edges, this.idComparator);
        Collections.sort(loadedEdges, this.idComparator);
        Assert.assertEquals(edges, loadedEdges);
        this.edgeService.deleteEdgesByTenantId(this.tenantId);
        pageLink = new PageLink(33);
        pageData = this.edgeService.findEdgesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindEdgesByTenantIdAndName() {
        String title1 = "Edge title 1";
        ArrayList<Edge> edgesTitle1 = new ArrayList<Edge>();
        for (int i = 0; i < 143; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, "default");
            edgesTitle1.add(this.edgeService.saveEdge(edge));
        }
        String title2 = "Edge title 2";
        ArrayList<Edge> edgesTitle2 = new ArrayList<Edge>();
        for (int i = 0; i < 175; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, "default");
            edgesTitle2.add(this.edgeService.saveEdge(edge));
        }
        ArrayList loadedEdgesTitle1 = new ArrayList();
        PageLink pageLink = new PageLink(15, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.edgeService.findEdgesByTenantId(this.tenantId, pageLink);
            loadedEdgesTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesTitle1, this.idComparator);
        Collections.sort(loadedEdgesTitle1, this.idComparator);
        Assert.assertEquals(edgesTitle1, loadedEdgesTitle1);
        ArrayList loadedEdgesTitle2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.edgeService.findEdgesByTenantId(this.tenantId, pageLink);
            loadedEdgesTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesTitle2, this.idComparator);
        Collections.sort(loadedEdgesTitle2, this.idComparator);
        Assert.assertEquals(edgesTitle2, loadedEdgesTitle2);
        for (Edge edge : loadedEdgesTitle1) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.edgeService.findEdgesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Edge edge : loadedEdgesTitle2) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.edgeService.findEdgesByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindEdgesByTenantIdAndType() {
        String title1 = "Edge title 1";
        String type1 = "typeA";
        ArrayList<Edge> edgesType1 = new ArrayList<Edge>();
        for (int i = 0; i < 143; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, type1);
            edgesType1.add(this.edgeService.saveEdge(edge));
        }
        String title2 = "Edge title 2";
        String type2 = "typeB";
        ArrayList<Edge> edgesType2 = new ArrayList<Edge>();
        for (int i = 0; i < 175; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, type2);
            edgesType2.add(this.edgeService.saveEdge(edge));
        }
        ArrayList loadedEdgesType1 = new ArrayList();
        PageLink pageLink = new PageLink(15, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndType(this.tenantId, type1, pageLink);
            loadedEdgesType1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesType1, this.idComparator);
        Collections.sort(loadedEdgesType1, this.idComparator);
        Assert.assertEquals(edgesType1, loadedEdgesType1);
        ArrayList loadedEdgesType2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndType(this.tenantId, type2, pageLink);
            loadedEdgesType2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesType2, this.idComparator);
        Collections.sort(loadedEdgesType2, this.idComparator);
        Assert.assertEquals(edgesType2, loadedEdgesType2);
        for (Edge edge : loadedEdgesType1) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.edgeService.findEdgesByTenantIdAndType(this.tenantId, type1, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Edge edge : loadedEdgesType2) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.edgeService.findEdgesByTenantIdAndType(this.tenantId, type2, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindEdgesByTenantIdAndCustomerId() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < 278; ++i) {
            Edge edge = this.constructEdge(this.tenantId, "Edge" + i, "default");
            edge = this.edgeService.saveEdge(edge);
            edges.add(this.edgeService.assignEdgeToCustomer(this.tenantId, edge.getId(), customerId));
        }
        ArrayList loadedEdges = new ArrayList();
        PageLink pageLink = new PageLink(23);
        PageData pageData = null;
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedEdges.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edges, this.idComparator);
        Collections.sort(loadedEdges, this.idComparator);
        Assert.assertEquals(edges, loadedEdges);
        this.edgeService.unassignCustomerEdges(this.tenantId, customerId);
        pageLink = new PageLink(33);
        pageData = this.edgeService.findEdgesByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindEdgesByTenantIdCustomerIdAndName() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        String title1 = "Edge title 1";
        ArrayList<Edge> edgesTitle1 = new ArrayList<Edge>();
        for (int i = 0; i < 175; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, "default");
            edge = this.edgeService.saveEdge(edge);
            edgesTitle1.add(this.edgeService.assignEdgeToCustomer(this.tenantId, edge.getId(), customerId));
        }
        String title2 = "Edge title 2";
        ArrayList<Edge> edgesTitle2 = new ArrayList<Edge>();
        for (int i = 0; i < 143; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, "default");
            edge = this.edgeService.saveEdge(edge);
            edgesTitle2.add(this.edgeService.assignEdgeToCustomer(this.tenantId, edge.getId(), customerId));
        }
        ArrayList loadedEdgesTitle1 = new ArrayList();
        PageLink pageLink = new PageLink(15, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedEdgesTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesTitle1, this.idComparator);
        Collections.sort(loadedEdgesTitle1, this.idComparator);
        Assert.assertEquals(edgesTitle1, loadedEdgesTitle1);
        ArrayList loadedEdgesTitle2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedEdgesTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesTitle2, this.idComparator);
        Collections.sort(loadedEdgesTitle2, this.idComparator);
        Assert.assertEquals(edgesTitle2, loadedEdgesTitle2);
        for (Edge edge : loadedEdgesTitle1) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.edgeService.findEdgesByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Edge edge : loadedEdgesTitle2) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.edgeService.findEdgesByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        this.customerService.deleteCustomer(this.tenantId, customerId);
    }

    @Test
    public void testFindEdgesByTenantIdCustomerIdAndType() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        String title1 = "Edge title 1";
        String type1 = "typeC";
        ArrayList<Edge> edgesType1 = new ArrayList<Edge>();
        for (int i = 0; i < 175; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, type1);
            edge = this.edgeService.saveEdge(edge);
            edgesType1.add(this.edgeService.assignEdgeToCustomer(this.tenantId, edge.getId(), customerId));
        }
        String title2 = "Edge title 2";
        String type2 = "typeD";
        ArrayList<Edge> edgesType2 = new ArrayList<Edge>();
        for (int i = 0; i < 143; ++i) {
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            Edge edge = this.constructEdge((String)name, type2);
            edge = this.edgeService.saveEdge(edge);
            edgesType2.add(this.edgeService.assignEdgeToCustomer(this.tenantId, edge.getId(), customerId));
        }
        ArrayList loadedEdgesType1 = new ArrayList();
        PageLink pageLink = new PageLink(15);
        PageData pageData = null;
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type1, pageLink);
            loadedEdgesType1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesType1, this.idComparator);
        Collections.sort(loadedEdgesType1, this.idComparator);
        Assert.assertEquals(edgesType1, loadedEdgesType1);
        ArrayList loadedEdgesType2 = new ArrayList();
        pageLink = new PageLink(4);
        do {
            pageData = this.edgeService.findEdgesByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type2, pageLink);
            loadedEdgesType2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(edgesType2, this.idComparator);
        Collections.sort(loadedEdgesType2, this.idComparator);
        Assert.assertEquals(edgesType2, loadedEdgesType2);
        for (Edge edge : loadedEdgesType1) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4);
        pageData = this.edgeService.findEdgesByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type1, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Edge edge : loadedEdgesType2) {
            this.edgeService.deleteEdge(this.tenantId, edge.getId());
        }
        pageLink = new PageLink(4);
        pageData = this.edgeService.findEdgesByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type2, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        this.customerService.deleteCustomer(this.tenantId, customerId);
    }

    private Edge constructEdge(String name, String type) {
        return this.constructEdge(this.tenantId, name, type);
    }

    @Test
    public void testCleanCacheIfEdgeRenamed() {
        String edgeNameBeforeRename = StringUtils.randomAlphanumeric((int)15);
        String edgeNameAfterRename = StringUtils.randomAlphanumeric((int)15);
        Edge edge = this.constructEdge(this.tenantId, edgeNameBeforeRename, "default");
        this.edgeService.saveEdge(edge);
        Edge savedEdge = this.edgeService.findEdgeByTenantIdAndName(this.tenantId, edgeNameBeforeRename);
        savedEdge.setName(edgeNameAfterRename);
        this.edgeService.saveEdge(savedEdge);
        Edge renamedEdge = this.edgeService.findEdgeByTenantIdAndName(this.tenantId, edgeNameBeforeRename);
        Assert.assertNull((String)"Can't find edge by name in cache if it was renamed", (Object)renamedEdge);
        this.edgeService.deleteEdge(this.tenantId, savedEdge.getId());
    }

    @Test
    public void testFindMissingToRelatedRuleChains() {
        Edge edge = this.constructEdge("My edge", "default");
        Edge savedEdge = this.edgeService.saveEdge(edge);
        RuleChain ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setName("Rule Chain #1");
        ruleChain.setType(RuleChainType.EDGE);
        RuleChain ruleChain1 = this.ruleChainService.saveRuleChain(ruleChain);
        ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setName("Rule Chain #2");
        ruleChain.setType(RuleChainType.EDGE);
        RuleChain ruleChain2 = this.ruleChainService.saveRuleChain(ruleChain);
        ruleChain = new RuleChain();
        ruleChain.setTenantId(this.tenantId);
        ruleChain.setName("Rule Chain #3");
        ruleChain.setType(RuleChainType.EDGE);
        RuleChain ruleChain3 = this.ruleChainService.saveRuleChain(ruleChain);
        RuleNode ruleNode1 = new RuleNode();
        ruleNode1.setName("Input rule node 1");
        ruleNode1.setType("org.thingsboard.rule.engine.flow.TbRuleChainInputNode");
        ObjectNode configuration = JacksonUtil.newObjectNode();
        configuration.put("ruleChainId", ruleChain1.getUuidId().toString());
        ruleNode1.setConfiguration((JsonNode)configuration);
        RuleNode ruleNode2 = new RuleNode();
        ruleNode2.setName("Input rule node 2");
        ruleNode2.setType("org.thingsboard.rule.engine.flow.TbRuleChainInputNode");
        configuration = JacksonUtil.newObjectNode();
        configuration.put("ruleChainId", ruleChain2.getUuidId().toString());
        ruleNode2.setConfiguration((JsonNode)configuration);
        RuleChainMetaData ruleChainMetaData3 = new RuleChainMetaData();
        ruleChainMetaData3.setNodes(Arrays.asList(ruleNode1, ruleNode2));
        ruleChainMetaData3.setFirstNodeIndex(Integer.valueOf(0));
        ruleChainMetaData3.setRuleChainId(ruleChain3.getId());
        this.ruleChainService.saveRuleChainMetaData(this.tenantId, ruleChainMetaData3, Function.identity());
        this.ruleChainService.assignRuleChainToEdge(this.tenantId, ruleChain3.getId(), savedEdge.getId());
        String missingToRelatedRuleChains = this.edgeService.findMissingToRelatedRuleChains(this.tenantId, savedEdge.getId(), "org.thingsboard.rule.engine.flow.TbRuleChainInputNode");
        Assert.assertEquals((Object)"{\"Rule Chain #3\":[\"Rule Chain #1\",\"Rule Chain #2\"]}", (Object)missingToRelatedRuleChains);
    }

    @Test
    public void testFindEdgesByTenantProfileId() {
        Tenant tenant1 = this.createTenant();
        Tenant tenant2 = this.createTenant();
        Assert.assertNotNull((Object)tenant1);
        Assert.assertNotNull((Object)tenant2);
        Edge edge1 = this.constructEdge(tenant1.getId(), "Tenant1 edge", "default");
        Edge edge2 = this.constructEdge(tenant2.getId(), "Tenant2 edge", "default");
        Edge savedEdge1 = this.edgeService.saveEdge(edge1);
        Edge savedEdge2 = this.edgeService.saveEdge(edge2);
        Assert.assertNotNull((Object)savedEdge1);
        Assert.assertNotNull((Object)savedEdge2);
        Assert.assertEquals((Object)tenant1.getTenantProfileId(), (Object)tenant2.getTenantProfileId());
        PageData edgesPageData = this.edgeService.findEdgesByTenantProfileId(tenant2.getTenantProfileId(), new PageLink(1000));
        Assert.assertEquals((long)2L, (long)edgesPageData.getTotalElements());
        this.tenantService.deleteTenant(tenant1.getId());
        this.tenantService.deleteTenant(tenant2.getId());
    }
}

