/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.text.ParseException;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeEventId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.edge.EdgeEventDao;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class EdgeEventServiceTest
extends AbstractServiceTest {
    @Autowired
    EdgeEventService edgeEventService;
    @Autowired
    EdgeEventDao edgeEventDao;
    long timeBeforeStartTime;
    long startTime;
    long eventTime;
    long endTime;
    long timeAfterEndTime;

    @Before
    public void before() throws ParseException {
        this.timeBeforeStartTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.parse("2016-11-01T11:30:00").getTime();
        this.startTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.parse("2016-11-01T12:00:00").getTime();
        this.eventTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.parse("2016-11-01T12:30:00").getTime();
        this.endTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.parse("2016-11-01T13:00:00").getTime();
        this.timeAfterEndTime = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.parse("2016-11-01T13:30:30").getTime();
    }

    @Test
    public void saveEdgeEvent() throws Exception {
        EdgeId edgeId = new EdgeId(Uuids.timeBased());
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        EdgeEvent edgeEvent = this.generateEdgeEvent(this.tenantId, edgeId, (EntityId)deviceId);
        this.edgeEventService.saveAsync(edgeEvent).get();
        PageData edgeEvents = this.edgeEventService.findEdgeEvents(this.tenantId, edgeId, Long.valueOf(0L), null, new TimePageLink(1));
        Assert.assertFalse((boolean)edgeEvents.getData().isEmpty());
        EdgeEvent saved = (EdgeEvent)edgeEvents.getData().get(0);
        Assert.assertEquals((Object)saved.getTenantId(), (Object)edgeEvent.getTenantId());
        Assert.assertEquals((Object)saved.getEdgeId(), (Object)edgeEvent.getEdgeId());
        Assert.assertEquals((Object)saved.getEntityId(), (Object)edgeEvent.getEntityId());
        Assert.assertEquals((Object)saved.getType(), (Object)edgeEvent.getType());
        Assert.assertEquals((Object)saved.getAction(), (Object)edgeEvent.getAction());
        Assert.assertEquals((Object)saved.getBody(), (Object)edgeEvent.getBody());
        this.edgeEventDao.cleanupEvents(1L);
    }

    protected EdgeEvent generateEdgeEvent(TenantId tenantId, EdgeId edgeId, EntityId entityId) throws IOException {
        if (tenantId == null) {
            tenantId = TenantId.fromUUID((UUID)Uuids.timeBased());
        }
        EdgeEvent edgeEvent = new EdgeEvent();
        edgeEvent.setTenantId(tenantId);
        edgeEvent.setEdgeId(edgeId);
        edgeEvent.setEntityId(entityId.getId());
        edgeEvent.setType(EdgeEventType.DEVICE);
        edgeEvent.setAction(EdgeEventActionType.ADDED);
        edgeEvent.setBody(this.readFromResource("TestJsonData.json"));
        return edgeEvent;
    }

    @Test
    public void findEdgeEventsBySeqIdOrder_createdTimeOrderIgnored() throws Exception {
        EdgeId edgeId = new EdgeId(Uuids.timeBased());
        DeviceId deviceId = new DeviceId(Uuids.timeBased());
        this.saveEdgeEventWithProvidedTime(this.timeBeforeStartTime, edgeId, (EntityId)deviceId, this.tenantId).get();
        this.saveEdgeEventWithProvidedTime(this.eventTime, edgeId, (EntityId)deviceId, this.tenantId).get();
        this.saveEdgeEventWithProvidedTime(this.eventTime + 2L, edgeId, (EntityId)deviceId, this.tenantId).get();
        this.saveEdgeEventWithProvidedTime(this.eventTime + 1L, edgeId, (EntityId)deviceId, this.tenantId).get();
        this.saveEdgeEventWithProvidedTime(this.timeAfterEndTime, edgeId, (EntityId)deviceId, this.tenantId).get();
        TimePageLink pageLink = new TimePageLink(2, 0, "", new SortOrder("createdTime", SortOrder.Direction.DESC), Long.valueOf(this.startTime), Long.valueOf(this.endTime));
        PageData edgeEvents = this.edgeEventService.findEdgeEvents(this.tenantId, edgeId, Long.valueOf(0L), null, pageLink);
        Assert.assertNotNull((Object)edgeEvents.getData());
        Assert.assertEquals((long)2L, (long)edgeEvents.getData().size());
        Assert.assertEquals((Object)Uuids.startOf((long)this.eventTime), (Object)((EdgeEvent)edgeEvents.getData().get(0)).getUuidId());
        Assert.assertEquals((Object)Uuids.startOf((long)(this.eventTime + 2L)), (Object)((EdgeEvent)edgeEvents.getData().get(1)).getUuidId());
        Assert.assertTrue((boolean)edgeEvents.hasNext());
        Assert.assertNotNull((Object)pageLink.nextPageLink());
        edgeEvents = this.edgeEventService.findEdgeEvents(this.tenantId, edgeId, Long.valueOf(0L), null, pageLink.nextPageLink());
        Assert.assertNotNull((Object)edgeEvents.getData());
        Assert.assertEquals((long)1L, (long)edgeEvents.getData().size());
        Assert.assertEquals((Object)Uuids.startOf((long)(this.eventTime + 1L)), (Object)((EdgeEvent)edgeEvents.getData().get(0)).getUuidId());
        Assert.assertFalse((boolean)edgeEvents.hasNext());
        this.edgeEventDao.cleanupEvents(1L);
    }

    private ListenableFuture<Void> saveEdgeEventWithProvidedTime(long time, EdgeId edgeId, EntityId entityId, TenantId tenantId) throws Exception {
        EdgeEvent edgeEvent = this.generateEdgeEvent(tenantId, edgeId, entityId);
        edgeEvent.setId((UUIDBased)new EdgeEventId(Uuids.startOf((long)time)));
        return this.edgeEventService.saveAsync(edgeEvent);
    }
}

