/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.domain.Domain;
import org.thingsboard.server.common.data.domain.DomainInfo;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientLoginInfo;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class DomainServiceTest
extends AbstractServiceTest {
    @Autowired
    protected DomainService domainService;
    @Autowired
    protected OAuth2ClientService oAuth2ClientService;

    @After
    public void after() {
        this.domainService.deleteByTenantId(TenantId.SYS_TENANT_ID);
        this.oAuth2ClientService.deleteByTenantId(TenantId.SYS_TENANT_ID);
    }

    @Test
    public void testSaveDomain() {
        Domain domain = this.constructDomain(TenantId.SYS_TENANT_ID, "test.domain.com", true, true);
        Domain savedDomain = this.domainService.saveDomain(SYSTEM_TENANT_ID, domain);
        Domain retrievedDomain = this.domainService.findDomainById(savedDomain.getTenantId(), (DomainId)savedDomain.getId());
        Assertions.assertThat((Object)retrievedDomain).isEqualTo((Object)savedDomain);
        savedDomain.setName("test.domain2.com");
        Domain updatedDomain = this.domainService.saveDomain(SYSTEM_TENANT_ID, savedDomain);
        Domain retrievedDomain2 = this.domainService.findDomainById(savedDomain.getTenantId(), (DomainId)savedDomain.getId());
        Assertions.assertThat((Object)retrievedDomain2).isEqualTo((Object)updatedDomain);
        DomainInfo retrievedInfo = this.domainService.findDomainInfoById(SYSTEM_TENANT_ID, (DomainId)savedDomain.getId());
        Assertions.assertThat((Object)retrievedInfo).isEqualTo((Object)new DomainInfo(updatedDomain, Collections.emptyList()));
        boolean oauth2Enabled = this.domainService.isOauth2Enabled(SYSTEM_TENANT_ID);
        Assertions.assertThat((boolean)oauth2Enabled).isTrue();
        updatedDomain.setOauth2Enabled(false);
        this.domainService.saveDomain(SYSTEM_TENANT_ID, updatedDomain);
        boolean oauth2Enabled2 = this.domainService.isOauth2Enabled(SYSTEM_TENANT_ID);
        Assertions.assertThat((boolean)oauth2Enabled2).isFalse();
        this.domainService.deleteDomainById(SYSTEM_TENANT_ID, (DomainId)savedDomain.getId());
        Assertions.assertThat((Object)this.domainService.findDomainById(SYSTEM_TENANT_ID, (DomainId)savedDomain.getId())).isNull();
    }

    @Test
    public void testGetTenantDomains() {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (int i = 0; i < 5; ++i) {
            Domain oAuth2Client = this.constructDomain(TenantId.SYS_TENANT_ID, StringUtils.randomAlphabetic((int)5).toLowerCase(), true, false);
            Domain savedOauth2Client = this.domainService.saveDomain(SYSTEM_TENANT_ID, oAuth2Client);
            domains.add(savedOauth2Client);
        }
        PageData retrieved = this.domainService.findDomainInfosByTenantId(TenantId.SYS_TENANT_ID, new PageLink(10, 0));
        List<DomainInfo> domainInfos = domains.stream().map(domain -> new DomainInfo(domain, Collections.emptyList())).toList();
        Assertions.assertThat((List)retrieved.getData()).containsOnlyOnceElementsOf(domainInfos);
    }

    @Test
    public void testGetDomainInfo() {
        OAuth2Client oAuth2Client = this.validClientInfo(TenantId.SYS_TENANT_ID, "Test google client");
        OAuth2Client savedOauth2Client = this.oAuth2ClientService.saveOAuth2Client(SYSTEM_TENANT_ID, oAuth2Client);
        List oAuth2ClientInfosByIds = this.oAuth2ClientService.findOAuth2ClientInfosByIds(TenantId.SYS_TENANT_ID, List.of((OAuth2ClientId)savedOauth2Client.getId()));
        Domain domain = this.constructDomain(TenantId.SYS_TENANT_ID, "test.domain.com", true, true);
        Domain savedDomain = this.domainService.saveDomain(SYSTEM_TENANT_ID, domain);
        this.domainService.updateOauth2Clients(TenantId.SYS_TENANT_ID, (DomainId)savedDomain.getId(), List.of((OAuth2ClientId)savedOauth2Client.getId()));
        DomainInfo retrievedInfo = this.domainService.findDomainInfoById(SYSTEM_TENANT_ID, (DomainId)savedDomain.getId());
        Assertions.assertThat((Object)retrievedInfo).isEqualTo((Object)new DomainInfo(savedDomain, oAuth2ClientInfosByIds));
        List oauth2LoginInfo = this.oAuth2ClientService.findOAuth2ClientLoginInfosByDomainName(savedDomain.getName());
        Assertions.assertThat((List)oauth2LoginInfo).containsOnly((Object[])new OAuth2ClientLoginInfo[]{new OAuth2ClientLoginInfo(savedOauth2Client.getLoginButtonLabel(), savedOauth2Client.getLoginButtonIcon(), String.format("/oauth2/authorization/%s", savedOauth2Client.getUuidId().toString()))});
    }

    private Domain constructDomain(TenantId tenantId, String domainName, boolean oauth2Enabled, boolean propagateToEdge) {
        Domain domain = new Domain();
        domain.setTenantId(tenantId);
        domain.setName(domainName);
        domain.setOauth2Enabled(oauth2Enabled);
        domain.setPropagateToEdge(propagateToEdge);
        return domain;
    }
}

