/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileInfo;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class DeviceProfileServiceTest
extends AbstractServiceTest {
    @Autowired
    DeviceProfileService deviceProfileService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    OtaPackageService otaPackageService;
    private AbstractServiceTest.IdComparator<DeviceProfile> idComparator = new AbstractServiceTest.IdComparator();
    private AbstractServiceTest.IdComparator<DeviceProfileInfo> deviceProfileInfoIdComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveDeviceProfile() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        Assert.assertNotNull((Object)savedDeviceProfile);
        Assert.assertNotNull((Object)savedDeviceProfile.getId());
        Assert.assertTrue((savedDeviceProfile.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)deviceProfile.getName(), (Object)savedDeviceProfile.getName());
        Assert.assertEquals((Object)deviceProfile.getDescription(), (Object)savedDeviceProfile.getDescription());
        Assert.assertEquals((Object)deviceProfile.getProfileData(), (Object)savedDeviceProfile.getProfileData());
        Assert.assertEquals((Object)deviceProfile.isDefault(), (Object)savedDeviceProfile.isDefault());
        Assert.assertEquals((Object)deviceProfile.getDefaultRuleChainId(), (Object)savedDeviceProfile.getDefaultRuleChainId());
        savedDeviceProfile.setName("New device profile");
        this.deviceProfileService.saveDeviceProfile(savedDeviceProfile);
        DeviceProfile foundDeviceProfile = this.deviceProfileService.findDeviceProfileById(this.tenantId, savedDeviceProfile.getId());
        Assert.assertEquals((Object)savedDeviceProfile.getName(), (Object)foundDeviceProfile.getName());
    }

    @Test
    public void testSaveDeviceProfileWithFirmware() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        Assert.assertNotNull((Object)savedDeviceProfile);
        Assert.assertNotNull((Object)savedDeviceProfile.getId());
        Assert.assertTrue((savedDeviceProfile.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)deviceProfile.getName(), (Object)savedDeviceProfile.getName());
        Assert.assertEquals((Object)deviceProfile.getDescription(), (Object)savedDeviceProfile.getDescription());
        Assert.assertEquals((Object)deviceProfile.getProfileData(), (Object)savedDeviceProfile.getProfileData());
        Assert.assertEquals((Object)deviceProfile.isDefault(), (Object)savedDeviceProfile.isDefault());
        Assert.assertEquals((Object)deviceProfile.getDefaultRuleChainId(), (Object)savedDeviceProfile.getDefaultRuleChainId());
        OtaPackage firmware = new OtaPackage();
        firmware.setTenantId(this.tenantId);
        firmware.setDeviceProfileId(savedDeviceProfile.getId());
        firmware.setType(OtaPackageType.FIRMWARE);
        firmware.setTitle("my firmware");
        firmware.setVersion("v1.0");
        firmware.setFileName("test.txt");
        firmware.setContentType("text/plain");
        firmware.setChecksumAlgorithm(ChecksumAlgorithm.SHA256);
        firmware.setChecksum("4bf5122f344554c53bde2ebb8cd2b7e3d1600ad631c385a5d7cce23c7785459a");
        firmware.setData(ByteBuffer.wrap(new byte[]{1}));
        firmware.setDataSize(Long.valueOf(1L));
        OtaPackage savedFirmware = this.otaPackageService.saveOtaPackage(firmware);
        deviceProfile.setFirmwareId(savedFirmware.getId());
        this.deviceProfileService.saveDeviceProfile(savedDeviceProfile);
        DeviceProfile foundDeviceProfile = this.deviceProfileService.findDeviceProfileById(this.tenantId, savedDeviceProfile.getId());
        Assert.assertEquals((Object)savedDeviceProfile.getName(), (Object)foundDeviceProfile.getName());
    }

    @Test
    public void testFindDeviceProfileById() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        DeviceProfile foundDeviceProfile = this.deviceProfileService.findDeviceProfileById(this.tenantId, savedDeviceProfile.getId());
        Assert.assertNotNull((Object)foundDeviceProfile);
        Assert.assertEquals((Object)savedDeviceProfile, (Object)foundDeviceProfile);
    }

    @Test
    public void testFindDeviceProfileInfoById() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        DeviceProfileInfo foundDeviceProfileInfo = this.deviceProfileService.findDeviceProfileInfoById(this.tenantId, savedDeviceProfile.getId());
        Assert.assertNotNull((Object)foundDeviceProfileInfo);
        Assert.assertEquals((Object)savedDeviceProfile.getId(), (Object)foundDeviceProfileInfo.getId());
        Assert.assertEquals((Object)savedDeviceProfile.getName(), (Object)foundDeviceProfileInfo.getName());
        Assert.assertEquals((Object)savedDeviceProfile.getType(), (Object)foundDeviceProfileInfo.getType());
    }

    @Test
    public void testFindDefaultDeviceProfile() {
        DeviceProfile foundDefaultDeviceProfile = this.deviceProfileService.findDefaultDeviceProfile(this.tenantId);
        Assert.assertNotNull((Object)foundDefaultDeviceProfile);
        Assert.assertNotNull((Object)foundDefaultDeviceProfile.getId());
        Assert.assertNotNull((Object)foundDefaultDeviceProfile.getName());
    }

    @Test
    public void testFindDefaultDeviceProfileInfo() {
        DeviceProfileInfo foundDefaultDeviceProfileInfo = this.deviceProfileService.findDefaultDeviceProfileInfo(this.tenantId);
        Assert.assertNotNull((Object)foundDefaultDeviceProfileInfo);
        Assert.assertNotNull((Object)foundDefaultDeviceProfileInfo.getId());
        Assert.assertNotNull((Object)foundDefaultDeviceProfileInfo.getName());
        Assert.assertNotNull((Object)foundDefaultDeviceProfileInfo.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindOrCreateDeviceProfile() throws ExecutionException, InterruptedException {
        ListeningExecutorService testExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(100, (ThreadFactory)ThingsBoardThreadFactory.forName((String)(this.getClass().getSimpleName() + "-test-scope"))));
        try {
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 50; ++i) {
                futures.add(testExecutor.submit(() -> this.deviceProfileService.findOrCreateDeviceProfile(this.tenantId, "Device Profile 1")));
                futures.add(testExecutor.submit(() -> this.deviceProfileService.findOrCreateDeviceProfile(this.tenantId, "Device Profile 2")));
            }
            List deviceProfiles = (List)Futures.allAsList(futures).get();
            deviceProfiles.forEach(Assert::assertNotNull);
        }
        finally {
            testExecutor.shutdownNow();
        }
    }

    @Test
    public void testSetDefaultDeviceProfile() {
        DeviceProfile deviceProfile1 = this.createDeviceProfile(this.tenantId, "Device Profile 1");
        DeviceProfile deviceProfile2 = this.createDeviceProfile(this.tenantId, "Device Profile 2");
        DeviceProfile savedDeviceProfile1 = this.deviceProfileService.saveDeviceProfile(deviceProfile1);
        DeviceProfile savedDeviceProfile2 = this.deviceProfileService.saveDeviceProfile(deviceProfile2);
        boolean result = this.deviceProfileService.setDefaultDeviceProfile(this.tenantId, savedDeviceProfile1.getId());
        Assert.assertTrue((boolean)result);
        DeviceProfile defaultDeviceProfile = this.deviceProfileService.findDefaultDeviceProfile(this.tenantId);
        Assert.assertNotNull((Object)defaultDeviceProfile);
        Assert.assertEquals((Object)savedDeviceProfile1.getId(), (Object)defaultDeviceProfile.getId());
        result = this.deviceProfileService.setDefaultDeviceProfile(this.tenantId, savedDeviceProfile2.getId());
        Assert.assertTrue((boolean)result);
        defaultDeviceProfile = this.deviceProfileService.findDefaultDeviceProfile(this.tenantId);
        Assert.assertNotNull((Object)defaultDeviceProfile);
        Assert.assertEquals((Object)savedDeviceProfile2.getId(), (Object)defaultDeviceProfile.getId());
    }

    @Test
    public void testSaveDeviceProfileWithEmptyName() {
        DeviceProfile deviceProfile = new DeviceProfile();
        deviceProfile.setTenantId(this.tenantId);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.deviceProfileService.saveDeviceProfile(deviceProfile));
    }

    @Test
    public void testSaveDeviceProfileWithSameName() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        this.deviceProfileService.saveDeviceProfile(deviceProfile);
        DeviceProfile deviceProfile2 = this.createDeviceProfile(this.tenantId, "Device Profile");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.deviceProfileService.saveDeviceProfile(deviceProfile2));
    }

    @Test
    public void testSaveDeviceProfileWithNameDefaultAndProfileWithIsDefaultAndDifferentNameAlreadyExists() {
        DeviceProfile defaultDeviceProfile = this.deviceProfileService.findDefaultDeviceProfile(this.tenantId);
        Assert.assertNotNull((Object)defaultDeviceProfile);
        defaultDeviceProfile.setName("Device Profile 1");
        this.deviceProfileService.saveDeviceProfile(defaultDeviceProfile);
        DeviceProfile createdDeviceProfile = this.deviceProfileService.findOrCreateDeviceProfile(this.tenantId, "default");
        Assert.assertNotNull((Object)createdDeviceProfile);
        Assert.assertEquals((Object)"default", (Object)createdDeviceProfile.getName());
        Assert.assertFalse((boolean)createdDeviceProfile.isDefault());
    }

    @Ignore
    @Test
    public void testChangeDeviceProfileTypeWithExistingDevices() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("Test device");
        device.setType("default");
        device.setDeviceProfileId(savedDeviceProfile.getId());
        this.deviceService.saveDevice(device);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.deviceProfileService.saveDeviceProfile(savedDeviceProfile));
    }

    @Test
    public void testChangeDeviceProfileTransportTypeWithExistingDevices() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("Test device");
        device.setType("default");
        device.setDeviceProfileId(savedDeviceProfile.getId());
        this.deviceService.saveDevice(device);
        savedDeviceProfile.setTransportType(DeviceTransportType.MQTT);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.deviceProfileService.saveDeviceProfile(savedDeviceProfile));
    }

    @Test
    public void testDeleteDeviceProfileWithExistingDevice() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("Test device");
        device.setType("default");
        device.setDeviceProfileId(savedDeviceProfile.getId());
        this.deviceService.saveDevice(device);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.deviceProfileService.deleteDeviceProfile(this.tenantId, savedDeviceProfile.getId()));
    }

    @Test
    public void testDeleteDeviceProfileWithExistingOta_cascadeDelete() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        deviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        OtaPackage otaPackage = this.constructDefaultOtaPackage(this.tenantId, deviceProfile.getId());
        otaPackage = this.otaPackageService.saveOtaPackage(otaPackage);
        Assertions.assertThat((Object)this.deviceProfileService.findDeviceProfileById(this.tenantId, deviceProfile.getId())).isNotNull();
        Assertions.assertThat((Object)this.otaPackageService.findOtaPackageById(this.tenantId, otaPackage.getId())).isNotNull();
        this.deviceProfileService.deleteDeviceProfile(this.tenantId, deviceProfile.getId());
        Assertions.assertThat((Object)this.deviceProfileService.findDeviceProfileById(this.tenantId, deviceProfile.getId())).isNull();
        Assertions.assertThat((Object)this.otaPackageService.findOtaPackageById(this.tenantId, otaPackage.getId())).isNull();
    }

    @Test
    public void testDeleteDeviceProfile() {
        DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile");
        DeviceProfile savedDeviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
        this.deviceProfileService.deleteDeviceProfile(this.tenantId, savedDeviceProfile.getId());
        DeviceProfile foundDeviceProfile = this.deviceProfileService.findDeviceProfileById(this.tenantId, savedDeviceProfile.getId());
        Assert.assertNull((Object)foundDeviceProfile);
    }

    @Test
    public void testFindDeviceProfiles() {
        ArrayList<DeviceProfile> deviceProfiles = new ArrayList<DeviceProfile>();
        PageLink pageLink = new PageLink(17);
        PageData pageData = this.deviceProfileService.findDeviceProfiles(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)1L, (long)pageData.getTotalElements());
        deviceProfiles.addAll(pageData.getData());
        for (int i = 0; i < 28; ++i) {
            DeviceProfile deviceProfile = this.createDeviceProfile(this.tenantId, "Device Profile" + i);
            deviceProfiles.add(this.deviceProfileService.saveDeviceProfile(deviceProfile));
        }
        ArrayList loadedDeviceProfiles = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.deviceProfileService.findDeviceProfiles(this.tenantId, pageLink);
            loadedDeviceProfiles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(deviceProfiles, this.idComparator);
        Collections.sort(loadedDeviceProfiles, this.idComparator);
        Assert.assertEquals(deviceProfiles, loadedDeviceProfiles);
        for (DeviceProfile deviceProfile : loadedDeviceProfiles) {
            if (deviceProfile.isDefault()) continue;
            this.deviceProfileService.deleteDeviceProfile(this.tenantId, deviceProfile.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.deviceProfileService.findDeviceProfiles(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)1L, (long)pageData.getTotalElements());
    }

    @Test
    public void testFindDeviceProfileInfos() {
        PageData pageData;
        ArrayList<DeviceProfile> deviceProfiles = new ArrayList<DeviceProfile>();
        PageLink pageLink = new PageLink(17);
        PageData deviceProfilePageData = this.deviceProfileService.findDeviceProfiles(this.tenantId, pageLink);
        Assert.assertFalse((boolean)deviceProfilePageData.hasNext());
        Assert.assertEquals((long)1L, (long)deviceProfilePageData.getTotalElements());
        deviceProfiles.addAll(deviceProfilePageData.getData());
        for (int i = 0; i < 28; ++i) {
            DeviceProfile deviceProfile2 = this.createDeviceProfile(this.tenantId, "Device Profile" + i);
            deviceProfiles.add(this.deviceProfileService.saveDeviceProfile(deviceProfile2));
        }
        ArrayList loadedDeviceProfileInfos = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.deviceProfileService.findDeviceProfileInfos(this.tenantId, pageLink, null);
            loadedDeviceProfileInfos.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(deviceProfiles, this.idComparator);
        Collections.sort(loadedDeviceProfileInfos, this.deviceProfileInfoIdComparator);
        List deviceProfileInfos = deviceProfiles.stream().map(deviceProfile -> new DeviceProfileInfo((EntityId)deviceProfile.getId(), deviceProfile.getTenantId(), deviceProfile.getName(), deviceProfile.getImage(), deviceProfile.getDefaultDashboardId(), deviceProfile.getType(), deviceProfile.getTransportType())).collect(Collectors.toList());
        Assert.assertEquals(deviceProfileInfos, loadedDeviceProfileInfos);
        for (DeviceProfile deviceProfile3 : deviceProfiles) {
            if (deviceProfile3.isDefault()) continue;
            this.deviceProfileService.deleteDeviceProfile(this.tenantId, deviceProfile3.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.deviceProfileService.findDeviceProfileInfos(this.tenantId, pageLink, null);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)1L, (long)pageData.getTotalElements());
    }

    @Test
    public void testFindAllDeviceProfilesByTenantId() {
        int deviceProfilesCount = 4;
        ArrayList<DeviceProfile> deviceProfiles = new ArrayList<DeviceProfile>(4);
        DeviceProfile profileC = this.deviceProfileService.saveDeviceProfile(this.createDeviceProfile(this.tenantId, "profile C"));
        deviceProfiles.add(this.deviceProfileService.saveDeviceProfile(profileC));
        DeviceProfile profileA = this.deviceProfileService.saveDeviceProfile(this.createDeviceProfile(this.tenantId, "profile A"));
        deviceProfiles.add(this.deviceProfileService.saveDeviceProfile(profileA));
        DeviceProfile profileB = this.deviceProfileService.saveDeviceProfile(this.createDeviceProfile(this.tenantId, "profile B"));
        deviceProfiles.add(this.deviceProfileService.saveDeviceProfile(profileB));
        deviceProfiles.add(this.deviceProfileService.findDefaultDeviceProfile(this.tenantId));
        List sortedProfileInfos = deviceProfiles.stream().map(profile -> new EntityInfo((EntityId)profile.getId(), profile.getName())).sorted(Comparator.comparing(EntityInfo::getName)).collect(Collectors.toList());
        List deviceProfileInfos = this.deviceProfileService.findDeviceProfileNamesByTenantId(this.tenantId, false);
        Assertions.assertThat((List)deviceProfileInfos).isNotNull();
        Assertions.assertThat((List)deviceProfileInfos).hasSize(deviceProfilesCount);
        Assertions.assertThat((List)deviceProfileInfos).isEqualTo(sortedProfileInfos);
    }

    @Test
    public void testFindActiveOnlyDeviceProfilesByTenantId() {
        String profileCName = "profile C";
        this.deviceProfileService.saveDeviceProfile(this.createDeviceProfile(this.tenantId, profileCName));
        String profileAName = "profile A";
        this.deviceProfileService.saveDeviceProfile(this.createDeviceProfile(this.tenantId, profileAName));
        String profileBName = "profile B";
        this.deviceProfileService.saveDeviceProfile(this.createDeviceProfile(this.tenantId, profileBName));
        List deviceProfileInfos = this.deviceProfileService.findDeviceProfileNamesByTenantId(this.tenantId, true);
        Assertions.assertThat((List)deviceProfileInfos).isNotNull();
        Assertions.assertThat((List)deviceProfileInfos).isEmpty();
        Device deviceC = new Device();
        deviceC.setName("Test Device C");
        deviceC.setType(profileCName);
        deviceC.setTenantId(this.tenantId);
        deviceC = this.deviceService.saveDevice(deviceC);
        Device deviceA = new Device();
        deviceA.setName("Test Device A");
        deviceA.setType(profileAName);
        deviceA.setTenantId(this.tenantId);
        deviceA = this.deviceService.saveDevice(deviceA);
        Device deviceB = new Device();
        deviceB.setName("Test Device B");
        deviceB.setType(profileBName);
        deviceB.setTenantId(this.tenantId);
        deviceB = this.deviceService.saveDevice(deviceB);
        deviceProfileInfos = this.deviceProfileService.findDeviceProfileNamesByTenantId(this.tenantId, true);
        List<EntityInfo> expected = List.of(new EntityInfo((EntityId)deviceA.getDeviceProfileId(), profileAName), new EntityInfo((EntityId)deviceB.getDeviceProfileId(), profileBName), new EntityInfo((EntityId)deviceC.getDeviceProfileId(), profileCName));
        Assertions.assertThat((List)deviceProfileInfos).isNotEmpty();
        Assertions.assertThat((List)deviceProfileInfos).hasSize(3);
        Assertions.assertThat((List)deviceProfileInfos).isEqualTo(expected);
    }
}

