/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.DeviceCredentialsId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.eventsourcing.ActionEntityEvent;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class DeviceCredentialsServiceTest
extends AbstractServiceTest {
    @Autowired
    DeviceCredentialsService deviceCredentialsService;
    @Autowired
    DeviceService deviceService;
    @MockitoBean
    ApplicationEventPublisher eventPublisher;

    @Test
    public void testCreateDeviceCredentials() {
        DeviceCredentials deviceCredentials = new DeviceCredentials();
        Assertions.assertThrows(DataValidationException.class, () -> this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, deviceCredentials));
    }

    @Test
    public void testSaveDeviceCredentialsWithEmptyDevice() {
        Device device = new Device();
        device.setName("My device");
        device.setType("default");
        device.setTenantId(this.tenantId);
        device = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, device.getId());
        deviceCredentials.setDeviceId(null);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, deviceCredentials));
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, device.getId());
        }
    }

    @Test
    public void testSaveDeviceCredentialsWithEmptyCredentialsType() {
        Device device = new Device();
        device.setName("My device");
        device.setType("default");
        device.setTenantId(this.tenantId);
        device = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, device.getId());
        deviceCredentials.setCredentialsType(null);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, deviceCredentials));
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, device.getId());
        }
    }

    @Test
    public void testSaveDeviceCredentialsWithEmptyCredentialsId() {
        Device device = new Device();
        device.setName("My device");
        device.setType("default");
        device.setTenantId(this.tenantId);
        device = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, device.getId());
        deviceCredentials.setCredentialsId(null);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, deviceCredentials));
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, device.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveNonExistentDeviceCredentials() {
        Device device = new Device();
        device.setName("My device");
        device.setType("default");
        device.setTenantId(this.tenantId);
        device = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, device.getId());
        DeviceCredentials newDeviceCredentials = new DeviceCredentials(new DeviceCredentialsId(Uuids.timeBased()));
        newDeviceCredentials.setCreatedTime(deviceCredentials.getCreatedTime());
        newDeviceCredentials.setDeviceId(deviceCredentials.getDeviceId());
        newDeviceCredentials.setCredentialsType(deviceCredentials.getCredentialsType());
        newDeviceCredentials.setCredentialsId(deviceCredentials.getCredentialsId());
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, newDeviceCredentials));
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, device.getId());
        }
    }

    @Test
    public void testSaveDeviceCredentialsWithNonExistentDevice() {
        Device device = new Device();
        device.setName("My device");
        device.setType("default");
        device.setTenantId(this.tenantId);
        device = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, device.getId());
        deviceCredentials.setDeviceId(new DeviceId(Uuids.timeBased()));
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, deviceCredentials));
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, device.getId());
        }
    }

    @Test
    public void testFindDeviceCredentialsByDeviceId() {
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("My device");
        device.setType("default");
        Device savedDevice = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, savedDevice.getId());
        Assert.assertEquals((Object)savedDevice.getId(), (Object)deviceCredentials.getDeviceId());
        this.deviceService.deleteDevice(this.tenantId, savedDevice.getId());
        deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, savedDevice.getId());
        Assert.assertNull((Object)deviceCredentials);
    }

    @Test
    public void testFindDeviceCredentialsByCredentialsId() {
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("My device");
        device.setType("default");
        Device savedDevice = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, savedDevice.getId());
        Assert.assertEquals((Object)savedDevice.getId(), (Object)deviceCredentials.getDeviceId());
        DeviceCredentials foundDeviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(deviceCredentials.getCredentialsId());
        Assert.assertEquals((Object)deviceCredentials, (Object)foundDeviceCredentials);
        this.deviceService.deleteDevice(this.tenantId, savedDevice.getId());
        foundDeviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(deviceCredentials.getCredentialsId());
        Assert.assertNull((Object)foundDeviceCredentials);
    }

    @Test
    public void testSaveDeviceCredentials() {
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("My device");
        device.setType("default");
        Device savedDevice = this.deviceService.saveDevice(device);
        DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, savedDevice.getId());
        Assert.assertEquals((Object)savedDevice.getId(), (Object)deviceCredentials.getDeviceId());
        deviceCredentials.setCredentialsType(DeviceCredentialsType.ACCESS_TOKEN);
        deviceCredentials.setCredentialsId("access_token");
        deviceCredentials = this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, deviceCredentials);
        DeviceCredentials foundDeviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, savedDevice.getId());
        Assert.assertEquals((Object)deviceCredentials, (Object)foundDeviceCredentials);
        this.deviceService.deleteDevice(this.tenantId, savedDevice.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateDeviceCredentialsWithSameValuesDoesNotPublishEvent() {
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("My device");
        device.setType("default");
        Device savedDevice = this.deviceService.saveDevice(device);
        try {
            DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(this.tenantId, savedDevice.getId());
            Assert.assertNotNull((Object)deviceCredentials);
            DeviceCredentials updatedCredentials = new DeviceCredentials(deviceCredentials.getId());
            updatedCredentials.setDeviceId(deviceCredentials.getDeviceId());
            updatedCredentials.setCredentialsType(deviceCredentials.getCredentialsType());
            updatedCredentials.setCredentialsId(deviceCredentials.getCredentialsId());
            updatedCredentials.setCredentialsValue(deviceCredentials.getCredentialsValue());
            Mockito.reset((Object[])new ApplicationEventPublisher[]{this.eventPublisher});
            DeviceCredentials result = this.deviceCredentialsService.updateDeviceCredentials(this.tenantId, updatedCredentials);
            Assert.assertEquals((Object)deviceCredentials.getCredentialsId(), (Object)result.getCredentialsId());
            Assert.assertEquals((Object)deviceCredentials.getCredentialsType(), (Object)result.getCredentialsType());
            Assert.assertEquals((Object)deviceCredentials.getCredentialsValue(), (Object)result.getCredentialsValue());
            Assert.assertEquals((Object)deviceCredentials.getDeviceId(), (Object)result.getDeviceId());
            ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.never())).publishEvent(Mockito.any(ActionEntityEvent.class));
        }
        finally {
            this.deviceService.deleteDevice(this.tenantId, savedDevice.getId());
        }
    }
}

