/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.test.util.ReflectionTestUtils;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DeviceCredentialsId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.dao.device.DeviceCredentialsDao;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.service.DataValidator;

@DaoSqlTest
public class DeviceCredentialsCacheTest
extends AbstractServiceTest {
    private final String CREDENTIALS_ID_1 = StringUtils.randomAlphanumeric((int)20);
    private final String CREDENTIALS_ID_2 = StringUtils.randomAlphanumeric((int)20);
    @Autowired
    private DeviceCredentialsService deviceCredentialsService;
    @Autowired
    private DataValidator<DeviceCredentials> credentialsValidator;
    private DeviceCredentialsDao deviceCredentialsDao;
    private DeviceService deviceService;
    @Autowired
    private CacheManager cacheManager;
    private UUID deviceId = UUID.randomUUID();

    @Before
    public void setup() throws Exception {
        this.deviceService = (DeviceService)Mockito.mock(DeviceService.class);
        this.deviceCredentialsDao = (DeviceCredentialsDao)Mockito.mock(DeviceCredentialsDao.class);
        ReflectionTestUtils.setField(this.credentialsValidator, (String)"deviceService", (Object)this.deviceService);
        ReflectionTestUtils.setField(this.credentialsValidator, (String)"deviceCredentialsDao", (Object)this.deviceCredentialsDao);
        ReflectionTestUtils.setField((Object)this.unwrapDeviceCredentialsService(), (String)"deviceCredentialsDao", (Object)this.deviceCredentialsDao);
        ReflectionTestUtils.setField((Object)this.unwrapDeviceCredentialsService(), (String)"credentialsValidator", this.credentialsValidator);
    }

    @After
    public void cleanup() {
        this.cacheManager.getCache("deviceCredentials").clear();
    }

    @Test
    public void testFindDeviceCredentialsByCredentialsId_Cached() {
        Mockito.when((Object)this.deviceCredentialsDao.findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1)).thenReturn((Object)this.createDummyDeviceCredentialsEntity(this.CREDENTIALS_ID_1));
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        ((DeviceCredentialsDao)Mockito.verify((Object)this.deviceCredentialsDao, (VerificationMode)Mockito.times((int)1))).findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1);
    }

    @Test
    public void testDeleteDeviceCredentials_EvictsCache() {
        Mockito.when((Object)this.deviceCredentialsDao.findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1)).thenReturn((Object)this.createDummyDeviceCredentialsEntity(this.CREDENTIALS_ID_1));
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        ((DeviceCredentialsDao)Mockito.verify((Object)this.deviceCredentialsDao, (VerificationMode)Mockito.times((int)1))).findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1);
        this.deviceCredentialsService.deleteDeviceCredentials(SYSTEM_TENANT_ID, this.createDummyDeviceCredentials(this.CREDENTIALS_ID_1, this.deviceId));
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        ((DeviceCredentialsDao)Mockito.verify((Object)this.deviceCredentialsDao, (VerificationMode)Mockito.times((int)2))).findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1);
    }

    @Test
    public void testSaveDeviceCredentials_EvictsPreviousCache() throws Exception {
        Mockito.when((Object)this.deviceCredentialsDao.findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1)).thenReturn((Object)this.createDummyDeviceCredentialsEntity(this.CREDENTIALS_ID_1));
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        ((DeviceCredentialsDao)Mockito.verify((Object)this.deviceCredentialsDao, (VerificationMode)Mockito.times((int)1))).findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1);
        Mockito.when((Object)this.deviceCredentialsDao.findByDeviceId(SYSTEM_TENANT_ID, this.deviceId)).thenReturn((Object)this.createDummyDeviceCredentialsEntity(this.CREDENTIALS_ID_1));
        UUID deviceCredentialsId = UUID.randomUUID();
        Mockito.when((Object)((DeviceCredentials)this.deviceCredentialsDao.findById(SYSTEM_TENANT_ID, deviceCredentialsId))).thenReturn((Object)this.createDummyDeviceCredentialsEntity(this.CREDENTIALS_ID_1));
        Mockito.when((Object)this.deviceService.findDeviceById(SYSTEM_TENANT_ID, new DeviceId(this.deviceId))).thenReturn((Object)new Device());
        DeviceCredentials dummy = this.createDummyDeviceCredentials(deviceCredentialsId, this.CREDENTIALS_ID_2, this.deviceId);
        Mockito.when((Object)this.deviceCredentialsDao.saveAndFlush(SYSTEM_TENANT_ID, dummy)).thenReturn((Object)dummy);
        this.deviceCredentialsService.updateDeviceCredentials(SYSTEM_TENANT_ID, dummy);
        Mockito.when((Object)this.deviceCredentialsDao.findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1)).thenReturn(null);
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        this.deviceCredentialsService.findDeviceCredentialsByCredentialsId(this.CREDENTIALS_ID_1);
        ((DeviceCredentialsDao)Mockito.verify((Object)this.deviceCredentialsDao, (VerificationMode)Mockito.times((int)2))).findByCredentialsId(SYSTEM_TENANT_ID, this.CREDENTIALS_ID_1);
    }

    private DeviceCredentialsService unwrapDeviceCredentialsService() throws Exception {
        if (AopUtils.isAopProxy((Object)this.deviceCredentialsService) && this.deviceCredentialsService instanceof Advised) {
            Object target = ((Advised)this.deviceCredentialsService).getTargetSource().getTarget();
            return (DeviceCredentialsService)target;
        }
        return this.deviceCredentialsService;
    }

    private DeviceCredentials createDummyDeviceCredentialsEntity(String deviceCredentialsId) {
        DeviceCredentials result = new DeviceCredentials(new DeviceCredentialsId(UUID.randomUUID()));
        result.setCredentialsId(deviceCredentialsId);
        return result;
    }

    private DeviceCredentials createDummyDeviceCredentials(String deviceCredentialsId, UUID deviceId) {
        return this.createDummyDeviceCredentials(null, deviceCredentialsId, deviceId);
    }

    private DeviceCredentials createDummyDeviceCredentials(UUID id, String deviceCredentialsId, UUID deviceId) {
        DeviceCredentials result = new DeviceCredentials();
        result.setId((UUIDBased)new DeviceCredentialsId(id));
        result.setDeviceId(new DeviceId(deviceId));
        result.setCredentialsId(deviceCredentialsId);
        result.setCredentialsType(DeviceCredentialsType.ACCESS_TOKEN);
        return result;
    }
}

