/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import lombok.Generated;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.DataValidator;

public class DataValidatorTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataValidatorTest.class);
    DataValidator<?> dataValidator;

    @BeforeEach
    void setUp() {
        this.dataValidator = (DataValidator)Mockito.spy(DataValidator.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"coffee", "1", "big box", "\u4e16\u754c", "!", "--", "~!@#$%^&*()_+=-/|\\[]{};:'`\"?<>,.", "\ud83d\udc0c", "!", "Gdy Pomorze nie pomo\u017ce, to pomo\u017ce mo\u017ce morze, a gdy morze nie pomo\u017ce, to pomo\u017ce mo\u017ce Gda\u0144sk"})
    void validateName_thenOK(String name) {
        this.dataValidator.validateString("Device name", name);
        this.dataValidator.validateString("Asset name", name);
        this.dataValidator.validateString("Asset profile name", name);
        this.dataValidator.validateString("Alarm type", name);
        this.dataValidator.validateString("Customer name", name);
        this.dataValidator.validateString("Tenant name", name);
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "  ", "\n", "\r\n", "\t", "\u0000", "\u0000\u0000", "\u0001", "\u0002", " ", "\u0000", "\u0000\u0000", "F0929906\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000F0929906", "\u0000F0929906", "F092\u00009906", "F0929906\u0000"})
    void validateName_thenDataValidationException(String name) {
        DataValidationException exception = (DataValidationException)org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.dataValidator.validateString("Asset name", name));
        log.warn("Exception message Asset name: {}", (Object)exception.getMessage());
        ((AbstractStringAssert)Assertions.assertThat((String)exception.getMessage()).as("message Asset name", new Object[0])).containsPattern((CharSequence)"Asset name .*");
        exception = (DataValidationException)org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.dataValidator.validateString("Device name", name));
        log.warn("Exception message Device name: {}", (Object)exception.getMessage());
        ((AbstractStringAssert)Assertions.assertThat((String)exception.getMessage()).as("message Device name", new Object[0])).containsPattern((CharSequence)"Device name .*");
    }

    @ParameterizedTest
    @ValueSource(strings={"aZ1_!#$%&'*+/=?`{|}~^.-@mail.io", "support@thingsboard.io"})
    public void validateEmail(String email) {
        DataValidator.validateEmail((String)email);
    }

    @ParameterizedTest
    @ValueSource(strings={"test:1@mail.io", "test()1@mail.io", "test[]1@mail.io", "test\\1@mail.io", "test\"1@mail.io", "test<>1@mail.io"})
    public void validateEmailInvalid(String email) {
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> DataValidator.validateEmail((String)email));
    }

    @ParameterizedTest
    @ValueSource(strings={"azAZ09_.-", "topic"})
    public void validateQueueNameOrTopic(String value) {
        DataValidator.validateQueueNameOrTopic((String)value, (String)"name");
        DataValidator.validateQueueNameOrTopic((String)value, (String)"topic");
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "  ", "\n", "\r\n", "\t", "\u0000", "\u0000\u0000", "\u0001", "\u0002", " ", "\u0000", "\u0000\u0000", "topic@home", "!", ",", "\u0141\u00f3d\u017a", "\ud83d\udc0c", "!", "F0929906\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000"})
    public void validateQueueNameOrTopicInvalid(String value) {
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> DataValidator.validateQueueNameOrTopic((String)value, (String)"name"));
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> DataValidator.validateQueueNameOrTopic((String)value, (String)"topic"));
    }
}

