/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class DashboardServiceTest
extends AbstractServiceTest {
    @Autowired
    CustomerService customerService;
    @Autowired
    DashboardService dashboardService;
    @Autowired
    EdgeService edgeService;
    private AbstractServiceTest.IdComparator<DashboardInfo> idComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveDashboard() throws IOException {
        Dashboard dashboard = new Dashboard();
        dashboard.setTenantId(this.tenantId);
        dashboard.setTitle("My dashboard");
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        Assert.assertNotNull((Object)savedDashboard);
        Assert.assertNotNull((Object)savedDashboard.getId());
        Assert.assertTrue((savedDashboard.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)dashboard.getTenantId(), (Object)savedDashboard.getTenantId());
        Assert.assertEquals((Object)dashboard.getTitle(), (Object)savedDashboard.getTitle());
        savedDashboard.setTitle("My new dashboard");
        this.dashboardService.saveDashboard(savedDashboard);
        Dashboard foundDashboard = this.dashboardService.findDashboardById(this.tenantId, savedDashboard.getId());
        Assert.assertEquals((Object)foundDashboard.getTitle(), (Object)savedDashboard.getTitle());
        this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
    }

    @Test
    public void testSaveDashboardWithEmptyTitle() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTenantId(this.tenantId);
        Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.saveDashboard(dashboard));
    }

    @Test
    public void testSaveDashboardWithEmptyTenant() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("My dashboard");
        Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.saveDashboard(dashboard));
    }

    @Test
    public void testSaveDashboardWithInvalidTenant() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("My dashboard");
        dashboard.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.saveDashboard(dashboard));
    }

    @Test
    public void testAssignDashboardToNonExistentCustomer() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("My dashboard");
        dashboard.setTenantId(this.tenantId);
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.assignDashboardToCustomer(this.tenantId, savedDashboard.getId(), new CustomerId(Uuids.timeBased())));
        }
        finally {
            this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignDashboardToCustomerFromDifferentTenant() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("My dashboard");
        dashboard.setTenantId(this.tenantId);
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        Tenant tenant = new Tenant();
        tenant.setTitle("Test different tenant [dashboard]");
        tenant = this.tenantService.saveTenant(tenant);
        Customer customer = new Customer();
        customer.setTenantId(tenant.getId());
        customer.setTitle("Test different customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.assignDashboardToCustomer(this.tenantId, savedDashboard.getId(), savedCustomer.getId()));
        }
        finally {
            this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
            this.tenantService.deleteTenant(tenant.getId());
        }
    }

    @Test
    public void testFindDashboardById() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTenantId(this.tenantId);
        dashboard.setTitle("My dashboard");
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        Dashboard foundDashboard = this.dashboardService.findDashboardById(this.tenantId, savedDashboard.getId());
        Assert.assertNotNull((Object)foundDashboard);
        Assert.assertEquals((Object)savedDashboard, (Object)foundDashboard);
        this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
    }

    @Test
    public void testDeleteDashboard() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTenantId(this.tenantId);
        dashboard.setTitle("My dashboard");
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        Dashboard foundDashboard = this.dashboardService.findDashboardById(this.tenantId, savedDashboard.getId());
        Assert.assertNotNull((Object)foundDashboard);
        this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
        foundDashboard = this.dashboardService.findDashboardById(this.tenantId, savedDashboard.getId());
        Assert.assertNull((Object)foundDashboard);
    }

    @Test
    public void testFindDashboardsByTenantId() {
        ArrayList<DashboardInfo> dashboards = new ArrayList<DashboardInfo>();
        for (int i = 0; i < 165; ++i) {
            Dashboard dashboard = new Dashboard();
            dashboard.setTenantId(this.tenantId);
            dashboard.setTitle("Dashboard" + i);
            dashboards.add(new DashboardInfo((DashboardInfo)this.dashboardService.saveDashboard(dashboard)));
        }
        ArrayList loadedDashboards = new ArrayList();
        PageLink pageLink = new PageLink(16);
        PageData pageData = null;
        do {
            pageData = this.dashboardService.findDashboardsByTenantId(this.tenantId, pageLink);
            loadedDashboards.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(dashboards, this.idComparator);
        Collections.sort(loadedDashboards, this.idComparator);
        Assert.assertEquals(dashboards, loadedDashboards);
        this.dashboardService.deleteDashboardsByTenantId(this.tenantId);
        pageLink = new PageLink(31);
        pageData = this.dashboardService.findDashboardsByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindMobileDashboardsByTenantId() {
        PageData pageData;
        ArrayList<DashboardInfo> mobileDashboards = new ArrayList<DashboardInfo>();
        for (int i = 0; i < 165; ++i) {
            Dashboard dashboard = new Dashboard();
            dashboard.setTenantId(this.tenantId);
            dashboard.setTitle("Dashboard" + i);
            dashboard.setMobileHide(i % 2 == 0);
            if (!dashboard.isMobileHide()) {
                dashboard.setMobileOrder(i % 4 == 0 ? Integer.valueOf((int)(Math.random() * 100.0)) : null);
            }
            Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
            if (dashboard.isMobileHide()) continue;
            mobileDashboards.add(new DashboardInfo((DashboardInfo)savedDashboard));
        }
        ArrayList loadedMobileDashboards = new ArrayList();
        PageLink pageLink = new PageLink(16, 0, null, new SortOrder("title", SortOrder.Direction.ASC));
        do {
            pageData = this.dashboardService.findMobileDashboardsByTenantId(this.tenantId, pageLink);
            loadedMobileDashboards.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(mobileDashboards, (o1, o2) -> {
            Integer order1 = o1.getMobileOrder();
            Integer order2 = o2.getMobileOrder();
            if (order1 == null && order2 == null) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
            if (order1 == null) {
                return 1;
            }
            if (order2 == null) {
                return -1;
            }
            return order1 - order2;
        });
        Assert.assertEquals(mobileDashboards, loadedMobileDashboards);
        this.dashboardService.deleteDashboardsByTenantId(this.tenantId);
        pageLink = new PageLink(31);
        pageData = this.dashboardService.findMobileDashboardsByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindDashboardsByTenantIdAndTitle() {
        String title1 = "Dashboard title 1";
        ArrayList<DashboardInfo> dashboardsTitle1 = new ArrayList<DashboardInfo>();
        for (int i = 0; i < 123; ++i) {
            Dashboard dashboard = new Dashboard();
            dashboard.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 17.0)));
            Object title = title1 + suffix;
            title = i % 2 == 0 ? ((String)title).toLowerCase() : ((String)title).toUpperCase();
            dashboard.setTitle((String)title);
            dashboardsTitle1.add(new DashboardInfo((DashboardInfo)this.dashboardService.saveDashboard(dashboard)));
        }
        String title2 = "Dashboard title 2";
        ArrayList<DashboardInfo> dashboardsTitle2 = new ArrayList<DashboardInfo>();
        for (int i = 0; i < 193; ++i) {
            Dashboard dashboard = new Dashboard();
            dashboard.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(Math.random() * 15.0)));
            Object title = title2 + suffix;
            title = i % 2 == 0 ? ((String)title).toLowerCase() : ((String)title).toUpperCase();
            dashboard.setTitle((String)title);
            dashboardsTitle2.add(new DashboardInfo((DashboardInfo)this.dashboardService.saveDashboard(dashboard)));
        }
        ArrayList loadedDashboardsTitle1 = new ArrayList();
        PageLink pageLink = new PageLink(19, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.dashboardService.findDashboardsByTenantId(this.tenantId, pageLink);
            loadedDashboardsTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(dashboardsTitle1, this.idComparator);
        Collections.sort(loadedDashboardsTitle1, this.idComparator);
        Assert.assertEquals(dashboardsTitle1, loadedDashboardsTitle1);
        ArrayList loadedDashboardsTitle2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.dashboardService.findDashboardsByTenantId(this.tenantId, pageLink);
            loadedDashboardsTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(dashboardsTitle2, this.idComparator);
        Collections.sort(loadedDashboardsTitle2, this.idComparator);
        Assert.assertEquals(dashboardsTitle2, loadedDashboardsTitle2);
        for (DashboardInfo dashboard : loadedDashboardsTitle1) {
            this.dashboardService.deleteDashboard(this.tenantId, dashboard.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.dashboardService.findDashboardsByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (DashboardInfo dashboard : loadedDashboardsTitle2) {
            this.dashboardService.deleteDashboard(this.tenantId, dashboard.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.dashboardService.findDashboardsByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindDashboardsByTenantIdAndCustomerId() throws ExecutionException, InterruptedException {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        ArrayList<DashboardInfo> dashboards = new ArrayList<DashboardInfo>();
        for (int i = 0; i < 223; ++i) {
            Dashboard dashboard = new Dashboard();
            dashboard.setTenantId(this.tenantId);
            dashboard.setTitle("Dashboard" + i);
            dashboard = this.dashboardService.saveDashboard(dashboard);
            dashboards.add(new DashboardInfo((DashboardInfo)this.dashboardService.assignDashboardToCustomer(this.tenantId, dashboard.getId(), customerId)));
        }
        ArrayList loadedDashboards = new ArrayList();
        PageLink pageLink = new PageLink(23);
        PageData pageData = null;
        do {
            pageData = this.dashboardService.findDashboardsByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedDashboards.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(dashboards, this.idComparator);
        Collections.sort(loadedDashboards, this.idComparator);
        Assert.assertEquals(dashboards, loadedDashboards);
        this.dashboardService.unassignCustomerDashboards(this.tenantId, customerId);
        pageLink = new PageLink(42);
        pageData = this.dashboardService.findDashboardsByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testAssignDashboardToNonExistentEdge() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("My dashboard");
        dashboard.setTenantId(this.tenantId);
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.assignDashboardToEdge(this.tenantId, savedDashboard.getId(), new EdgeId(Uuids.timeBased())));
        }
        finally {
            this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignDashboardToEdgeFromDifferentTenant() {
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("My dashboard");
        dashboard.setTenantId(this.tenantId);
        Dashboard savedDashboard = this.dashboardService.saveDashboard(dashboard);
        Tenant tenant = new Tenant();
        tenant.setTitle("Test different tenant [edge]");
        tenant = this.tenantService.saveTenant(tenant);
        Edge edge = new Edge();
        edge.setTenantId(tenant.getId());
        edge.setType("default");
        edge.setName("Test different edge");
        edge.setType("default");
        edge.setSecret(StringUtils.randomAlphanumeric((int)20));
        edge.setRoutingKey(StringUtils.randomAlphanumeric((int)20));
        Edge savedEdge = this.edgeService.saveEdge(edge);
        try {
            Assertions.assertThrows(DataValidationException.class, () -> this.dashboardService.assignDashboardToEdge(this.tenantId, savedDashboard.getId(), savedEdge.getId()));
        }
        finally {
            this.dashboardService.deleteDashboard(this.tenantId, savedDashboard.getId());
            this.tenantService.deleteTenant(tenant.getId());
        }
    }
}

