/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.cf.configuration.SimpleCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class CustomerServiceTest
extends AbstractServiceTest {
    @Autowired
    CustomerService customerService;
    @Autowired
    CalculatedFieldService calculatedFieldService;
    @Autowired
    AssetService assetService;
    static final int TIMEOUT = 30;
    ListeningExecutorService executor;

    @Before
    public void before() {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)8, this.getClass()));
    }

    @After
    public void after() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSaveCustomer() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Assert.assertNotNull((Object)savedCustomer);
        Assert.assertNotNull((Object)savedCustomer.getId());
        Assert.assertTrue((savedCustomer.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)customer.getTenantId(), (Object)savedCustomer.getTenantId());
        Assert.assertEquals((Object)customer.getTitle(), (Object)savedCustomer.getTitle());
        savedCustomer.setTitle("My new customer");
        this.customerService.saveCustomer(savedCustomer);
        Customer foundCustomer = this.customerService.findCustomerById(this.tenantId, savedCustomer.getId());
        Assert.assertEquals((Object)foundCustomer.getTitle(), (Object)savedCustomer.getTitle());
        this.customerService.deleteCustomer(this.tenantId, savedCustomer.getId());
    }

    @Test
    public void testFindCustomerById() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Customer foundCustomer = this.customerService.findCustomerById(this.tenantId, savedCustomer.getId());
        Assert.assertNotNull((Object)foundCustomer);
        Assert.assertEquals((Object)savedCustomer, (Object)foundCustomer);
        this.customerService.deleteCustomer(this.tenantId, savedCustomer.getId());
    }

    @Test
    public void testSaveCustomerWithEmptyTitle() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.customerService.saveCustomer(customer));
    }

    @Test
    public void testSaveCustomerWithEmptyTenant() {
        Customer customer = new Customer();
        customer.setTitle("My customer");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.customerService.saveCustomer(customer));
    }

    @Test
    public void testSaveCustomerWithInvalidTenant() {
        Customer customer = new Customer();
        customer.setTitle("My customer");
        customer.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.customerService.saveCustomer(customer));
    }

    @Test
    public void testSaveCustomerWithInvalidEmail() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        customer.setEmail("invalid@mail");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.customerService.saveCustomer(customer));
    }

    @Test
    public void testDeleteCustomer() {
        Customer customer = new Customer();
        customer.setTitle("My customer");
        customer.setTenantId(this.tenantId);
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        this.customerService.deleteCustomer(this.tenantId, savedCustomer.getId());
        Customer foundCustomer = this.customerService.findCustomerById(this.tenantId, savedCustomer.getId());
        Assert.assertNull((Object)foundCustomer);
    }

    @Test
    public void testFindCustomersByTenantId() throws Exception {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(135);
        for (int i = 0; i < 135; ++i) {
            Customer customer = new Customer();
            customer.setTenantId(this.tenantId);
            customer.setTitle("Customer" + i);
            futures.add(this.executor.submit(() -> this.customerService.saveCustomer(customer)));
        }
        List customers = (List)Futures.allAsList(futures).get(30L, TimeUnit.SECONDS);
        ArrayList loadedCustomers = new ArrayList(135);
        PageLink pageLink = new PageLink(23);
        PageData pageData = null;
        do {
            pageData = this.customerService.findCustomersByTenantId(this.tenantId, pageLink);
            loadedCustomers.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Assertions.assertThat((List)customers).containsExactlyInAnyOrderElementsOf(loadedCustomers);
        this.customerService.deleteCustomersByTenantId(this.tenantId);
        pageLink = new PageLink(33);
        pageData = this.customerService.findCustomersByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindCustomersByTenantIdAndTitleAsTextSearch() throws Exception {
        String title1 = "Customer title 1";
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(143);
        for (int i = 0; i < 143; ++i) {
            Customer customer = new Customer();
            customer.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(5.0 + Math.random() * 10.0)));
            Object title = title1 + suffix;
            title = i % 2 == 0 ? ((String)title).toLowerCase() : ((String)title).toUpperCase();
            customer.setTitle((String)title);
            futures.add(this.executor.submit(() -> this.customerService.saveCustomer(customer)));
        }
        List customersTitle1 = (List)Futures.allAsList(futures).get(30L, TimeUnit.SECONDS);
        String title2 = "Customer title 2";
        futures = new ArrayList(175);
        for (int i = 0; i < 175; ++i) {
            Customer customer = new Customer();
            customer.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)((int)(5.0 + Math.random() * 10.0)));
            Object title = title2 + suffix;
            title = i % 2 == 0 ? ((String)title).toLowerCase() : ((String)title).toUpperCase();
            customer.setTitle((String)title);
            futures.add(this.executor.submit(() -> this.customerService.saveCustomer(customer)));
        }
        List customersTitle2 = (List)Futures.allAsList(futures).get(30L, TimeUnit.SECONDS);
        ArrayList loadedCustomersTitle1 = new ArrayList(143);
        PageLink pageLink = new PageLink(15, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.customerService.findCustomersByTenantId(this.tenantId, pageLink);
            loadedCustomersTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        ((ListAssert)Assertions.assertThat((List)customersTitle1).as(title1, new Object[0])).containsExactlyInAnyOrderElementsOf(loadedCustomersTitle1);
        ArrayList loadedCustomersTitle2 = new ArrayList(175);
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.customerService.findCustomersByTenantId(this.tenantId, pageLink);
            loadedCustomersTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        ((ListAssert)Assertions.assertThat((List)customersTitle2).as(title2, new Object[0])).containsExactlyInAnyOrderElementsOf(loadedCustomersTitle2);
        ArrayList<ListenableFuture> deleteFutures = new ArrayList<ListenableFuture>(143);
        for (Customer customer : loadedCustomersTitle1) {
            deleteFutures.add(this.executor.submit(() -> {
                this.customerService.deleteCustomer(this.tenantId, customer.getId());
                return null;
            }));
        }
        Futures.allAsList(deleteFutures).get(30L, TimeUnit.SECONDS);
        pageLink = new PageLink(4, 0, title1);
        pageData = this.customerService.findCustomersByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        deleteFutures = new ArrayList(175);
        for (Customer customer : loadedCustomersTitle2) {
            deleteFutures.add(this.executor.submit(() -> {
                this.customerService.deleteCustomer(this.tenantId, customer.getId());
                return null;
            }));
        }
        Futures.allAsList(deleteFutures).get(30L, TimeUnit.SECONDS);
        pageLink = new PageLink(4, 0, title2);
        pageData = this.customerService.findCustomersByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindCustomerByTitle() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Assert.assertNotNull((Object)savedCustomer);
        Assert.assertNotNull((Object)savedCustomer.getId());
        Assert.assertTrue((savedCustomer.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)customer.getTenantId(), (Object)savedCustomer.getTenantId());
        Assert.assertEquals((Object)customer.getTitle(), (Object)savedCustomer.getTitle());
        Optional foundCustomerOpt = this.customerService.findCustomerByTenantIdAndTitle(this.tenantId, savedCustomer.getTitle());
        Assert.assertTrue((boolean)foundCustomerOpt.isPresent());
        Assert.assertEquals((Object)((Customer)foundCustomerOpt.get()).getTitle(), (Object)savedCustomer.getTitle());
        this.customerService.deleteCustomer(this.tenantId, savedCustomer.getId());
    }

    @Test
    public void testSaveCustomerWithExistingTitle() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Assert.assertNotNull((Object)savedCustomer);
        Assert.assertNotNull((Object)savedCustomer.getId());
        Assert.assertTrue((savedCustomer.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)customer.getTenantId(), (Object)savedCustomer.getTenantId());
        Assert.assertEquals((Object)customer.getTitle(), (Object)savedCustomer.getTitle());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.customerService.saveCustomer(customer)).isInstanceOf(DataValidationException.class)).hasMessage("Customer with such title already exists!");
        this.customerService.deleteCustomer(this.tenantId, savedCustomer.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindOrCreatePublicCustomer_Concurrency() throws Exception {
        CountDownLatch allThreadsReadyLatch = new CountDownLatch(2);
        Customer[] customers = new Customer[2];
        ExecutorService executor = null;
        try {
            executor = Executors.newFixedThreadPool(2);
            int i = 0;
            while (i < 2) {
                int threadIndex = i++;
                executor.submit(() -> {
                    allThreadsReadyLatch.countDown();
                    try {
                        allThreadsReadyLatch.await();
                        customers[threadIndex] = this.customerService.findOrCreatePublicCustomer(this.tenantId);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
            executor.shutdown();
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(executor::isTerminated);
            Customer firstCustomer = customers[0];
            Customer secondCustomer = customers[1];
            Assertions.assertThat((Object)firstCustomer).isNotNull();
            Assertions.assertThat((Object)secondCustomer).isNotNull();
            Assertions.assertThat((Object)firstCustomer).isEqualTo((Object)secondCustomer);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    @Test
    public void testDeleteCustomerIfReferencedInCalculatedField() {
        Customer customer = new Customer();
        customer.setTenantId(this.tenantId);
        customer.setTitle("My customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("My asset");
        asset.setType("default");
        Asset savedAsset = this.assetService.saveAsset(asset);
        CalculatedField calculatedField = new CalculatedField();
        calculatedField.setTenantId(this.tenantId);
        calculatedField.setName("Test CF");
        calculatedField.setType(CalculatedFieldType.SIMPLE);
        calculatedField.setEntityId((EntityId)savedAsset.getId());
        SimpleCalculatedFieldConfiguration config = new SimpleCalculatedFieldConfiguration();
        Argument argument = new Argument();
        argument.setRefEntityId((EntityId)savedCustomer.getId());
        ReferencedEntityKey refEntityKey = new ReferencedEntityKey("temperature", ArgumentType.TS_LATEST, null);
        argument.setRefEntityKey(refEntityKey);
        config.setArguments(Map.of("T", argument));
        config.setExpression("T - (100 - H) / 5");
        Output output = new Output();
        output.setName("output");
        output.setType(OutputType.TIME_SERIES);
        config.setOutput(output);
        calculatedField.setConfiguration((CalculatedFieldConfiguration)config);
        CalculatedField savedCalculatedField = this.calculatedFieldService.save(calculatedField);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.customerService.deleteCustomer(this.tenantId, savedCustomer.getId())).isInstanceOf(DataValidationException.class)).hasMessage("Can't delete customer that is referenced in calculated fields!");
        this.calculatedFieldService.deleteCalculatedField(this.tenantId, savedCalculatedField.getId());
    }
}

