/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.cf.configuration.SimpleCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class CalculatedFieldServiceTest
extends AbstractServiceTest {
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private DeviceService deviceService;
    private ListeningExecutorService executor;

    @Before
    public void before() {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)8, this.getClass()));
    }

    @After
    public void after() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSaveCalculatedField() {
        Device device = this.createTestDevice();
        CalculatedField calculatedField = this.getCalculatedField((EntityId)device.getId(), (EntityId)device.getId());
        CalculatedField savedCalculatedField = this.calculatedFieldService.save(calculatedField);
        Assertions.assertThat((Object)savedCalculatedField).isNotNull();
        Assertions.assertThat((Object)savedCalculatedField.getId()).isNotNull();
        Assertions.assertThat((long)savedCalculatedField.getCreatedTime()).isGreaterThan(0L);
        Assertions.assertThat((Object)savedCalculatedField.getTenantId()).isEqualTo((Object)calculatedField.getTenantId());
        Assertions.assertThat((Object)savedCalculatedField.getEntityId()).isEqualTo((Object)calculatedField.getEntityId());
        Assertions.assertThat((Comparable)savedCalculatedField.getType()).isEqualTo((Object)calculatedField.getType());
        Assertions.assertThat((String)savedCalculatedField.getName()).isEqualTo(calculatedField.getName());
        Assertions.assertThat((Object)savedCalculatedField.getConfiguration()).isEqualTo((Object)calculatedField.getConfiguration());
        Assertions.assertThat((Long)savedCalculatedField.getVersion()).isEqualTo(1L);
        savedCalculatedField.setName("Test CF");
        CalculatedField updatedCalculatedField = this.calculatedFieldService.save(savedCalculatedField);
        Assertions.assertThat((String)updatedCalculatedField.getName()).isEqualTo(savedCalculatedField.getName());
        Assertions.assertThat((Long)updatedCalculatedField.getVersion()).isEqualTo(savedCalculatedField.getVersion() + 1L);
        this.calculatedFieldService.deleteCalculatedField(this.tenantId, savedCalculatedField.getId());
    }

    @Test
    public void testSaveCalculatedFieldWithExistingName() {
        Device device = this.createTestDevice();
        CalculatedField calculatedField = this.getCalculatedField((EntityId)device.getId(), (EntityId)device.getId());
        this.calculatedFieldService.save(calculatedField);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.calculatedFieldService.save(calculatedField)).isInstanceOf(DataValidationException.class)).hasMessage("Calculated Field with such name is already in exists!");
    }

    @Test
    public void testFindCalculatedFieldById() {
        CalculatedField savedCalculatedField = this.saveValidCalculatedField();
        CalculatedField fetchedCalculatedField = this.calculatedFieldService.findById(this.tenantId, savedCalculatedField.getId());
        Assertions.assertThat((Object)fetchedCalculatedField).isEqualTo((Object)savedCalculatedField);
        this.calculatedFieldService.deleteCalculatedField(this.tenantId, savedCalculatedField.getId());
    }

    @Test
    public void testDeleteCalculatedField() {
        CalculatedField savedCalculatedField = this.saveValidCalculatedField();
        this.calculatedFieldService.deleteCalculatedField(this.tenantId, savedCalculatedField.getId());
        Assertions.assertThat((Object)this.calculatedFieldService.findById(this.tenantId, savedCalculatedField.getId())).isNull();
    }

    private CalculatedField saveValidCalculatedField() {
        Device device = this.createTestDevice();
        CalculatedField calculatedField = this.getCalculatedField((EntityId)device.getId(), (EntityId)device.getId());
        return this.calculatedFieldService.save(calculatedField);
    }

    private CalculatedField getCalculatedField(EntityId entityId, EntityId referencedEntityId) {
        CalculatedField calculatedField = new CalculatedField();
        calculatedField.setTenantId(this.tenantId);
        calculatedField.setEntityId(entityId);
        calculatedField.setType(CalculatedFieldType.SIMPLE);
        calculatedField.setName("Test Calculated Field");
        calculatedField.setConfigurationVersion(1);
        calculatedField.setConfiguration(this.getCalculatedFieldConfig(referencedEntityId));
        return calculatedField;
    }

    private CalculatedFieldConfiguration getCalculatedFieldConfig(EntityId referencedEntityId) {
        SimpleCalculatedFieldConfiguration config = new SimpleCalculatedFieldConfiguration();
        Argument argument = new Argument();
        argument.setRefEntityId(referencedEntityId);
        ReferencedEntityKey refEntityKey = new ReferencedEntityKey("temperature", ArgumentType.TS_LATEST, null);
        argument.setRefEntityKey(refEntityKey);
        config.setArguments(Map.of("T", argument));
        config.setExpression("T - (100 - H) / 5");
        Output output = new Output();
        output.setName("output");
        output.setType(OutputType.TIME_SERIES);
        config.setOutput(output);
        return config;
    }

    private Device createTestDevice() {
        Device device = new Device();
        device.setTenantId(this.tenantId);
        device.setName("Test");
        return this.deviceService.saveDevice(device);
    }
}

