/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetInfo;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.cf.configuration.SimpleCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.dao.asset.AssetDao;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class AssetServiceTest
extends AbstractServiceTest {
    @Autowired
    AssetService assetService;
    @Autowired
    AssetDao assetDao;
    @Autowired
    CustomerService customerService;
    @Autowired
    RelationService relationService;
    @Autowired
    private AssetProfileService assetProfileService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    private AbstractServiceTest.IdComparator<Asset> idComparator = new AbstractServiceTest.IdComparator();

    @Test
    public void testSaveAsset() {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("My asset");
        asset.setType("default");
        Asset savedAsset = this.assetService.saveAsset(asset);
        Assert.assertNotNull((Object)savedAsset);
        Assert.assertNotNull((Object)savedAsset.getId());
        Assert.assertTrue((savedAsset.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)asset.getTenantId(), (Object)savedAsset.getTenantId());
        Assert.assertNotNull((Object)savedAsset.getCustomerId());
        Assert.assertEquals((Object)ModelConstants.NULL_UUID, (Object)savedAsset.getCustomerId().getId());
        Assert.assertEquals((Object)asset.getName(), (Object)savedAsset.getName());
        savedAsset.setName("My new asset");
        this.assetService.saveAsset(savedAsset);
        Asset foundAsset = this.assetService.findAssetById(this.tenantId, savedAsset.getId());
        Assert.assertEquals((Object)foundAsset.getName(), (Object)savedAsset.getName());
        this.assetService.deleteAsset(this.tenantId, savedAsset.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotPutInCacheRolledbackAssetProfile() {
        AssetProfile assetProfile = new AssetProfile();
        assetProfile.setName(StringUtils.randomAlphabetic((int)10));
        assetProfile.setTenantId(this.tenantId);
        Asset asset = new Asset();
        asset.setName("My asset" + StringUtils.randomAlphabetic((int)15));
        asset.setType(assetProfile.getName());
        asset.setTenantId(this.tenantId);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.platformTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.assetProfileService.saveAssetProfile(assetProfile);
            this.assetService.saveAsset(asset);
        }
        finally {
            this.platformTransactionManager.rollback(status);
        }
        AssetProfile assetProfileByName = this.assetProfileService.findAssetProfileByName(this.tenantId, assetProfile.getName());
        Assert.assertNull((Object)assetProfileByName);
    }

    @Test
    public void testSaveAssetWithEmptyName() {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setType("default");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetService.saveAsset(asset));
    }

    @Test
    public void testSaveDeviceWithNameContains0x00_thenDataValidationException() {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setType("default");
        asset.setName("F0929906\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetService.saveAsset(asset));
    }

    @Test
    public void testSaveAssetWithEmptyTenant() {
        Asset asset = new Asset();
        asset.setName("My asset");
        asset.setType("default");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetService.saveAsset(asset));
    }

    @Test
    public void testSaveAssetWithInvalidTenant() {
        Asset asset = new Asset();
        asset.setName("My asset");
        asset.setType("default");
        asset.setTenantId(TenantId.fromUUID((UUID)Uuids.timeBased()));
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetService.saveAsset(asset));
    }

    @Test
    public void testAssignAssetToNonExistentCustomer() {
        Asset asset = new Asset();
        asset.setName("My asset");
        asset.setType("default");
        asset.setTenantId(this.tenantId);
        Asset savedAsset = this.assetService.saveAsset(asset);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetService.assignAssetToCustomer(this.tenantId, savedAsset.getId(), new CustomerId(Uuids.timeBased())));
        }
        finally {
            this.assetService.deleteAsset(this.tenantId, savedAsset.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignAssetToCustomerFromDifferentTenant() {
        Asset asset = new Asset();
        asset.setName("My asset");
        asset.setType("default");
        asset.setTenantId(this.tenantId);
        Asset savedAsset = this.assetService.saveAsset(asset);
        Tenant tenant = new Tenant();
        tenant.setTitle("Test different tenant");
        tenant = this.tenantService.saveTenant(tenant);
        Customer customer = new Customer();
        customer.setTenantId(tenant.getId());
        customer.setTitle("Test different customer");
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetService.assignAssetToCustomer(this.tenantId, savedAsset.getId(), savedCustomer.getId()));
        }
        finally {
            this.assetService.deleteAsset(this.tenantId, savedAsset.getId());
            this.tenantService.deleteTenant(tenant.getId());
        }
    }

    @Test
    public void testFindAssetById() {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("My asset");
        asset.setType("default");
        Asset savedAsset = this.assetService.saveAsset(asset);
        Asset foundAsset = this.assetService.findAssetById(this.tenantId, savedAsset.getId());
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((Object)savedAsset, (Object)foundAsset);
        this.assetService.deleteAsset(this.tenantId, savedAsset.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindAssetTypesByTenantId() throws Exception {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        try {
            Asset asset2;
            int i;
            for (i = 0; i < 3; ++i) {
                asset2 = new Asset();
                asset2.setTenantId(this.tenantId);
                asset2.setName("My asset B" + i);
                asset2.setType("typeB");
                assets.add(this.assetService.saveAsset(asset2));
            }
            for (i = 0; i < 7; ++i) {
                asset2 = new Asset();
                asset2.setTenantId(this.tenantId);
                asset2.setName("My asset C" + i);
                asset2.setType("typeC");
                assets.add(this.assetService.saveAsset(asset2));
            }
            for (i = 0; i < 9; ++i) {
                asset2 = new Asset();
                asset2.setTenantId(this.tenantId);
                asset2.setName("My asset A" + i);
                asset2.setType("typeA");
                assets.add(this.assetService.saveAsset(asset2));
            }
            List assetTypes = (List)this.assetService.findAssetTypesByTenantId(this.tenantId).get();
            Assert.assertNotNull((Object)assetTypes);
            Assert.assertEquals((long)3L, (long)assetTypes.size());
            Assert.assertEquals((Object)"typeA", (Object)((EntitySubtype)assetTypes.get(0)).getType());
            Assert.assertEquals((Object)"typeB", (Object)((EntitySubtype)assetTypes.get(1)).getType());
            Assert.assertEquals((Object)"typeC", (Object)((EntitySubtype)assetTypes.get(2)).getType());
        }
        finally {
            assets.forEach(asset -> this.assetService.deleteAsset(this.tenantId, asset.getId()));
        }
    }

    @Test
    public void testDeleteAsset() {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("My asset");
        asset.setType("default");
        Asset savedAsset = this.assetService.saveAsset(asset);
        EntityRelation relation = new EntityRelation((EntityId)this.tenantId, (EntityId)savedAsset.getId(), "Contains");
        this.relationService.saveRelation(this.tenantId, relation);
        Asset foundAsset = this.assetService.findAssetById(this.tenantId, savedAsset.getId());
        Assert.assertNotNull((Object)foundAsset);
        this.assetService.deleteAsset(this.tenantId, savedAsset.getId());
        foundAsset = this.assetService.findAssetById(this.tenantId, savedAsset.getId());
        Assert.assertNull((Object)foundAsset);
        Assert.assertTrue((boolean)this.relationService.findByTo(this.tenantId, (EntityId)savedAsset.getId(), RelationTypeGroup.COMMON).isEmpty());
    }

    @Test
    public void testFindAssetsByTenantId() {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (int i = 0; i < 13; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            asset.setName("Asset" + i);
            asset.setType("default");
            assets.add(this.assetService.saveAsset(asset));
        }
        ArrayList loadedAssets = new ArrayList();
        PageLink pageLink = new PageLink(3);
        PageData pageData = null;
        do {
            pageData = this.assetService.findAssetsByTenantId(this.tenantId, pageLink);
            loadedAssets.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assets, this.idComparator);
        Collections.sort(loadedAssets, this.idComparator);
        Assert.assertEquals(assets, loadedAssets);
        this.assetService.deleteAssetsByTenantId(this.tenantId);
        pageLink = new PageLink(4);
        pageData = this.assetService.findAssetsByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindAssetsByTenantIdAndName() {
        String title1 = "Asset title 1";
        ArrayList<AssetInfo> assetsTitle1 = new ArrayList<AssetInfo>();
        for (int i = 0; i < 13; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType("default");
            assetsTitle1.add(new AssetInfo(this.assetService.saveAsset(asset), null, false, "default"));
        }
        String title2 = "Asset title 2";
        ArrayList<AssetInfo> assetsTitle2 = new ArrayList<AssetInfo>();
        for (int i = 0; i < 17; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType("default");
            assetsTitle2.add(new AssetInfo(this.assetService.saveAsset(asset), null, false, "default"));
        }
        ArrayList loadedAssetsTitle1 = new ArrayList();
        PageLink pageLink = new PageLink(3, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLink);
            loadedAssetsTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsTitle1, this.idComparator);
        Collections.sort(loadedAssetsTitle1, this.idComparator);
        Assert.assertEquals(assetsTitle1, loadedAssetsTitle1);
        ArrayList loadedAssetsTitle2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLink);
            loadedAssetsTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsTitle2, this.idComparator);
        Collections.sort(loadedAssetsTitle2, this.idComparator);
        Assert.assertEquals(assetsTitle2, loadedAssetsTitle2);
        for (Asset asset : loadedAssetsTitle1) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Asset asset : loadedAssetsTitle2) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindAssetsByTenantIdAndType() {
        String title1 = "Asset title 1";
        String type1 = "typeA";
        ArrayList<Asset> assetsType1 = new ArrayList<Asset>();
        for (int i = 0; i < 13; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType(type1);
            assetsType1.add(this.assetService.saveAsset(asset));
        }
        String title2 = "Asset title 2";
        String type2 = "typeB";
        ArrayList<Asset> assetsType2 = new ArrayList<Asset>();
        for (int i = 0; i < 17; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType(type2);
            assetsType2.add(this.assetService.saveAsset(asset));
        }
        ArrayList loadedAssetsType1 = new ArrayList();
        PageLink pageLink = new PageLink(3);
        PageData pageData = null;
        do {
            pageData = this.assetService.findAssetsByTenantIdAndType(this.tenantId, type1, pageLink);
            loadedAssetsType1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsType1, this.idComparator);
        Collections.sort(loadedAssetsType1, this.idComparator);
        Assert.assertEquals(assetsType1, loadedAssetsType1);
        ArrayList loadedAssetsType2 = new ArrayList();
        pageLink = new PageLink(4);
        do {
            pageData = this.assetService.findAssetsByTenantIdAndType(this.tenantId, type2, pageLink);
            loadedAssetsType2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsType2, this.idComparator);
        Collections.sort(loadedAssetsType2, this.idComparator);
        Assert.assertEquals(assetsType2, loadedAssetsType2);
        for (Asset asset : loadedAssetsType1) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4);
        pageData = this.assetService.findAssetsByTenantIdAndType(this.tenantId, type1, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Asset asset : loadedAssetsType2) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4);
        pageData = this.assetService.findAssetsByTenantIdAndType(this.tenantId, type2, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
    }

    @Test
    public void testFindAssetsByTenantIdAndCustomerId() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        ArrayList<AssetInfo> assets = new ArrayList<AssetInfo>();
        for (int i = 0; i < 13; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            asset.setName("Asset" + i);
            asset.setType("default");
            asset = this.assetService.saveAsset(asset);
            assets.add(new AssetInfo(this.assetService.assignAssetToCustomer(this.tenantId, asset.getId(), customerId), customer.getTitle(), customer.isPublic(), "default"));
        }
        ArrayList loadedAssets = new ArrayList();
        PageLink pageLink = new PageLink(3);
        PageData pageData = null;
        do {
            pageData = this.assetService.findAssetInfosByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedAssets.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assets, this.idComparator);
        Collections.sort(loadedAssets, this.idComparator);
        Assert.assertEquals(assets, loadedAssets);
        this.assetService.unassignCustomerAssets(this.tenantId, customerId);
        pageLink = new PageLink(4);
        pageData = this.assetService.findAssetInfosByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertTrue((boolean)pageData.getData().isEmpty());
    }

    @Test
    public void testFindAssetsByTenantIdCustomerIdAndName() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        String title1 = "Asset title 1";
        ArrayList<Asset> assetsTitle1 = new ArrayList<Asset>();
        for (int i = 0; i < 17; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType("default");
            asset = this.assetService.saveAsset(asset);
            assetsTitle1.add(this.assetService.assignAssetToCustomer(this.tenantId, asset.getId(), customerId));
        }
        String title2 = "Asset title 2";
        ArrayList<Asset> assetsTitle2 = new ArrayList<Asset>();
        for (int i = 0; i < 13; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType("default");
            asset = this.assetService.saveAsset(asset);
            assetsTitle2.add(this.assetService.assignAssetToCustomer(this.tenantId, asset.getId(), customerId));
        }
        ArrayList loadedAssetsTitle1 = new ArrayList();
        PageLink pageLink = new PageLink(3, 0, title1);
        PageData pageData = null;
        do {
            pageData = this.assetService.findAssetsByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedAssetsTitle1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsTitle1, this.idComparator);
        Collections.sort(loadedAssetsTitle1, this.idComparator);
        Assert.assertEquals(assetsTitle1, loadedAssetsTitle1);
        ArrayList loadedAssetsTitle2 = new ArrayList();
        pageLink = new PageLink(4, 0, title2);
        do {
            pageData = this.assetService.findAssetsByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
            loadedAssetsTitle2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsTitle2, this.idComparator);
        Collections.sort(loadedAssetsTitle2, this.idComparator);
        Assert.assertEquals(assetsTitle2, loadedAssetsTitle2);
        for (Asset asset : loadedAssetsTitle1) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4, 0, title1);
        pageData = this.assetService.findAssetsByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Asset asset : loadedAssetsTitle2) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4, 0, title2);
        pageData = this.assetService.findAssetsByTenantIdAndCustomerId(this.tenantId, customerId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        this.customerService.deleteCustomer(this.tenantId, customerId);
    }

    @Test
    public void testFindAssetsByTenantIdCustomerIdAndType() {
        Customer customer = new Customer();
        customer.setTitle("Test customer");
        customer.setTenantId(this.tenantId);
        customer = this.customerService.saveCustomer(customer);
        CustomerId customerId = customer.getId();
        String title1 = "Asset title 1";
        String type1 = "typeC";
        ArrayList<Asset> assetsType1 = new ArrayList<Asset>();
        for (int i = 0; i < 17; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title1 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType(type1);
            asset = this.assetService.saveAsset(asset);
            assetsType1.add(this.assetService.assignAssetToCustomer(this.tenantId, asset.getId(), customerId));
        }
        String title2 = "Asset title 2";
        String type2 = "typeD";
        ArrayList<Asset> assetsType2 = new ArrayList<Asset>();
        for (int i = 0; i < 13; ++i) {
            Asset asset = new Asset();
            asset.setTenantId(this.tenantId);
            String suffix = StringUtils.randomAlphanumeric((int)15);
            Object name = title2 + suffix;
            name = i % 2 == 0 ? ((String)name).toLowerCase() : ((String)name).toUpperCase();
            asset.setName((String)name);
            asset.setType(type2);
            asset = this.assetService.saveAsset(asset);
            assetsType2.add(this.assetService.assignAssetToCustomer(this.tenantId, asset.getId(), customerId));
        }
        ArrayList loadedAssetsType1 = new ArrayList();
        PageLink pageLink = new PageLink(3);
        PageData pageData = null;
        do {
            pageData = this.assetService.findAssetsByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type1, pageLink);
            loadedAssetsType1.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsType1, this.idComparator);
        Collections.sort(loadedAssetsType1, this.idComparator);
        Assert.assertEquals(assetsType1, loadedAssetsType1);
        ArrayList loadedAssetsType2 = new ArrayList();
        pageLink = new PageLink(4);
        do {
            pageData = this.assetService.findAssetsByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type2, pageLink);
            loadedAssetsType2.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetsType2, this.idComparator);
        Collections.sort(loadedAssetsType2, this.idComparator);
        Assert.assertEquals(assetsType2, loadedAssetsType2);
        for (Asset asset : loadedAssetsType1) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4);
        pageData = this.assetService.findAssetsByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type1, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        for (Asset asset : loadedAssetsType2) {
            this.assetService.deleteAsset(this.tenantId, asset.getId());
        }
        pageLink = new PageLink(4);
        pageData = this.assetService.findAssetsByTenantIdAndCustomerIdAndType(this.tenantId, customerId, type2, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)0L, (long)pageData.getData().size());
        this.customerService.deleteCustomer(this.tenantId, customerId);
    }

    @Test
    public void testCleanCacheIfAssetRenamed() {
        String assetNameBeforeRename = StringUtils.randomAlphanumeric((int)15);
        String assetNameAfterRename = StringUtils.randomAlphanumeric((int)15);
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName(assetNameBeforeRename);
        asset.setType("default");
        this.assetService.saveAsset(asset);
        Asset savedAsset = this.assetService.findAssetByTenantIdAndName(this.tenantId, assetNameBeforeRename);
        savedAsset.setName(assetNameAfterRename);
        this.assetService.saveAsset(savedAsset);
        Asset renamedAsset = this.assetService.findAssetByTenantIdAndName(this.tenantId, assetNameBeforeRename);
        Assert.assertNull((String)"Can't find asset by name in cache if it was renamed", (Object)renamedAsset);
        this.assetService.deleteAsset(this.tenantId, savedAsset.getId());
    }

    @Test
    public void testFindAssetInfoByTenantId() {
        Customer customer = new Customer();
        customer.setTitle("Customer X");
        customer.setTenantId(this.tenantId);
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("default");
        asset.setType("default");
        asset.setLabel("label");
        asset.setCustomerId(savedCustomer.getId());
        Asset savedAsset = this.assetService.saveAsset(asset);
        PageLink pageLinkWithLabel = new PageLink(100, 0, "label");
        List assetInfosWithLabel = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLinkWithLabel).getData();
        Assert.assertFalse((boolean)assetInfosWithLabel.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithLabel.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getLabel().equals(savedAsset.getLabel())));
        PageLink pageLinkWithCustomer = new PageLink(100, 0, savedCustomer.getTitle());
        List assetInfosWithCustomer = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLinkWithCustomer).getData();
        Assert.assertFalse((boolean)assetInfosWithCustomer.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithCustomer.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getCustomerId().equals((Object)savedCustomer.getId()) && d.getCustomerTitle().equals(savedCustomer.getTitle())));
        PageLink pageLinkWithType = new PageLink(100, 0, asset.getType());
        List assetInfosWithType = this.assetService.findAssetInfosByTenantId(this.tenantId, pageLinkWithType).getData();
        Assert.assertFalse((boolean)assetInfosWithType.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithType.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getType().equals(asset.getType())));
    }

    @Test
    public void testFindAssetInfoByTenantIdAndType() {
        Customer customer = new Customer();
        customer.setTitle("Customer X");
        customer.setTenantId(this.tenantId);
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("default");
        asset.setType("default");
        asset.setLabel("label");
        asset.setCustomerId(savedCustomer.getId());
        Asset savedAsset = this.assetService.saveAsset(asset);
        PageLink pageLinkWithLabel = new PageLink(100, 0, "label");
        List assetInfosWithLabel = this.assetService.findAssetInfosByTenantIdAndType(this.tenantId, asset.getType(), pageLinkWithLabel).getData();
        Assert.assertFalse((boolean)assetInfosWithLabel.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithLabel.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getAssetProfileName().equals(savedAsset.getType()) && d.getLabel().equals(savedAsset.getLabel())));
        PageLink pageLinkWithCustomer = new PageLink(100, 0, savedCustomer.getTitle());
        List assetInfosWithCustomer = this.assetService.findAssetInfosByTenantIdAndType(this.tenantId, asset.getType(), pageLinkWithCustomer).getData();
        Assert.assertFalse((boolean)assetInfosWithCustomer.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithCustomer.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getAssetProfileName().equals(savedAsset.getType()) && d.getCustomerId().equals((Object)savedCustomer.getId()) && d.getCustomerTitle().equals(savedCustomer.getTitle())));
    }

    @Test
    public void testFindAssetInfoByTenantIdAndAssetProfileId() {
        Customer customer = new Customer();
        customer.setTitle("Customer X");
        customer.setTenantId(this.tenantId);
        Customer savedCustomer = this.customerService.saveCustomer(customer);
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("default");
        asset.setLabel("label");
        asset.setCustomerId(savedCustomer.getId());
        Asset savedAsset = this.assetService.saveAsset(asset);
        PageLink pageLinkWithLabel = new PageLink(100, 0, "label");
        List assetInfosWithLabel = this.assetService.findAssetInfosByTenantIdAndAssetProfileId(this.tenantId, savedAsset.getAssetProfileId(), pageLinkWithLabel).getData();
        Assert.assertFalse((boolean)assetInfosWithLabel.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithLabel.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getAssetProfileId().equals((Object)savedAsset.getAssetProfileId()) && d.getLabel().equals(savedAsset.getLabel())));
        PageLink pageLinkWithCustomer = new PageLink(100, 0, savedCustomer.getTitle());
        List assetInfosWithCustomer = this.assetService.findAssetInfosByTenantIdAndAssetProfileId(this.tenantId, savedAsset.getAssetProfileId(), pageLinkWithCustomer).getData();
        Assert.assertFalse((boolean)assetInfosWithCustomer.isEmpty());
        Assert.assertTrue((boolean)assetInfosWithCustomer.stream().anyMatch(d -> d.getId().equals((Object)savedAsset.getId()) && d.getTenantId().equals((Object)this.tenantId) && d.getAssetProfileId().equals((Object)savedAsset.getAssetProfileId()) && d.getCustomerId().equals((Object)savedCustomer.getId()) && d.getCustomerTitle().equals(savedCustomer.getTitle())));
    }

    @Test
    public void testDeleteAssetIfReferencedInCalculatedField() {
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("My asset");
        asset.setType("default");
        Asset savedAsset = this.assetService.saveAsset(asset);
        Asset assetWithCf = new Asset();
        assetWithCf.setTenantId(this.tenantId);
        assetWithCf.setName("Asset with CF");
        assetWithCf.setType("default");
        Asset savedAssetWithCf = this.assetService.saveAsset(assetWithCf);
        CalculatedField calculatedField = new CalculatedField();
        calculatedField.setTenantId(this.tenantId);
        calculatedField.setName("Test CF");
        calculatedField.setType(CalculatedFieldType.SIMPLE);
        calculatedField.setEntityId((EntityId)savedAssetWithCf.getId());
        SimpleCalculatedFieldConfiguration config = new SimpleCalculatedFieldConfiguration();
        Argument argument = new Argument();
        argument.setRefEntityId((EntityId)savedAsset.getId());
        ReferencedEntityKey refEntityKey = new ReferencedEntityKey("temperature", ArgumentType.TS_LATEST, null);
        argument.setRefEntityKey(refEntityKey);
        config.setArguments(Map.of("T", argument));
        config.setExpression("T - (100 - H) / 5");
        Output output = new Output();
        output.setName("output");
        output.setType(OutputType.TIME_SERIES);
        config.setOutput(output);
        calculatedField.setConfiguration((CalculatedFieldConfiguration)config);
        CalculatedField savedCalculatedField = this.calculatedFieldService.save(calculatedField);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assetService.deleteAsset(this.tenantId, savedAsset.getId())).isInstanceOf(DataValidationException.class)).hasMessage("Can't delete asset that has entity views or is referenced in calculated fields!");
        this.calculatedFieldService.deleteCalculatedField(this.tenantId, savedCalculatedField.getId());
    }
}

