/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.asset.AssetProfileInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;

@DaoSqlTest
public class AssetProfileServiceTest
extends AbstractServiceTest {
    private AbstractServiceTest.IdComparator<AssetProfile> idComparator = new AbstractServiceTest.IdComparator();
    private AbstractServiceTest.IdComparator<AssetProfileInfo> assetProfileInfoIdComparator = new AbstractServiceTest.IdComparator();
    @Autowired
    AssetProfileService assetProfileService;
    @Autowired
    AssetService assetService;

    @Test
    public void testSaveAssetProfile() {
        AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile");
        AssetProfile savedAssetProfile = this.assetProfileService.saveAssetProfile(assetProfile);
        Assert.assertNotNull((Object)savedAssetProfile);
        Assert.assertNotNull((Object)savedAssetProfile.getId());
        Assert.assertTrue((savedAssetProfile.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)assetProfile.getName(), (Object)savedAssetProfile.getName());
        Assert.assertEquals((Object)assetProfile.getDescription(), (Object)savedAssetProfile.getDescription());
        Assert.assertEquals((Object)assetProfile.isDefault(), (Object)savedAssetProfile.isDefault());
        Assert.assertEquals((Object)assetProfile.getDefaultRuleChainId(), (Object)savedAssetProfile.getDefaultRuleChainId());
        savedAssetProfile.setName("New asset profile");
        this.assetProfileService.saveAssetProfile(savedAssetProfile);
        AssetProfile foundAssetProfile = this.assetProfileService.findAssetProfileById(this.tenantId, savedAssetProfile.getId());
        Assert.assertEquals((Object)savedAssetProfile.getName(), (Object)foundAssetProfile.getName());
    }

    @Test
    public void testFindAssetProfileById() {
        AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile");
        AssetProfile savedAssetProfile = this.assetProfileService.saveAssetProfile(assetProfile);
        AssetProfile foundAssetProfile = this.assetProfileService.findAssetProfileById(this.tenantId, savedAssetProfile.getId());
        Assert.assertNotNull((Object)foundAssetProfile);
        Assert.assertEquals((Object)savedAssetProfile, (Object)foundAssetProfile);
    }

    @Test
    public void testFindAssetProfileInfoById() {
        AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile");
        AssetProfile savedAssetProfile = this.assetProfileService.saveAssetProfile(assetProfile);
        AssetProfileInfo foundAssetProfileInfo = this.assetProfileService.findAssetProfileInfoById(this.tenantId, savedAssetProfile.getId());
        Assert.assertNotNull((Object)foundAssetProfileInfo);
        Assert.assertEquals((Object)savedAssetProfile.getId(), (Object)foundAssetProfileInfo.getId());
        Assert.assertEquals((Object)savedAssetProfile.getName(), (Object)foundAssetProfileInfo.getName());
    }

    @Test
    public void testFindDefaultAssetProfile() {
        AssetProfile foundDefaultAssetProfile = this.assetProfileService.findDefaultAssetProfile(this.tenantId);
        Assert.assertNotNull((Object)foundDefaultAssetProfile);
        Assert.assertNotNull((Object)foundDefaultAssetProfile.getId());
        Assert.assertNotNull((Object)foundDefaultAssetProfile.getName());
    }

    @Test
    public void testFindDefaultAssetProfileInfo() {
        AssetProfileInfo foundDefaultAssetProfileInfo = this.assetProfileService.findDefaultAssetProfileInfo(this.tenantId);
        Assert.assertNotNull((Object)foundDefaultAssetProfileInfo);
        Assert.assertNotNull((Object)foundDefaultAssetProfileInfo.getId());
        Assert.assertNotNull((Object)foundDefaultAssetProfileInfo.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindOrCreateAssetProfile() throws ExecutionException, InterruptedException {
        ListeningExecutorService testExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(100, (ThreadFactory)ThingsBoardThreadFactory.forName((String)(this.getClass().getSimpleName() + "-test-scope"))));
        try {
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 50; ++i) {
                futures.add(testExecutor.submit(() -> this.assetProfileService.findOrCreateAssetProfile(this.tenantId, "Asset Profile 1")));
                futures.add(testExecutor.submit(() -> this.assetProfileService.findOrCreateAssetProfile(this.tenantId, "Asset Profile 2")));
            }
            List assetProfiles = (List)Futures.allAsList(futures).get();
            assetProfiles.forEach(Assert::assertNotNull);
        }
        finally {
            testExecutor.shutdownNow();
        }
    }

    @Test
    public void testSetDefaultAssetProfile() {
        AssetProfile assetProfile1 = this.createAssetProfile(this.tenantId, "Asset Profile 1");
        AssetProfile assetProfile2 = this.createAssetProfile(this.tenantId, "Asset Profile 2");
        AssetProfile savedAssetProfile1 = this.assetProfileService.saveAssetProfile(assetProfile1);
        AssetProfile savedAssetProfile2 = this.assetProfileService.saveAssetProfile(assetProfile2);
        boolean result = this.assetProfileService.setDefaultAssetProfile(this.tenantId, savedAssetProfile1.getId());
        Assert.assertTrue((boolean)result);
        AssetProfile defaultAssetProfile = this.assetProfileService.findDefaultAssetProfile(this.tenantId);
        Assert.assertNotNull((Object)defaultAssetProfile);
        Assert.assertEquals((Object)savedAssetProfile1.getId(), (Object)defaultAssetProfile.getId());
        result = this.assetProfileService.setDefaultAssetProfile(this.tenantId, savedAssetProfile2.getId());
        Assert.assertTrue((boolean)result);
        defaultAssetProfile = this.assetProfileService.findDefaultAssetProfile(this.tenantId);
        Assert.assertNotNull((Object)defaultAssetProfile);
        Assert.assertEquals((Object)savedAssetProfile2.getId(), (Object)defaultAssetProfile.getId());
    }

    @Test
    public void testSaveAssetProfileWithEmptyName() {
        AssetProfile assetProfile = new AssetProfile();
        assetProfile.setTenantId(this.tenantId);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetProfileService.saveAssetProfile(assetProfile));
    }

    @Test
    public void testSaveAssetProfileWithSameName() {
        AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile");
        this.assetProfileService.saveAssetProfile(assetProfile);
        AssetProfile assetProfile2 = this.createAssetProfile(this.tenantId, "Asset Profile");
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetProfileService.saveAssetProfile(assetProfile2));
    }

    @Test
    public void testSaveAssetProfileWithNameDefaultAndProfileWithIsDefaultAndDifferentNameAlreadyExists() {
        AssetProfile defaultAssetProfile = this.assetProfileService.findDefaultAssetProfile(this.tenantId);
        Assert.assertNotNull((Object)defaultAssetProfile);
        defaultAssetProfile.setName("Asset Profile 1");
        this.assetProfileService.saveAssetProfile(defaultAssetProfile);
        AssetProfile createdAssetProfile = this.assetProfileService.findOrCreateAssetProfile(this.tenantId, "default");
        Assert.assertNotNull((Object)createdAssetProfile);
        Assert.assertEquals((Object)"default", (Object)createdAssetProfile.getName());
        Assert.assertFalse((boolean)createdAssetProfile.isDefault());
    }

    @Test
    public void testDeleteAssetProfileWithExistingAsset() {
        AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile");
        AssetProfile savedAssetProfile = this.assetProfileService.saveAssetProfile(assetProfile);
        Asset asset = new Asset();
        asset.setTenantId(this.tenantId);
        asset.setName("Test asset");
        asset.setAssetProfileId(savedAssetProfile.getId());
        this.assetService.saveAsset(asset);
        org.junit.jupiter.api.Assertions.assertThrows(DataValidationException.class, () -> this.assetProfileService.deleteAssetProfile(this.tenantId, savedAssetProfile.getId()));
    }

    @Test
    public void testDeleteAssetProfile() {
        AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile");
        AssetProfile savedAssetProfile = this.assetProfileService.saveAssetProfile(assetProfile);
        this.assetProfileService.deleteAssetProfile(this.tenantId, savedAssetProfile.getId());
        AssetProfile foundAssetProfile = this.assetProfileService.findAssetProfileById(this.tenantId, savedAssetProfile.getId());
        Assert.assertNull((Object)foundAssetProfile);
    }

    @Test
    public void testFindAssetProfiles() {
        ArrayList<AssetProfile> assetProfiles = new ArrayList<AssetProfile>();
        PageLink pageLink = new PageLink(17);
        PageData pageData = this.assetProfileService.findAssetProfiles(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)1L, (long)pageData.getTotalElements());
        assetProfiles.addAll(pageData.getData());
        for (int i = 0; i < 28; ++i) {
            AssetProfile assetProfile = this.createAssetProfile(this.tenantId, "Asset Profile" + i);
            assetProfiles.add(this.assetProfileService.saveAssetProfile(assetProfile));
        }
        ArrayList loadedAssetProfiles = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.assetProfileService.findAssetProfiles(this.tenantId, pageLink);
            loadedAssetProfiles.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetProfiles, this.idComparator);
        Collections.sort(loadedAssetProfiles, this.idComparator);
        Assert.assertEquals(assetProfiles, loadedAssetProfiles);
        for (AssetProfile assetProfile : loadedAssetProfiles) {
            if (assetProfile.isDefault()) continue;
            this.assetProfileService.deleteAssetProfile(this.tenantId, assetProfile.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.assetProfileService.findAssetProfiles(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)1L, (long)pageData.getTotalElements());
    }

    @Test
    public void testFindAssetProfileInfos() {
        PageData pageData;
        ArrayList<AssetProfile> assetProfiles = new ArrayList<AssetProfile>();
        PageLink pageLink = new PageLink(17);
        PageData assetProfilePageData = this.assetProfileService.findAssetProfiles(this.tenantId, pageLink);
        Assert.assertFalse((boolean)assetProfilePageData.hasNext());
        Assert.assertEquals((long)1L, (long)assetProfilePageData.getTotalElements());
        assetProfiles.addAll(assetProfilePageData.getData());
        for (int i = 0; i < 28; ++i) {
            AssetProfile assetProfile2 = this.createAssetProfile(this.tenantId, "Asset Profile" + i);
            assetProfiles.add(this.assetProfileService.saveAssetProfile(assetProfile2));
        }
        ArrayList loadedAssetProfileInfos = new ArrayList();
        pageLink = new PageLink(17);
        do {
            pageData = this.assetProfileService.findAssetProfileInfos(this.tenantId, pageLink);
            loadedAssetProfileInfos.addAll(pageData.getData());
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
        Collections.sort(assetProfiles, this.idComparator);
        Collections.sort(loadedAssetProfileInfos, this.assetProfileInfoIdComparator);
        List assetProfileInfos = assetProfiles.stream().map(assetProfile -> new AssetProfileInfo((EntityId)assetProfile.getId(), assetProfile.getTenantId(), assetProfile.getName(), assetProfile.getImage(), assetProfile.getDefaultDashboardId())).collect(Collectors.toList());
        Assert.assertEquals(assetProfileInfos, loadedAssetProfileInfos);
        for (AssetProfile assetProfile3 : assetProfiles) {
            if (assetProfile3.isDefault()) continue;
            this.assetProfileService.deleteAssetProfile(this.tenantId, assetProfile3.getId());
        }
        pageLink = new PageLink(17);
        pageData = this.assetProfileService.findAssetProfileInfos(this.tenantId, pageLink);
        Assert.assertFalse((boolean)pageData.hasNext());
        Assert.assertEquals((long)1L, (long)pageData.getTotalElements());
    }

    @Test
    public void testFindAllassetProfilesByTenantId() {
        int assetProfilesCount = 4;
        ArrayList<AssetProfile> assetProfiles = new ArrayList<AssetProfile>(4);
        AssetProfile profileC = this.assetProfileService.saveAssetProfile(this.createAssetProfile(this.tenantId, "profile C"));
        assetProfiles.add(this.assetProfileService.saveAssetProfile(profileC));
        AssetProfile profileA = this.assetProfileService.saveAssetProfile(this.createAssetProfile(this.tenantId, "profile A"));
        assetProfiles.add(this.assetProfileService.saveAssetProfile(profileA));
        AssetProfile profileB = this.assetProfileService.saveAssetProfile(this.createAssetProfile(this.tenantId, "profile B"));
        assetProfiles.add(this.assetProfileService.saveAssetProfile(profileB));
        assetProfiles.add(this.assetProfileService.findDefaultAssetProfile(this.tenantId));
        List sortedProfileInfos = assetProfiles.stream().map(profile -> new EntityInfo((EntityId)profile.getId(), profile.getName())).sorted(Comparator.comparing(EntityInfo::getName)).collect(Collectors.toList());
        List assetProfileInfos = this.assetProfileService.findAssetProfileNamesByTenantId(this.tenantId, false);
        Assertions.assertThat((List)assetProfileInfos).isNotNull();
        Assertions.assertThat((List)assetProfileInfos).hasSize(assetProfilesCount);
        Assertions.assertThat((List)assetProfileInfos).isEqualTo(sortedProfileInfos);
    }

    @Test
    public void testFindActiveOnlyassetProfilesByTenantId() {
        String profileCName = "profile C";
        this.assetProfileService.saveAssetProfile(this.createAssetProfile(this.tenantId, profileCName));
        String profileAName = "profile A";
        this.assetProfileService.saveAssetProfile(this.createAssetProfile(this.tenantId, profileAName));
        String profileBName = "profile B";
        this.assetProfileService.saveAssetProfile(this.createAssetProfile(this.tenantId, profileBName));
        List assetProfileInfos = this.assetProfileService.findAssetProfileNamesByTenantId(this.tenantId, true);
        Assertions.assertThat((List)assetProfileInfos).isNotNull();
        Assertions.assertThat((List)assetProfileInfos).isEmpty();
        Asset assetC = new Asset();
        assetC.setName("Test asset C");
        assetC.setType(profileCName);
        assetC.setTenantId(this.tenantId);
        assetC = this.assetService.saveAsset(assetC);
        Asset assetA = new Asset();
        assetA.setName("Test asset A");
        assetA.setType(profileAName);
        assetA.setTenantId(this.tenantId);
        assetA = this.assetService.saveAsset(assetA);
        Asset assetB = new Asset();
        assetB.setName("Test asset B");
        assetB.setType(profileBName);
        assetB.setTenantId(this.tenantId);
        assetB = this.assetService.saveAsset(assetB);
        assetProfileInfos = this.assetProfileService.findAssetProfileNamesByTenantId(this.tenantId, true);
        List<EntityInfo> expected = List.of(new EntityInfo((EntityId)assetA.getAssetProfileId(), profileAName), new EntityInfo((EntityId)assetB.getAssetProfileId(), profileBName), new EntityInfo((EntityId)assetC.getAssetProfileId(), profileCName));
        Assertions.assertThat((List)assetProfileInfos).isNotEmpty();
        Assertions.assertThat((List)assetProfileInfos).hasSize(3);
        Assertions.assertThat((List)assetProfileInfos).isEqualTo(expected);
    }
}

